/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp.rest;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.rest.CogConfigRestClient;
import com.cognos.dls.smtp.rest.NotificationJSONDataManager;
import com.cognos.dls.smtp.rest.NotificationTenantDataBean;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ServerConfigPropertyUtils;
import com.cognos.jsmcommon.util.UserAccountUtil;

public class DefaultSenderConfig {
    public static String getGlobalDefaultSenderID(BiBusHeader bibusHeader, String defEmailValue) {
        String defaultEmailId = defEmailValue;
        try {
            String serverResponse = CogConfigRestClient.callConfigRestServiceForGlobalDefSender(ServerConfigPropertyUtils.getServerGateWay(), bibusHeader);
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DLS.CogConfigRestClient Response from Config Rest call" + serverResponse);
            NotificationJSONDataManager notificationJsonDbMgr = new NotificationJSONDataManager(serverResponse);
            NotificationTenantDataBean notificationTenantDataBean = notificationJsonDbMgr.getNCdefaultSender();
            if (null != notificationTenantDataBean) {
                String emailObj = notificationTenantDataBean.getDefaultSenderId();
                defaultEmailId = null == emailObj || "null".equals(emailObj) ? defEmailValue : notificationTenantDataBean.getDefaultSenderId();
            } else {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DLS.CogConfigRestClient notificationTenantDataBean is NULL ");
            }
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DLS.CogConfigRestClient gloabal default sender email " + defaultEmailId);
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.WARN, DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{"DLS.CogConfigRestClient " + ex.getMessage()});
        }
        return defaultEmailId;
    }

    public static String getDefaultSenderOfTenant(String tenantId, BiBusHeader bibusHeader, String defEmailValue) {
        String defaultEmailId = defEmailValue;
        try {
            if (tenantId != null && tenantId.length() > 0) {
                String serverResponse = CogConfigRestClient.callConfigRestServiceForTenant(ServerConfigPropertyUtils.getServerGateWay(), bibusHeader, tenantId);
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DLS.CogConfigRestClient Response from Config Rest call" + serverResponse);
                NotificationJSONDataManager notificationJsonDbMgr = new NotificationJSONDataManager(serverResponse);
                NotificationTenantDataBean notificationTenantDataBean = notificationJsonDbMgr.getNCdefaultSender(tenantId);
                if (null != notificationTenantDataBean) {
                    defaultEmailId = notificationTenantDataBean.getDefaultSenderId();
                } else {
                    SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DLS.CogConfigRestClient notificationTenantDataBean is NULL for tennant:" + tenantId);
                }
            }
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DLS.CogConfigRestClient TenantID" + tenantId + " default sender email " + defaultEmailId);
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.WARN, DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{"DLS.CogConfigRestClient " + ex.getMessage()});
        }
        return defaultEmailId;
    }

    public static String getTenantIdFromHeader(BiBusHeader bibusHeader, int readTenantInfoFlag) {
        Account account = new UserAccountUtil(new JobBiBusHeaders(bibusHeader), readTenantInfoFlag).getUserAccount();
        String tenantID = null;
        if (null != account) {
            tenantID = account.getTenantID().getValue();
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DLS:CogConfigRestClient  account " + account.getDefaultName() + " tenant id  " + tenantID);
        }
        return tenantID;
    }
}

