/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp.smtpRules;

import com.cognos.dls.DLSCategory;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.smtpRules.SmtpRuleAction;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.spec.smtpRules.castor.SmtpBehaviour;
import com.cognos.spec.smtpRules.castor.SmtpError;
import com.cognos.spec.smtpRules.castor.SmtpRule;
import com.cognos.spec.smtpRules.castor.SmtpRules;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.InputSource;

public class SmtpActionsManager {
    private static SmtpActionsManager m_instance = null;
    final String CONFIG_FOLDER = "configuration";
    private static String DEFAULT_PROPERTIES_RESOURCE_LOCATION = "/com/cognos/dls/smtp/smtpRules/smtpRules-default.xml";
    private ArrayList m_actionList = new ArrayList();
    private SmtpRules m_smtpRules;
    private SmtpBehaviour m_default_behaviour;

    public static SmtpActionsManager instance() {
        if (m_instance == null || SmtpActionsManager.alwaysReadFile()) {
            m_instance = new SmtpActionsManager();
        }
        return m_instance;
    }

    public static SmtpActionsManager resetInstance() {
        m_instance = new SmtpActionsManager();
        return m_instance;
    }

    static SmtpActionsManager testInstance(String filePath) {
        m_instance = new SmtpActionsManager(filePath);
        return m_instance;
    }

    public SmtpRules getRules() {
        return this.m_smtpRules;
    }

    public SmtpRuleAction[] getActions() {
        return this.m_actionList.toArray(new SmtpRuleAction[0]);
    }

    public SmtpRuleAction getDefaultAction() {
        SmtpRuleAction action = null;
        if (this.m_default_behaviour == null) {
            SmtpBehaviour behaviour = new SmtpBehaviour();
            action = new SmtpRuleAction(new SmtpError(), behaviour);
        } else {
            action = new SmtpRuleAction(new SmtpError(), this.m_default_behaviour);
        }
        return action;
    }

    public SmtpRuleAction getNoMessageAction() {
        return this.getDefaultAction();
    }

    public SmtpRuleAction getTransportFailAction() {
        SmtpRuleAction smtpAction = null;
        SmtpRuleAction[] actions = this.getActions();
        for (int i = 0; i < actions.length; ++i) {
            if (!actions[i].getError().getTransport()) continue;
            smtpAction = actions[i];
            break;
        }
        return smtpAction == null ? this.getDefaultAction() : smtpAction;
    }

    public SmtpRuleAction getNoRecipientsAction(Throwable me) {
        SmtpRuleAction smtpAction = null;
        SmtpRuleAction[] actions = this.getActions();
        for (int i = 0; i < actions.length; ++i) {
            if (!actions[i].matches(me)) continue;
            smtpAction = actions[i];
            break;
        }
        return smtpAction == null ? this.getDefaultAction() : smtpAction;
    }

    public SmtpRuleAction getNoMessagesAction(Exception me) {
        SmtpRuleAction smtpAction = null;
        int i = 0;
        SmtpRuleAction[] actions = this.getActions();
        if (i < actions.length) {
            smtpAction = actions[i];
        }
        return smtpAction == null ? this.getDefaultAction() : smtpAction;
    }

    public SmtpRuleAction getAction(Throwable me) {
        SmtpRuleAction smtpAction = null;
        SmtpRuleAction[] actions = this.getActions();
        for (int i = 0; i < actions.length; ++i) {
            if (!actions[i].matches(me)) continue;
            smtpAction = actions[i];
            break;
        }
        return smtpAction == null ? this.getDefaultAction() : smtpAction;
    }

    private SmtpActionsManager(String filePath) {
        try {
            InputStream stream = SmtpActionsManager.class.getResourceAsStream(filePath);
            InputSource source = new InputSource(stream);
            this.m_smtpRules = this.readRulesFile(source, filePath);
            this.processRules();
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).log(SDSLevel.WARN, DlsI18NCode.MSG_DS_BAD_SMTP_PROPS, new Object[]{filePath, "smtp.rules.properties.location"});
        }
    }

    private SmtpActionsManager() {
        String propsFile = null;
        try {
            propsFile = CRNProperties.getInstance().getProperty("smtp.rules.properties.location");
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug((Throwable)e);
            SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).log(SDSLevel.WARN, DlsI18NCode.MSG_DS_BAD_SMTP_PROPS, new Object[]{"", "smtp.rules.properties.location"});
        }
        try {
            if (propsFile != null && !"".equals(propsFile)) {
                propsFile = this.getSMTPRulesConfigFolderPath(propsFile);
                InputSource source = new InputSource(new FileReader(propsFile));
                this.m_smtpRules = this.readRulesFile(source, propsFile);
            }
        }
        catch (FileNotFoundException e) {
            try {
                InputSource source = new InputSource(SmtpActionsManager.class.getResourceAsStream(propsFile));
                this.m_smtpRules = this.readRulesFile(source, propsFile);
            }
            catch (Throwable t) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).log(SDSLevel.WARN, DlsI18NCode.MSG_DS_BAD_SMTP_PROPS, new Object[]{propsFile, "smtp.rules.properties.location"});
            }
        }
        if (this.m_smtpRules == null) {
            this.m_smtpRules = this.readDefaultRulesFile();
        }
        if (!this.processRules()) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).log(SDSLevel.WARN, DlsI18NCode.MSG_DS_BAD_SMTP_PROPS, new Object[]{propsFile, "smtp.rules.properties.location"});
            this.m_smtpRules = this.readDefaultRulesFile();
            this.processRules();
        }
    }

    private String getSMTPRulesConfigFolderPath(String propsFile) {
        String binDir = CRNProperties.getInstance().getBinDir();
        String configDir = "";
        if (null != binDir && binDir.length() > 0) {
            File binFolder = new File(binDir);
            configDir = binFolder.getParent() + File.separator + "configuration";
        }
        if (null != configDir) {
            propsFile = configDir + File.separator + propsFile;
            SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).debug("SMTP rules file location: " + propsFile);
        }
        return propsFile;
    }

    private boolean processRules() {
        SmtpBehaviour behave;
        SmtpRule rule;
        LinkedHashMap behaviourMap = new LinkedHashMap();
        Enumeration enumeration = this.m_smtpRules.enumerateSmtpRule();
        while (enumeration.hasMoreElements()) {
            rule = (SmtpRule)enumeration.nextElement();
            if (rule.getSmtpRuleChoice().getSmtpBehaviour() == null || this.addToMap(behaviourMap, (behave = rule.getSmtpRuleChoice().getSmtpBehaviour()).getName(), behave)) continue;
            return false;
        }
        enumeration = this.m_smtpRules.enumerateSmtpBehaviour();
        while (enumeration.hasMoreElements()) {
            SmtpBehaviour behave2 = (SmtpBehaviour)enumeration.nextElement();
            if (this.addToMap(behaviourMap, behave2.getName(), behave2)) continue;
            return false;
        }
        this.m_default_behaviour = this.m_smtpRules.getDefaultSmtpBehaviour().getSmtpBehaviour();
        if (!this.addToMap(behaviourMap, this.m_default_behaviour.getName(), this.m_default_behaviour)) {
            return false;
        }
        enumeration = this.m_smtpRules.enumerateSmtpRule();
        while (enumeration.hasMoreElements()) {
            rule = (SmtpRule)enumeration.nextElement();
            behave = null;
            if (rule.getSmtpRuleChoice().getSmtpBehaviour() != null) {
                behave = rule.getSmtpRuleChoice().getSmtpBehaviour();
            } else if (rule.getSmtpRuleChoice().getSmtpBehaviourName() != null) {
                behave = (SmtpBehaviour)behaviourMap.get(rule.getSmtpRuleChoice().getSmtpBehaviourName());
            }
            this.m_actionList.add(new SmtpRuleAction(rule.getSmtpError(), behave));
        }
        return true;
    }

    private boolean addToMap(Map map, String name, Object value) {
        if (map.containsKey(name)) {
            return false;
        }
        map.put(name, value);
        return true;
    }

    private SmtpRules readDefaultRulesFile() {
        String propsFile = DEFAULT_PROPERTIES_RESOURCE_LOCATION;
        InputSource source = new InputSource(SmtpActionsManager.class.getResourceAsStream(DEFAULT_PROPERTIES_RESOURCE_LOCATION));
        return this.readRulesFile(source, propsFile);
    }

    private SmtpRules readRulesFile(InputSource source, String propsFilePath) {
        SmtpRules smtpRules = null;
        try {
            smtpRules = (SmtpRules)Unmarshaller.unmarshal(SmtpRules.class, (InputSource)source);
        }
        catch (MarshalException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).log(SDSLevel.WARN, DlsI18NCode.MSG_DS_BAD_SMTP_PROPS, new Object[]{propsFilePath, "smtp.rules.properties.location"});
        }
        catch (ValidationException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).log(SDSLevel.WARN, DlsI18NCode.MSG_DS_BAD_SMTP_PROPS, new Object[]{propsFilePath, "smtp.rules.properties.location"});
        }
        return smtpRules;
    }

    private static boolean alwaysReadFile() {
        boolean alwaysRead = false;
        String readProp = null;
        try {
            readProp = CRNProperties.getInstance().getProperty("smtp.rules.properties.reread");
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
        if (readProp != null) {
            alwaysRead = Boolean.valueOf(readProp);
        }
        return alwaysRead;
    }
}

