/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp.smtpRules;

import com.cognos.spec.smtpRules.castor.FailMail;
import com.cognos.spec.smtpRules.castor.Recipients;
import com.cognos.spec.smtpRules.castor.SmtpBehaviour;
import com.cognos.spec.smtpRules.castor.SmtpError;
import com.sun.mail.smtp.SMTPAddressFailedException;
import com.sun.mail.smtp.SMTPAddressSucceededException;
import com.sun.mail.smtp.SMTPSendFailedException;
import java.util.ArrayList;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;

public class SmtpRuleAction {
    private SmtpBehaviour m_behaviour;
    private SmtpError m_error;

    SmtpRuleAction(SmtpError error, SmtpBehaviour behaviour) {
        this.m_behaviour = behaviour;
        this.m_error = error;
    }

    public SmtpError getError() {
        return this.m_error;
    }

    public SmtpBehaviour getBehaviour() {
        return this.m_behaviour;
    }

    public boolean acknowledge() {
        return !this.recover() && !this.errorQueue();
    }

    public boolean transport() {
        return this.m_error.getTransport();
    }

    public boolean recover() {
        return this.m_behaviour.getResends() != null;
    }

    public boolean errorQueue() {
        return this.m_behaviour.getKeepMail();
    }

    public boolean failMail() {
        return this.m_behaviour.getFailMail() != null;
    }

    public boolean matches(Throwable me) {
        boolean matches = this.matchesReturnCode(me);
        matches = matches || this.matchesInvalidRecipients(me);
        return matches;
    }

    private boolean matchesReturnCode(Throwable me) {
        if (!this.m_error.hasErrorCode() || this.m_error.getErrorCode() == -1) {
            return false;
        }
        boolean codeMatches = false;
        if (me instanceof SMTPAddressFailedException) {
            SMTPAddressFailedException afe = (SMTPAddressFailedException)me;
            codeMatches = this.matchesReturnCodeFromNestedExceptions(this.m_error.getErrorCode(), afe.getReturnCode(), (MessagingException)afe);
        } else if (me instanceof SMTPSendFailedException) {
            SMTPSendFailedException sfe = (SMTPSendFailedException)me;
            codeMatches = this.matchesReturnCodeFromNestedExceptions(this.m_error.getErrorCode(), sfe.getReturnCode(), (MessagingException)sfe);
        } else if (me instanceof SMTPAddressSucceededException) {
            SMTPAddressSucceededException ase = (SMTPAddressSucceededException)me;
            codeMatches = this.matchesReturnCodeFromNestedExceptions(this.m_error.getErrorCode(), ase.getReturnCode(), (MessagingException)ase);
        } else if (me instanceof MessagingException) {
            MessagingException mex = (MessagingException)me;
            codeMatches = this.matchesReturnCodeFromNestedExceptions(this.m_error.getErrorCode(), -1, mex);
        }
        return codeMatches;
    }

    private boolean matchesReturnCodeFromNestedExceptions(int errorCode, int returnCode, MessagingException me) {
        boolean matches;
        boolean bl = matches = errorCode == returnCode;
        if (!matches && me.getNextException() != null) {
            matches = this.matchesReturnCode(me.getNextException());
        }
        if (!matches && me.getCause() != null) {
            matches = this.matchesReturnCode(me.getCause());
        }
        return matches;
    }

    public boolean matchesInvalidRecipients(Throwable me) {
        if (!this.m_error.hasInvalidRecipients() || !this.m_error.getInvalidRecipients()) {
            return false;
        }
        if (me == null) {
            return true;
        }
        if (!(me instanceof SendFailedException)) {
            return false;
        }
        SendFailedException sfe = (SendFailedException)me;
        Address[] invalids = sfe.getInvalidAddresses();
        return invalids != null && invalids.length > 0;
    }

    public String[] getRecipients() {
        FailMail mail = this.m_behaviour.getFailMail();
        Recipients recips = mail.getRecipients();
        ArrayList<String> recipList = new ArrayList<String>();
        for (int i = 0; i < recips.getRecipientCount(); ++i) {
            recipList.add(recips.getRecipient(i).getAddress());
        }
        return recipList.toArray(new String[0]);
    }

    public boolean sendToOwner() {
        FailMail mail = this.m_behaviour.getFailMail();
        return mail != null && mail.getRecipients().getOwner();
    }

    public boolean sendTocurrentRecipients() {
        FailMail mail = this.m_behaviour.getFailMail();
        Recipients recips = mail != null ? mail.getRecipients() : null;
        return recips == null ? false : recips.getSendToCurrentRecipients();
    }

    public int resendDelay() {
        return this.m_behaviour.getResends().getDelaySeconds();
    }

    public int resends() {
        return this.m_behaviour.getResends().getNumber();
    }
}

