/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp.transport;

import com.cognos.dls.DLSCategory;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.transport.IConnectionPool;
import com.cognos.dls.smtp.transport.TransportConnectionException;
import com.cognos.dls.smtp.transport.TransportConnectionFactory;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Transport;

public class NoConnectionPool
implements IConnectionPool {
    private TransportConnectionFactory m_transportConnectionFactory = null;

    public NoConnectionPool(TransportConnectionFactory transportConnectionFactory) {
        this.m_transportConnectionFactory = transportConnectionFactory;
    }

    @Override
    public Transport getTransport() throws TransportConnectionException {
        Transport transport = null;
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("NoConnectionPool creating connection ");
        try {
            transport = this.m_transportConnectionFactory.getTransport();
            transport.connect();
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("NoConnectionPool created connection ");
        }
        catch (NoSuchProviderException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("NoConnectionPool failed in creating connection " + e.getMessage());
        }
        catch (MessagingException me) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" NoConnectionPool : MessagingException : " + (Object)((Object)me));
            throw new TransportConnectionException(DlsI18NCode.MSG_DS_GENERAL_ERROR, (Object[])new String[]{me.getMessage()}, me);
        }
        return transport;
    }

    @Override
    public void returnTransport(Transport transport) {
        try {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" NoConnectionPool : returnTransport");
            if (transport != null) {
                transport.close();
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("NoConnectionPool failed in closing connection ");
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)e);
        }
        finally {
            transport = null;
        }
    }
}

