/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp.transport;

import com.cognos.dls.DLSCategory;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.transport.IConnectionPool;
import com.cognos.dls.smtp.transport.TransportConnectionException;
import com.cognos.dls.smtp.transport.TransportConnectionFactory;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.tasks.thread.CommonTimerTasks;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TimerTask;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Transport;

public class TransportConnectionPool
implements IConnectionPool {
    private Map m_busyTransports = new HashMap();
    private List m_returnedTransports = new LinkedList();
    private static final long IDLE_TIMEOUT = 5000L;
    private static int MAX_MESSAGES_PER_TRANSPORT = 10;
    private TransportConnectionFactory m_transportConnectionFactory;
    private static boolean CONNECTION_POOL_FORCE_CLEAN = false;

    public TransportConnectionPool(TransportConnectionFactory transportConnectionFactory) {
        this.m_transportConnectionFactory = transportConnectionFactory;
        int val = CRNProperties.getInstance().getIntProperty("max.smtp.messages.per.transport", MAX_MESSAGES_PER_TRANSPORT);
        if (val >= 1) {
            MAX_MESSAGES_PER_TRANSPORT = val;
        }
        CONNECTION_POOL_FORCE_CLEAN = CRNProperties.getInstance().getBoolAdvancedPropertyValue("dls.connection.pool.force.clean", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transport getTransport() throws TransportConnectionException {
        Transport transport = null;
        TransportHandle transportHandle = null;
        try {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : getTransport : 1 : Called ");
            TransportConnectionPool transportConnectionPool = this;
            synchronized (transportConnectionPool) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : getTransport : 2 : m_returnedTransports.size() = " + this.m_returnedTransports != null ? " " + this.m_returnedTransports.size() : " null  : m_returnedTransports + " + this.m_returnedTransports);
                while (this.m_returnedTransports != null && !this.m_returnedTransports.isEmpty()) {
                    try {
                        transportHandle = (TransportHandle)this.m_returnedTransports.remove(0);
                    }
                    catch (Exception ex1) {
                        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : getTransport : 3 : get first transport from pool queue failed. Exception : " + ex1);
                        break;
                    }
                    try {
                        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : getTransport : 4 : transportHandle : " + transportHandle);
                        if (transportHandle != null) {
                            transportHandle.idleTimestamp = -1L;
                            transport = transportHandle.transport;
                            if (transport != null && transport.isConnected()) {
                                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : getTransport : 5 : Found a good transport connection : " + transport);
                                break;
                            }
                        }
                    }
                    catch (Exception ex2) {
                        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : getTransport : 6 : Exception / Error while trying to get a good transport connection : " + transport + " EXCEPTION : " + ex2);
                    }
                    try {
                        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : getTransport : 6.1 : CONNECTION_POOL_FORCE_CLEAN = " + CONNECTION_POOL_FORCE_CLEAN);
                        if (CONNECTION_POOL_FORCE_CLEAN || transport == null) continue;
                        transport.close();
                    }
                    catch (Exception ex3) {
                        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : getTransport : 7 : Exception closing transport connection : " + ex3);
                    }
                    finally {
                        transport = null;
                        transportHandle = null;
                    }
                }
                if (transport == null) {
                    SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : getTransport : 8 : Transport connection not obtained from pool, creating a new connection ");
                    transportHandle = this.createTransportHandle();
                    transport = transportHandle.transport;
                    SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : getTransport : 9 : New Transport connection created : " + transport);
                }
            }
            if (transport != null) {
                if (!transport.isConnected()) {
                    SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : getTransport : 10 : Transport not connected, trying to reconnect ");
                    transport.connect();
                    SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : getTransport : 11 : Transport reconnected ");
                }
                this.m_busyTransports.put(transport, transportHandle);
            }
            ++transportHandle.use_count;
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : getTransport : 12 : transportHandle.use_count " + transportHandle.use_count);
        }
        catch (MessagingException me) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : getTransport : 13 : MessagingException : " + (Object)((Object)me));
            throw new TransportConnectionException(DlsI18NCode.MSG_DS_GENERAL_ERROR, (Object[])new String[]{me.getMessage()}, me);
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : getTransport : 14 : Exception : " + ex);
            throw new TransportConnectionException(DlsI18NCode.MSG_DS_GENERAL_ERROR, (Object[])new String[]{ex.getMessage()}, ex);
        }
        return transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnTransport(Transport transport) {
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : returnTransport : 1 : transport = " + transport);
        if (transport == null) {
            return;
        }
        TransportHandle transportHandle = (TransportHandle)this.m_busyTransports.get(transport);
        this.m_busyTransports.remove(transport);
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : returnTransport : 2 : ");
        if (transport.isConnected() && transportHandle.use_count < MAX_MESSAGES_PER_TRANSPORT) {
            TransportConnectionPool transportConnectionPool = this;
            synchronized (transportConnectionPool) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : returnTransport : 3 : ");
                boolean returnedTransportsWasEmpty = this.m_returnedTransports.isEmpty();
                transportHandle.idleTimestamp = new Date().getTime();
                this.m_returnedTransports.add(transportHandle);
                if (returnedTransportsWasEmpty) {
                    CommonTimerTasks.getInstance().schedule((TimerTask)new MyTimerTask(this), 5000L);
                }
            }
        }
        try {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : returnTransport : 4 : CONNECTION_POOL_FORCE_CLEAN = " + CONNECTION_POOL_FORCE_CLEAN);
            if (!CONNECTION_POOL_FORCE_CLEAN && transport != null) {
                transport.close();
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)e);
        }
        finally {
            transport = null;
            transportHandle = null;
        }
    }

    private TransportHandle createTransportHandle() throws NoSuchProviderException {
        Transport transport = this.m_transportConnectionFactory.getTransport();
        TransportHandle transportHandle = new TransportHandle(transport);
        return transportHandle;
    }

    private class TransportHandle {
        Transport transport;
        long idleTimestamp = -1L;
        int use_count = 0;

        TransportHandle(Transport transport) {
            this.transport = transport;
        }

        public String toString() {
            StringBuffer sb = null;
            String str = "";
            try {
                sb = new StringBuffer();
                sb.append(" [ idleTimestamp = ");
                sb.append(this.idleTimestamp + " : ");
                sb.append(" use_count = ");
                sb.append(this.use_count + " : ");
                sb.append(" transport = ");
                sb.append(this.transport + " ]");
                str = sb.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return str;
        }
    }

    private class MyTimerTask
    extends TimerTask {
        TransportConnectionPool pool;

        public MyTimerTask(TransportConnectionPool pool) {
            this.pool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TransportConnectionPool transportConnectionPool = this.pool;
            synchronized (transportConnectionPool) {
                try {
                    SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : MyTimerTask : run : 1 : m_returnedTransports.size() = " + TransportConnectionPool.this.m_returnedTransports != null ? " " + TransportConnectionPool.this.m_returnedTransports.size() : " null  : m_returnedTransports + " + TransportConnectionPool.this.m_returnedTransports);
                    if (TransportConnectionPool.this.m_returnedTransports.isEmpty()) {
                        return;
                    }
                    Transport transport = null;
                    TransportHandle th = null;
                    long currentTime = new Date().getTime();
                    long idleConnectionTimestamp = -1L;
                    if (TransportConnectionPool.this.m_returnedTransports != null && !TransportConnectionPool.this.m_returnedTransports.isEmpty()) {
                        ListIterator returnedTransportsIterator = TransportConnectionPool.this.m_returnedTransports.listIterator();
                        while (returnedTransportsIterator != null && returnedTransportsIterator.hasNext()) {
                            th = (TransportHandle)returnedTransportsIterator.next();
                            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : MyTimerTask : run : 2 :  : transportHandler th = " + th);
                            if (th != null) {
                                currentTime = new Date().getTime();
                                idleConnectionTimestamp = th.idleTimestamp;
                                transport = th.transport;
                                if (transport != null) {
                                    if (!transport.isConnected() || currentTime - idleConnectionTimestamp > 5000L) {
                                        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : MyTimerTask : run : 3 : transport has timed out so remove transport handle from pool");
                                        returnedTransportsIterator.remove();
                                        try {
                                            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : MyTimerTask : run : 3.1 : CONNECTION_POOL_FORCE_CLEAN = " + CONNECTION_POOL_FORCE_CLEAN);
                                            if (!CONNECTION_POOL_FORCE_CLEAN) {
                                                transport.close();
                                            }
                                            transport = null;
                                            th = null;
                                        }
                                        catch (MessagingException e) {
                                            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : MyTimerTask : run : 4 : MessagingException : " + (Object)((Object)e));
                                            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)e);
                                        }
                                        catch (Exception ex) {
                                            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : MyTimerTask : run : 5 : MessagingException : " + ex);
                                            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)ex);
                                        }
                                        finally {
                                            transport = null;
                                            th = null;
                                        }
                                    }
                                } else {
                                    SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : MyTimerTask : run : 6 : transport is null so remove transport handle from pool");
                                    returnedTransportsIterator.remove();
                                    th = null;
                                }
                            } else {
                                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : MyTimerTask : run : 7 : transport handle is null so remove transport from pool ");
                                returnedTransportsIterator.remove();
                            }
                            transport = null;
                            th = null;
                        }
                    }
                    if (!TransportConnectionPool.this.m_returnedTransports.isEmpty()) {
                        th = (TransportHandle)TransportConnectionPool.this.m_returnedTransports.get(0);
                        idleConnectionTimestamp = th.idleTimestamp;
                        long delay = currentTime - idleConnectionTimestamp;
                        CommonTimerTasks.getInstance().schedule((TimerTask)new MyTimerTask(this.pool), delay);
                    }
                }
                catch (IllegalStateException e) {
                    SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : MyTimerTask : run : 8 : IllegalStateException : " + e);
                    SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
                }
                catch (Exception e) {
                    SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" TransportConnectionPool : MyTimerTask : run : 9 : Exception : " + e);
                    SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
                }
            }
        }
    }
}

