/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.util;

import com.cognos.developer.schemas.bibus._3.Base64BinaryMIMEProp;
import com.cognos.developer.schemas.bibus._3.BaseAgentDefinition;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseReport;
import com.cognos.developer.schemas.bibus._3.DocumentContent;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartComposite;
import com.cognos.developer.schemas.bibus._3.MemoPartMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.MemoPartObject;
import com.cognos.developer.schemas.bibus._3.NmtokenProp;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SmtpContentDispositionEnum;
import com.cognos.developer.schemas.bibus._3.SmtpContentTypeEnum;
import com.cognos.developer.schemas.bibus._3.URL;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.AbstractMemoObjectbuilder;
import com.cognos.dls.smtp.DocumentContentMemoObjectBuilder;
import com.cognos.dls.smtp.EmailOptionsDeliverable;
import com.cognos.dls.smtp.FaultedMemoObjectBuilder;
import com.cognos.dls.smtp.MemoObjectBuilderFactory;
import com.cognos.dls.smtp.MimeMessageBuilderException;
import com.cognos.dls.smtp.MimeTextEncoder;
import com.cognos.dls.smtp.QueryRepliesHandler;
import com.cognos.dls.util.IAttachmentsProcessor;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;

public class CMAttachmentsProcessor
implements IAttachmentsProcessor {
    @Override
    public void processAttachment(MimePart bp, MemoPartObject mpo, String emailEncoding, EmailOptionsDeliverable eod, MimeTextEncoder mimeTextEncoder) throws MimeMessageBuilderException {
        SearchPathSingleObject searchPath = mpo.getSearchPath();
        QueryRepliesHandler replies = eod.getMemoPartObjectAttachments(searchPath);
        AbstractMemoObjectbuilder builder = null;
        BaseClass baseClass = replies.getBase();
        builder = baseClass != null ? MemoObjectBuilderFactory.getBuilder(replies.getBase().getObjectClass().getValue(), emailEncoding, eod, mimeTextEncoder) : new FaultedMemoObjectBuilder(emailEncoding, eod, mimeTextEncoder);
        bp = ((AbstractMemoObjectbuilder)builder).buildAttachment(bp, mpo, replies);
    }

    @Override
    public void retrieveAttachment(MemoPartObject mpo, EmailOptionsDeliverable eod) throws MimeMessageBuilderException {
        SearchPathSingleObject searchPath = mpo.getSearchPath();
        QueryReply baseReply = this.getObjectFromCM(searchPath, eod, mpo);
        QueryRepliesHandler replies = new QueryRepliesHandler(new QueryReply[]{baseReply});
        if (!(replies.getBase() instanceof Output)) {
            SearchPathSingleObject eventOutputPath;
            QueryReply eventOutputReply;
            if (replies.getBase() instanceof DocumentContent) {
                Guid periodicalStoreID = DocumentContentMemoObjectBuilder.getPeriodicalGuid(replies.getBase());
                BaseClass periodicalProducerBaseClass = DocumentContentMemoObjectBuilder.getPeriodicalProducer(eod.getHeader(), periodicalStoreID);
                QueryReply producerReply = new QueryReply();
                producerReply.setQueryResult(new BaseClass[]{periodicalProducerBaseClass});
                replies = new QueryRepliesHandler(new QueryReply[]{baseReply, null, null, producerReply});
            } else if (replies.getBase() instanceof BaseReport) {
                SearchPathSingleObject outputPath = ObjectModelUtil.changeAgentpathsToAgentOutputPaths((SearchPathSingleObject)searchPath, (String)"MHT");
                QueryReply outputReply = this.getObjectFromCM(outputPath, eod, mpo);
                if (outputReply != null) {
                    replies = new QueryRepliesHandler(new QueryReply[]{baseReply, outputReply});
                }
            } else if (!(replies.getBase() instanceof URL) && replies.getBase() instanceof BaseAgentDefinition && (eventOutputReply = this.getObjectFromCM(eventOutputPath = ObjectModelUtil.changeAgentpathsToAgentOutputPaths((SearchPathSingleObject)searchPath, (String)"MHT"), eod, mpo)) != null) {
                replies = new QueryRepliesHandler(new QueryReply[]{baseReply, null, eventOutputReply});
            }
        }
        eod.addMemoPartObjectAttachments(searchPath, replies);
    }

    private QueryReply getObjectFromCM(SearchPathSingleObject spso, EmailOptionsDeliverable eod, MemoPartObject mpo) {
        PropEnum[] properties = new PropEnum[]{PropEnum.defaultName, PropEnum.dataSize, PropEnum.searchPath, PropEnum.dataType, PropEnum.format, PropEnum.ancestors, PropEnum.burstKey, PropEnum.locale, PropEnum.defaultOutputFormat, PropEnum.uri, PropEnum.objectClass};
        QueryReply reply = this.getObject(spso, eod, properties);
        return reply == null ? new QueryReply() : reply;
    }

    @Override
    public void loadAllAttachments(Set<Map.Entry<SearchPathSingleObject, BaseClass>> entrySet, EmailOptionsDeliverable eod) {
        HashMap holderMap;
        QueryRequest[] requests;
        QueryReply[] reply;
        if (eod == null) {
            return;
        }
        PropEnum[] properties = new PropEnum[]{PropEnum.data, PropEnum.defaultName, PropEnum.dataSize, PropEnum.searchPath, PropEnum.dataType, PropEnum.format, PropEnum.ancestors, PropEnum.burstKey, PropEnum.locale, PropEnum.defaultOutputFormat, PropEnum.uri, PropEnum.objectClass};
        if (entrySet != null && entrySet.size() > 0 && (reply = this.callCM(eod, requests = this.buildRequests(entrySet, properties, holderMap = new HashMap()))) != null) {
            for (int i = 0; i < reply.length; ++i) {
                Base64BinaryMIMEProp data;
                BaseClass bc = this.getBaeClassFromReply(reply[i]);
                if (bc instanceof Output) {
                    data = ((Output)bc).getData();
                    Output output = (Output)holderMap.get(bc.getSearchPath().getValue());
                    output.setData(data);
                    continue;
                }
                if (!(bc instanceof DocumentContent)) continue;
                data = ((DocumentContent)bc).getData();
                DocumentContent content = (DocumentContent)holderMap.get(bc.getSearchPath().getValue());
                content.setData(data);
            }
        }
    }

    private QueryRequest[] buildRequests(Set<Map.Entry<SearchPathSingleObject, BaseClass>> entrySet, PropEnum[] properties, Map holder) {
        ArrayList<QueryRequest> requestsList = new ArrayList<QueryRequest>();
        Iterator<Map.Entry<SearchPathSingleObject, BaseClass>> itr = entrySet.iterator();
        while (itr.hasNext()) {
            BaseClass bc = itr.next().getValue();
            Base64BinaryMIMEProp dataProp = null;
            if (bc instanceof Output) {
                dataProp = ((Output)bc).getData();
            } else if (bc instanceof DocumentContent) {
                dataProp = ((DocumentContent)bc).getData();
            }
            if (dataProp != null || bc.getSearchPath() == null || bc.getSearchPath().getValue() == null) continue;
            String searchPath = bc.getSearchPath().getValue();
            QueryRequest baseRequest = new QueryRequest();
            baseRequest.setSearch(searchPath);
            baseRequest.setProperties(properties);
            requestsList.add(baseRequest);
            holder.put(searchPath, bc);
        }
        return requestsList.toArray(new QueryRequest[0]);
    }

    private BaseClass getBaeClassFromReply(QueryReply reply) {
        BaseClass[] baseClasses = null;
        if (reply != null && (baseClasses = reply.getQueryResult()) != null && baseClasses.length > 0) {
            return baseClasses[0];
        }
        return null;
    }

    private QueryReply getObject(SearchPathSingleObject spso, EmailOptionsDeliverable eod, PropEnum[] properties) {
        String searchPath = spso.get_value();
        if (searchPath == null || searchPath.equals("")) {
            return null;
        }
        QueryRequest baseRequest = new QueryRequest();
        baseRequest.setSearch(searchPath);
        baseRequest.setProperties(properties);
        QueryRequest[] requests = new QueryRequest[]{baseRequest};
        QueryReply[] replies = this.callCM(eod, requests);
        return replies == null || replies.length == 0 ? new QueryReply() : replies[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryReply[] callCM(EmailOptionsDeliverable eod, QueryRequest[] requests) {
        QueryReply[] replies = null;
        ContentManagerServiceClientPort cmPort = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(eod.getHeader()));
        try {
            replies = cmPort.queryMultiple(requests);
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_ATTACHMENT_PROCESSING_ERROR);
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)e);
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_ATTACHMENT_PROCESSING_ERROR);
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)e);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return replies;
    }

    @Override
    public MemoPartComposite unPackMHT(QueryRepliesHandler replies) throws MimeMessageBuilderException {
        MemoPartComposite mpc = null;
        try {
            byte[] bytes = this.getData(replies);
            if (bytes.length > 0) {
                mpc = new MemoPartComposite();
                mpc.setContentDisposition(SmtpContentDispositionEnum.inline);
                mpc.setContentType(SmtpContentTypeEnum.related);
                MimeBodyPart mbp = new MimeBodyPart((InputStream)new ByteArrayInputStream(bytes));
                Object obj = mbp.getContent();
                ArrayList<MemoPartMIMEAttachment> memoList = new ArrayList<MemoPartMIMEAttachment>();
                if (obj instanceof String) {
                    MemoPartMIMEAttachment mpma = new MemoPartMIMEAttachment();
                    mpma.setContentDisposition(SmtpContentDispositionEnum.inline);
                    mpma.setData(bytes);
                    mpma.setDataSize(new BigInteger(String.valueOf(bytes.length)));
                    mpma.setDataType("text/plain; charset=utf-8");
                    memoList.add(mpma);
                } else if (obj instanceof MimeMultipart) {
                    MimeMultipart mmp = (MimeMultipart)obj;
                    int partsCount = mmp.getCount();
                    for (int i = 0; i < partsCount; ++i) {
                        String[] contentID;
                        BodyPart bodyPart = mmp.getBodyPart(i);
                        InputStream content = bodyPart.getInputStream();
                        byte[] partBytes = this.readFromInputStream(content);
                        MemoPartMIMEAttachment mpma = new MemoPartMIMEAttachment();
                        mpma.setContentDisposition(SmtpContentDispositionEnum.inline);
                        String type = bodyPart.getContentType();
                        boolean isHTML = type != null ? type.indexOf("html") > 0 : false;
                        String[] contentLocation = bodyPart.getHeader("Content-Location");
                        if (contentLocation != null && contentLocation.length > 0 && !isHTML) {
                            mpma.setContentLocation(contentLocation[0]);
                        }
                        if ((contentID = bodyPart.getHeader("Content-ID")) != null && contentID.length > 0) {
                            mpma.setContentID(contentID[0]);
                        }
                        mpma.setData(partBytes);
                        mpma.setDataSize(new BigInteger(String.valueOf(partBytes.length)));
                        mpma.setDataType(bodyPart.getContentType());
                        memoList.add(mpma);
                    }
                }
                mpc.setParts(memoList.toArray(new MemoPart[0]));
            }
        }
        catch (MessagingException e) {
            throw new MimeMessageBuilderException(DlsI18NCode.MSG_DS_ATTACHMENT_PROCESSING_ERROR, e);
        }
        catch (IOException e) {
            throw new MimeMessageBuilderException(DlsI18NCode.MSG_DS_ATTACHMENT_PROCESSING_ERROR, e);
        }
        return mpc;
    }

    private byte[] getData(QueryRepliesHandler replies) {
        DocumentContent output;
        BaseClass bc = replies.getBase();
        byte[] result = new byte[]{};
        if (bc instanceof Output) {
            Output output2 = (Output)bc;
            if (this.isMHT(output2.getFormat())) {
                result = output2.getData().getValue();
            }
        } else if (replies.getEventOutput() instanceof Output) {
            Output output3 = (Output)bc;
            if (this.isMHT(output3.getFormat())) {
                result = output3.getData().getValue();
            }
        } else if (replies.getOutput() instanceof Output) {
            Output output4 = (Output)bc;
            if (this.isMHT(output4.getFormat())) {
                result = output4.getData().getValue();
            }
        } else if (replies.getPeriodical() instanceof DocumentContent && this.isMHT((output = (DocumentContent)bc).getFormat())) {
            result = output.getData().getValue();
        }
        return result;
    }

    @Override
    public boolean isMHT(NmtokenProp property) {
        return property != null && property.getValue() != null && property.getValue().equalsIgnoreCase("MHT");
    }

    private byte[] readFromInputStream(InputStream is) throws IOException {
        byte[] temp = new byte[102400];
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        int bytesRead = 0;
        while ((bytesRead = is.read(temp)) != -1) {
            bao.write(temp, 0, bytesRead);
        }
        return bao.toByteArray();
    }
}

