/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.util;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.AncestorInfo;
import com.cognos.developer.schemas.bibus._3.AncestorInfoArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Contact;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.util.IEmailRetriever;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CMEmailRetriever
implements IEmailRetriever {
    public static final String EMAIL_ADDRESS_LIST = "emailaddresslist";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, List<String>> getAddresses(BiBusHeader header, SearchPathSingleObject objectPath, SearchPathMultipleObject[] addrSearchPaths) throws EMFSecurityException, SDKClientException {
        BaseClass objectBaseClass;
        AncestorInfoArrayProp ancestorInfoArrayProp;
        AncestorInfo[] ancestorInfoArray;
        AncestorInfo ancestorInfo;
        BaseClass[] objects;
        HashMap<String, List<String>> recipientMap = new HashMap<String, List<String>>();
        QueryRequest[] requests = new QueryRequest[objectPath == null ? addrSearchPaths.length : addrSearchPaths.length + 1];
        ArrayList<String> cpnsUserSearchPathList = new ArrayList<String>(addrSearchPaths.length);
        for (int i = 0; i < addrSearchPaths.length; ++i) {
            requests[i] = new QueryRequest();
            String addressSP = addrSearchPaths[i].get_value();
            requests[i].setSearch("expandDistributionMembers(" + addressSP + ")");
            requests[i].setProperties(new PropEnum[]{PropEnum.email, PropEnum.notificationEMail, PropEnum.storeID, PropEnum.mobileDeviceID, PropEnum.searchPath});
            if (cpnsUserSearchPathList.contains(addressSP)) continue;
            cpnsUserSearchPathList.add(addressSP);
        }
        if (objectPath != null) {
            requests[addrSearchPaths.length] = new QueryRequest();
            requests[addrSearchPaths.length].setSearch(objectPath.get_value());
            requests[addrSearchPaths.length].setProperties(new PropEnum[]{PropEnum.ancestors, PropEnum.objectClass});
        }
        ContentManagerServiceClientPort cmPort = null;
        QueryReply[] replys = new QueryReply[]{};
        try {
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            cmPort = Client.instance().getContentManagerServiceClient(headers);
            cmPort.signNextRequest("DLS");
            replys = cmPort.queryMultiple(requests);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        boolean wo481memo = false;
        if (objectPath != null && (objects = replys[addrSearchPaths.length].getQueryResult()) != null && objects.length == 1 && (ancestorInfo = (ancestorInfoArray = (ancestorInfoArrayProp = (objectBaseClass = objects[0]).getAncestors()).getValue())[ancestorInfoArray.length - 1]).getObjectClass().getValue().equals("reportDataServiceAgentDefinition") && objectBaseClass.getObjectClass().getValue().getValue().equals("memo")) {
            wo481memo = true;
        }
        ArrayList<String> addrList = new ArrayList<String>(addrSearchPaths.length);
        for (int i = 0; i < addrSearchPaths.length; ++i) {
            BaseClass[] baseClasses = replys[i].getQueryResult();
            for (int j = 0; j < baseClasses.length; ++j) {
                String msg;
                Contact contact;
                String emailAddr = null;
                if (baseClasses[j] instanceof Account) {
                    Account account = (Account)baseClasses[j];
                    if (wo481memo && account.getNotificationEMail() != null && account.getNotificationEMail().getValue() != null && account.getNotificationEMail().getValue().get_value() != null) {
                        emailAddr = account.getNotificationEMail().getValue().get_value();
                    }
                    if (emailAddr == null && account.getEmail() != null && account.getEmail().getValue() != null) {
                        emailAddr = account.getEmail().getValue();
                    }
                } else if (baseClasses[j] instanceof Contact && (contact = (Contact)baseClasses[j]) != null && contact.getEmail() != null && contact.getEmail().getValue() != null) {
                    emailAddr = contact.getEmail().getValue();
                }
                if (emailAddr != null) {
                    if (!addrList.contains(emailAddr)) {
                        addrList.add(emailAddr);
                        continue;
                    }
                    msg = "email address returned for cm query request with searchPath: " + requests[i].getSearch() + " is a duplicate - ignoring";
                    SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(msg);
                    continue;
                }
                msg = "no email address returned for cm query request with searchPath: " + requests[i].getSearch() + " - ignoring";
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(msg);
            }
        }
        recipientMap.put(EMAIL_ADDRESS_LIST, addrList);
        return recipientMap;
    }
}

