/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.util;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.MemoPartObjectLinks;
import com.cognos.developer.schemas.bibus._3.ObjectLink;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.AbstractMemoObjectbuilder;
import com.cognos.dls.smtp.EmailOptionsDeliverable;
import com.cognos.dls.smtp.MemoObjectBuilderFactory;
import com.cognos.dls.smtp.MimeMessageBuilderException;
import com.cognos.dls.smtp.MimeTextEncoder;
import com.cognos.dls.smtp.ProcessedLinks;
import com.cognos.dls.util.ILinksProcessor;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;

public class CMLinksProcessor
implements ILinksProcessor {
    @Override
    public ProcessedLinks processLinks(MemoPartObjectLinks mpol, String emailEncoding, EmailOptionsDeliverable eod, MimeTextEncoder mimeTextEncoder) throws MimeMessageBuilderException {
        ProcessedLinks processedLinks = new ProcessedLinks();
        ObjectLink[] links = mpol.getLinks();
        for (int i = 0; i < links.length; ++i) {
            ObjectLink link = links[i];
            ClassEnum classEnum = link.getObjectClass();
            if (null == classEnum && null == (classEnum = this.getClassType(link.getSearchPath(), eod))) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_LINK_TYPE_NOT_FOUND_WILL_CONTINUE);
            }
            AbstractMemoObjectbuilder builder = MemoObjectBuilderFactory.getBuilder(classEnum, emailEncoding, eod, mimeTextEncoder);
            ProcessedLinks oneProcessedLink = new ProcessedLinks();
            if (null != builder) {
                oneProcessedLink = builder.buildLink(link);
            }
            if (null == oneProcessedLink) continue;
            processedLinks.appendLink(oneProcessedLink);
        }
        return processedLinks;
    }

    private ClassEnum getClassType(SearchPathSingleObject searchPath, EmailOptionsDeliverable eod) {
        ClassEnum xenum = null;
        BaseClass base = this.getBaseClass(searchPath, eod);
        if (base != null) {
            xenum = base.getObjectClass().getValue();
        }
        return xenum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseClass getBaseClass(SearchPathSingleObject searchPath, EmailOptionsDeliverable eod) {
        BaseClass base = null;
        if (null != searchPath && searchPath.get_value() != null) {
            ContentManagerServiceClientPort cmPort = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(eod.getHeader()));
            try {
                BaseClass[] baseClasses = cmPort.query(searchPath.get_value(), new PropEnum[]{PropEnum.searchPath, PropEnum.objectClass}, new Sort[0], new QueryOptions());
                if (baseClasses != null && baseClasses.length == 1) {
                    base = baseClasses[0];
                }
            }
            catch (SDKClientException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_GENERATING_LABEL_ERROR_WILL_CONTINUE);
            }
            catch (EMFSecurityException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_GENERATING_LABEL_ERROR_WILL_CONTINUE);
            }
            finally {
                if (cmPort != null) {
                    cmPort.close();
                }
            }
        }
        return base;
    }
}

