/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.util;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.RunTimeState;
import com.cognos.dls.DLSCategory;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CPNSDeviceInfoQuery {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> makeCMQueryForDeviceInfo(BiBusHeader header, ArrayList<String> mobileDeviceSearchPaths) throws Exception {
        ArrayList<QueryRequest> runTimeStateRequests = this.createRunTimeStateQueryRequests(mobileDeviceSearchPaths);
        ContentManagerServiceClientPort cmPort = null;
        QueryReply[] runtimeStateReplyListFromCM = new QueryReply[]{};
        try {
            JobBiBusHeaders headers = new JobBiBusHeaders();
            cmPort = Client.instance().getContentManagerServiceClient(headers);
            cmPort.signNextRequest("DLS");
            QueryRequest[] runTimeStateRequestsArray = new QueryRequest[runTimeStateRequests.size()];
            runTimeStateRequests.toArray(runTimeStateRequestsArray);
            runtimeStateReplyListFromCM = cmPort.queryMultiple(runTimeStateRequestsArray);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        ArrayList<String> mobileDeviceIds = this.getUserDeviceIdsFromQueryReply(runtimeStateReplyListFromCM);
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Found mobileDeviceIds " + mobileDeviceIds);
        return mobileDeviceIds;
    }

    private ArrayList<String> getUserDeviceIdsFromQueryReply(QueryReply[] queryReply) {
        ArrayList<String> mobileDeviceIds = new ArrayList<String>();
        for (QueryReply runtimeStateReplyFromCM : queryReply) {
            BaseClass[] replyClasses;
            for (BaseClass baseClasses : replyClasses = runtimeStateReplyFromCM.getQueryResult()) {
                String deviceId;
                String runTimeStateForId;
                RunTimeState runTimeState;
                if (!(baseClasses instanceof RunTimeState) || null == (runTimeState = (RunTimeState)baseClasses) || null == (runTimeStateForId = runTimeState.getState().getValue()) || (deviceId = this.getDeviceIdFromJson(runTimeStateForId)) == null) continue;
                mobileDeviceIds.add(deviceId);
            }
        }
        return mobileDeviceIds;
    }

    private ArrayList<QueryRequest> createRunTimeStateQueryRequests(ArrayList<String> mobileDeviceSearchPaths) throws Exception {
        ArrayList<QueryRequest> runTimeStateRequests = new ArrayList<QueryRequest>();
        for (String mobileDeviceSearchPath : mobileDeviceSearchPaths) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Found mobileDeviceRuntimeStateSearchPath " + mobileDeviceSearchPath);
            QueryRequest queryRequest = new QueryRequest();
            queryRequest.setSearch(mobileDeviceSearchPath);
            queryRequest.setProperties(new PropEnum[]{PropEnum.state});
            runTimeStateRequests.add(queryRequest);
        }
        return runTimeStateRequests;
    }

    public String getDeviceIdFromJson(String mobileDeviceJsonString) {
        String userDeviceId = null;
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("mobile device json " + mobileDeviceJsonString);
        try {
            JSONObject obj2;
            String deviceId;
            JSONArray obj1 = JSONArray.parse((String)mobileDeviceJsonString);
            if (obj1.size() > 0 && null != (deviceId = (String)(obj2 = (JSONObject)obj1.get(0)).get((Object)"deviceId")) && deviceId.length() > 0) {
                userDeviceId = "\"" + deviceId + "\"";
            }
        }
        catch (IOException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).error("failed to read mobile device json " + mobileDeviceJsonString + e.getMessage());
        }
        return userDeviceId;
    }
}

