/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.util;

import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class DLSFileNameUtil {
    public static String addExtraParamToFilename(String filename) {
        try {
            filename = DLSFileNameUtil.appendTimestampToFilename(filename, DLSFileNameUtil.isMailAttachmentFileNameTimestampEnabled(), DLSFileNameUtil.getMailAttachmentFileNameTimestampFormat());
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("DLSUtil : addExtraParamToFilename : error adding extra param to file name");
        }
        return filename;
    }

    public static String appendTimestampToFilename(String filename, boolean isAttachmentTimestampEnabled, String userTimestampFormat) {
        block9: {
            String timestampFormat = "yyyy-MM-dd";
            SimpleDateFormat dateFormat = null;
            try {
                if (!isAttachmentTimestampEnabled) break block9;
                try {
                    if (userTimestampFormat != null && userTimestampFormat.trim().length() != 0) {
                        dateFormat = new SimpleDateFormat(userTimestampFormat);
                    }
                }
                catch (Exception e) {
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("DLSUtil: addExtraParamToFilename : DLS_MAIL_ATTACHMENT_TIMESTAMP_FORMAT property is wrong, use a valid value e.g. yyyy-MM-dd");
                }
                if (null == dateFormat) {
                    dateFormat = new SimpleDateFormat(timestampFormat);
                }
                Calendar cal = Calendar.getInstance();
                if (filename != null && filename.length() > 0) {
                    if (filename.indexOf(".") != -1) {
                        String filenm = filename.substring(0, filename.lastIndexOf("."));
                        String fileext = filename.substring(filename.lastIndexOf("."));
                        filename = filenm + "-" + dateFormat.format(cal.getTime()) + fileext;
                    } else {
                        filename = filename + "-" + dateFormat.format(cal.getTime());
                    }
                }
            }
            catch (Exception e) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("DLSUtil : addExtraParamToFilename : error adding extra param to file name");
            }
        }
        return filename;
    }

    public static boolean isMailAttachmentFileNameTimestampEnabled() {
        boolean isAttachmentTimestampEnabled = false;
        try {
            isAttachmentTimestampEnabled = Boolean.valueOf(CRNProperties.getInstance().getProperty("emf.dls.attachment.timestamp.enabled"));
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("DLSUtil : isMailAttachmentFileNameTimestampEnabled : error getting DLS_MAIL_ATTACHMENT_TIMESTAMP_ENABLED property value");
        }
        return isAttachmentTimestampEnabled;
    }

    public static String getMailAttachmentFileNameTimestampFormat() {
        String mailAttachmentFileNameTimestampFormat = null;
        try {
            mailAttachmentFileNameTimestampFormat = CRNProperties.getInstance().getProperty("emf.dls.attachment.timestamp.format");
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("DLSUtil : getMailAttachmentFileNameTimestampFormat : error getting DLS_MAIL_ATTACHMENT_TIMESTAMP_ENABLED property value");
        }
        return mailAttachmentFileNameTimestampFormat;
    }
}

