/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.util;

import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.util.DataSizeChecker;

public final class EmailLimits {
    public static double FLUFF_FACTOR = 1.0;
    public static String SERVICE_NAME = "";
    public static boolean m_BatchReportServiceEnabled = true;

    public static void isBatchReportServiceEnabled(boolean status) {
        m_BatchReportServiceEnabled = status;
    }

    public static long getTotalSizeLimit() {
        return Math.round(EmailLimits.getTotalSizeLimitMB() * 1048576.0 / FLUFF_FACTOR);
    }

    private static double getTotalSizeLimitMB() {
        double brsSizeLimitMB = DataSizeChecker.getPropertySizeLimitValue((String)"brsMaximumEMailAttachmentSize");
        double dlsSizeLimitMB = DataSizeChecker.getPropertySizeLimitValue((String)"dsMaximumEMailSize");
        if (m_BatchReportServiceEnabled) {
            if (brsSizeLimitMB != 0.0 && dlsSizeLimitMB != 0.0) {
                if (brsSizeLimitMB < dlsSizeLimitMB) {
                    SERVICE_NAME = "Batch Report service";
                    return brsSizeLimitMB;
                }
                SERVICE_NAME = "Delivery service";
                return dlsSizeLimitMB;
            }
            if (brsSizeLimitMB == 0.0 && dlsSizeLimitMB != 0.0) {
                SERVICE_NAME = "Delivery service";
                return dlsSizeLimitMB;
            }
            if (brsSizeLimitMB != 0.0 && dlsSizeLimitMB == 0.0) {
                SERVICE_NAME = "Batch Report service";
                return brsSizeLimitMB;
            }
            return dlsSizeLimitMB;
        }
        return dlsSizeLimitMB;
    }

    public static String packageTotalSizeLimitMB() {
        double d = EmailLimits.getTotalSizeLimitMB();
        long l = Math.round(d);
        if ((double)l == d) {
            return Long.toString(l);
        }
        return Double.toString(d);
    }

    public static boolean exceedsTotalSizeLimit(long size) {
        return !DataSizeChecker.checkSize((long)size, (long)EmailLimits.getTotalSizeLimit());
    }

    public static long getUncompressedAttachmentLimit() {
        double limit = DataSizeChecker.getPropertySizeLimitValue((String)"dsCompressAttachmentLimit");
        return Math.round(limit * 1048576.0 / FLUFF_FACTOR);
    }

    public static boolean exceedsUncompressedAttachmentLimit(long size) {
        return !DataSizeChecker.checkSize((long)size, (long)EmailLimits.getUncompressedAttachmentLimit());
    }

    public static void setLimits(double attachmentLimit, double zipLimit) {
        CRNProperties.getInstance().setProperty("dsMaximumEMailSize", String.valueOf(attachmentLimit));
        CRNProperties.getInstance().setProperty("dsCompressAttachmentLimit", String.valueOf(zipLimit));
    }

    public static void setLimits(double attachmentLimit, double zipLimit, double brssizelimit) {
        CRNProperties.getInstance().setProperty("dsMaximumEMailSize", String.valueOf(attachmentLimit));
        CRNProperties.getInstance().setProperty("dsCompressAttachmentLimit", String.valueOf(zipLimit));
        CRNProperties.getInstance().setProperty("brsMaximumEMailAttachmentSize", String.valueOf(brssizelimit));
    }

    public static void clearLimits() {
        CRNProperties.getInstance().removeProperty((Object)"dsMaximumEMailSize");
        CRNProperties.getInstance().removeProperty((Object)"dsCompressAttachmentLimit");
    }
}

