/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.util;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CookieVar;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.RunTimeState;
import com.cognos.dls.DLSCategory;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ServerConfigPropertyUtils;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.bi.rest.RESTClientFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.apache.commons.httpclient.Cookie;

public class PinboardClient {
    private static final SDSLogger AUDIT_LOGGER = SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT);
    private static final String MOBILE_DEVICE_RUNTIME_STATE_NAME = "mobileDevice";
    private static final String SUBSCRIBER_ACCOUNT_SEARCH_PATH_KEY = "accountSearchPath";
    private static final String SUBSCRIBER_MOBILE_DEVICE_SEARCH_PATH_KEY = "mobileDeviceSearchPath";
    private static final String PINBOARD_SERVICE_ENDPOINT = "/mobile-gateway/pinboard-service/pinboards";
    private static final String COOKIE_XSRF_TOKEN = "XSRF-TOKEN";
    private static final String COOKIE_PATH_BI_V1 = "/bi/v1";
    private static final String CAM_PASSPORT = "cam_passport";
    private static final String USERSESSIONID = "usersessionid";
    private static final String USER_CAPABILITIES = "userCapabilities";
    private static final String COOKIE_PATH_BI = "/bi";
    private static final String XSRF_TOKEN = "XSRF-TOKEN";

    public static String queryMobileDeviceSearchPath(JobBiBusHeaders biBusHeaders, String userAccountSearchPath) throws Exception {
        String mobileDeviceSearchPath = userAccountSearchPath + "/runTimeState[@name='" + MOBILE_DEVICE_RUNTIME_STATE_NAME + "']";
        PropEnum[] props = new PropEnum[]{PropEnum.storeID};
        BaseClass[] bc = null;
        ContentManagerServiceClientPort cmPort = null;
        try {
            cmPort = Client.instance().getContentManagerServiceClient(biBusHeaders);
            cmPort.signNextRequest("DLS");
            bc = cmPort.query(mobileDeviceSearchPath, props, null, null);
        }
        catch (SDKClientException e) {
            AUDIT_LOGGER.log(SDSLevel.ERROR, (LocalizableException)((Object)e));
            AUDIT_LOGGER.debug("[SDKClientException] Error querying mobileDeviceSearchPath :" + mobileDeviceSearchPath);
            throw new Exception("Unable to query mobileDevice search path", e);
        }
        catch (EMFSecurityException e) {
            AUDIT_LOGGER.log(SDSLevel.ERROR, (Throwable)e);
            AUDIT_LOGGER.debug("[EMFSecurityException] Error querying mobileDeviceSearchPath :" + mobileDeviceSearchPath);
            throw new Exception("Unable to query mobileDevice search path", e);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        RunTimeState runTimeState = null;
        if (bc == null || bc.length == 0) {
            throw new Exception("Null response from mobileDeviceRunTimeState query.");
        }
        if (!(bc[0] instanceof RunTimeState)) {
            throw new Exception("Unexpected response from mobileDeviceRunTimeState query.");
        }
        runTimeState = (RunTimeState)bc[0];
        String storeID = runTimeState.getStoreID().getValue().get_value();
        String storeIDSearchPath = "storeID(\"" + storeID + "\")";
        return storeIDSearchPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePinboardSubscriber(String pinboardId, String accountSearchPath) throws Exception {
        RESTClient restClient = null;
        try {
            URL gatewayURL = PinboardClient.getServerGatewayURL();
            restClient = PinboardClient.getTrustedRESTClient();
            String pinboardEndpoint = PinboardClient.getPinboardSubscribersEndpoint(gatewayURL, pinboardId) + "?accountSearchPath=" + URLEncoder.encode(accountSearchPath, "UTF-8");
            int statusCode = restClient.deleteResource(pinboardEndpoint, "application/json");
            if (statusCode != 204) {
                throw new Exception("Unexpected status code recieved when removing pinboard subscriber " + pinboardEndpoint + " statusCode: " + statusCode);
            }
        }
        finally {
            PinboardClient.closeRESTClient(restClient);
        }
    }

    public static JsonArray getPinboardSubscribers(BiBusHeader biBusHeader, String pinboardId, boolean isTrusted) throws Exception {
        int statusCode;
        String pinboardSubscribersEndpoint;
        block3: {
            JsonArray jsonArray;
            RESTClient restClient = null;
            try {
                URL gatewayURL = PinboardClient.getServerGatewayURL();
                restClient = isTrusted ? PinboardClient.getTrustedRESTClient() : PinboardClient.getRESTClient(biBusHeader, gatewayURL.getHost());
                pinboardSubscribersEndpoint = PinboardClient.getPinboardSubscribersEndpoint(gatewayURL, pinboardId);
                statusCode = restClient.getResource(pinboardSubscribersEndpoint);
                if (statusCode != 200) break block3;
                jsonArray = restClient.getResponseAsJsonArray();
            }
            catch (Throwable throwable) {
                PinboardClient.closeRESTClient(restClient);
                throw throwable;
            }
            PinboardClient.closeRESTClient(restClient);
            return jsonArray;
        }
        SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).error("Unexpected status code recieved when getting pinboard subscribers: " + pinboardSubscribersEndpoint + " statusCode: " + statusCode);
        throw new Exception("Unexpected status code recieved when getting pinboard subscribers: " + pinboardSubscribersEndpoint + " statusCode: " + statusCode);
    }

    public static boolean isSubscriber(BiBusHeader biBusHeader, String pinboardId, String accountSearchPath) throws Exception {
        JsonArray subscribers = PinboardClient.getPinboardSubscribers(biBusHeader, pinboardId, false);
        for (JsonObject subscriber : subscribers.items(JsonObject.class)) {
            if (!subscriber.get(SUBSCRIBER_ACCOUNT_SEARCH_PATH_KEY).equals(accountSearchPath)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<String> getMobileDeviceSearchPathForSubscribers(BiBusHeader biBusHeader, String pinboardId) throws Exception {
        JsonArray subscribers = PinboardClient.getPinboardSubscribers(biBusHeader, pinboardId, false);
        ArrayList<String> mobileDeviceSearchPaths = new ArrayList<String>();
        for (JsonObject subscriber : subscribers.items(JsonObject.class)) {
            mobileDeviceSearchPaths.add(subscriber.getString(SUBSCRIBER_MOBILE_DEVICE_SEARCH_PATH_KEY));
        }
        return mobileDeviceSearchPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPinboardSubscriber(BiBusHeader bibusHeader, String pinboardId, String accountSearchPath, String mobileDeviceSearchPath) throws Exception {
        RESTClient restClient = null;
        try {
            PinboardClient.getPinboardSubscribers(bibusHeader, pinboardId, false);
            URL gatewayURL = PinboardClient.getServerGatewayURL();
            restClient = PinboardClient.getTrustedRESTClient();
            String pinboardSubscribersEndpoint = PinboardClient.getPinboardSubscribersEndpoint(gatewayURL, pinboardId);
            JsonObject requestBody = new JsonObject();
            requestBody.put(SUBSCRIBER_ACCOUNT_SEARCH_PATH_KEY, (Object)accountSearchPath);
            requestBody.put(SUBSCRIBER_MOBILE_DEVICE_SEARCH_PATH_KEY, (Object)mobileDeviceSearchPath);
            int statusCode = restClient.createResource(pinboardSubscribersEndpoint, "application/json", requestBody);
            if (statusCode != 204) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).error("Unexpected status code recieved when getting pinboardEndpoint: " + pinboardSubscribersEndpoint + " statusCode: " + statusCode);
                throw new Exception("Unexpected statusCode recieved when adding pinboardSubscriber, statusCode: " + statusCode);
            }
        }
        catch (Throwable throwable) {
            PinboardClient.closeRESTClient(restClient);
            throw throwable;
        }
        PinboardClient.closeRESTClient(restClient);
    }

    private static URL getServerGatewayURL() throws PropertiesException, MalformedURLException {
        String gatewayURIString = ServerConfigPropertyUtils.getServerGateWay();
        int biSegmentIndex = gatewayURIString.indexOf(COOKIE_PATH_BI_V1);
        if (biSegmentIndex != -1) {
            gatewayURIString = gatewayURIString.substring(0, biSegmentIndex) + COOKIE_PATH_BI_V1;
        }
        return new URL(gatewayURIString);
    }

    private static String getPinboardSubscribersEndpoint(URL gatewayURL, String pinboardId) throws Exception {
        String pinboardEndpoint = gatewayURL.toString() + PINBOARD_SERVICE_ENDPOINT + "/" + pinboardId + "/subscribers";
        return pinboardEndpoint;
    }

    private static RESTClient getRESTClient(BiBusHeader header, String cookieHostname) {
        RESTClient restClient = RESTClientFactory.getInstance().getClient(new RESTClientConfig());
        String cookieData = PinboardClient.generateCookieData(header, cookieHostname);
        restClient.setRequestHeader("Cookie", cookieData);
        String xsrfTokenValue = PinboardClient.getCookieValFromBiBusHeaderSession(header, "XSRF-TOKEN");
        if (xsrfTokenValue != null && !xsrfTokenValue.isEmpty()) {
            restClient.setRequestHeader("X-XSRF-TOKEN", xsrfTokenValue);
        }
        return restClient;
    }

    private static RESTClient getTrustedRESTClient() {
        RESTClient restClient = RESTClientFactory.getInstance().getClient(new RESTClientConfig());
        restClient.makeTrusted("DLS");
        restClient.setRequestHeader("Accept", "application/json");
        return restClient;
    }

    private static void closeRESTClient(RESTClient restClient) {
        if (restClient != null) {
            try {
                restClient.close();
            }
            catch (IOException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).error("PinboardClient rest client closing error " + e.getMessage());
            }
        }
    }

    private static String getCookieValFromBiBusHeaderSession(BiBusHeader header, String keyName) {
        CookieVar[] cookieVars;
        String result = null;
        for (CookieVar element : cookieVars = header.getHdrSession().getCookieVars()) {
            if (!element.getName().equals(keyName)) continue;
            result = element.getValue();
            break;
        }
        return result;
    }

    private static String generateCookieData(BiBusHeader bibusHeader, String hostname) {
        String userCapabilitiesVal;
        String cam_passportVal;
        String usersessionidVal;
        String cookiesData = "";
        String xsrfTokenValue = PinboardClient.getCookieValFromBiBusHeaderSession(bibusHeader, "XSRF-TOKEN");
        if (xsrfTokenValue != null && !xsrfTokenValue.isEmpty()) {
            String xsrfCookieStr = PinboardClient.createCookie("XSRF-TOKEN", xsrfTokenValue, hostname, COOKIE_PATH_BI).toExternalForm();
            cookiesData = cookiesData + "; " + xsrfCookieStr;
        }
        if ((usersessionidVal = PinboardClient.getCookieValFromBiBusHeaderSession(bibusHeader, USERSESSIONID)) != null && !usersessionidVal.isEmpty()) {
            String userSessionCookieStr = PinboardClient.createCookie(USERSESSIONID, usersessionidVal, hostname, COOKIE_PATH_BI).toExternalForm();
            cookiesData = cookiesData + "; " + userSessionCookieStr;
        }
        if ((cam_passportVal = PinboardClient.getCookieValFromBiBusHeaderSession(bibusHeader, CAM_PASSPORT)) != null && !cam_passportVal.isEmpty()) {
            String camCookieStr = PinboardClient.createCookie(CAM_PASSPORT, cam_passportVal, hostname, COOKIE_PATH_BI_V1).toExternalForm();
            cookiesData = cookiesData + "; " + camCookieStr;
        }
        if ((userCapabilitiesVal = PinboardClient.getCookieValFromBiBusHeaderSession(bibusHeader, USER_CAPABILITIES)) != null && !userCapabilitiesVal.isEmpty()) {
            String userCapabilitiesCookieStr = PinboardClient.createCookie(USER_CAPABILITIES, userCapabilitiesVal, hostname, COOKIE_PATH_BI).toExternalForm();
            cookiesData = cookiesData + "; " + userCapabilitiesCookieStr;
        }
        return cookiesData;
    }

    private static Cookie createCookie(String cookieName, String cookieVal, String hostname, String path) {
        Cookie camCookie = new Cookie();
        camCookie.setName(cookieName);
        camCookie.setValue(cookieVal);
        camCookie.setDomain(hostname);
        camCookie.setPath(path);
        return camCookie;
    }
}

