/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.util.attachmentcheck;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.DocumentContent;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartComposite;
import com.cognos.developer.schemas.bibus._3.MemoPartMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.MemoPartObject;
import com.cognos.developer.schemas.bibus._3.NonNegativeIntegerProp;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.jsmcommon.util.DataSizeChecker;
import java.math.BigDecimal;

public abstract class BaseAttachmentCheck {
    protected BigDecimal formatSize(long size) {
        double origAttSizeMBprecise = (double)size / 1048576.0;
        return new BigDecimal(origAttSizeMBprecise).setScale(2, 0);
    }

    protected BigDecimal getFormattedDocumentContentSize(DocumentContent docContent) {
        if (docContent != null) {
            return this.formatSize(DataSizeChecker.getSize((NonNegativeIntegerProp)docContent.getDataSize()));
        }
        return BigDecimal.ZERO;
    }

    protected BigDecimal getFormattedOutputSize(Output output) {
        if (output != null) {
            return this.formatSize(DataSizeChecker.getSize((NonNegativeIntegerProp)output.getDataSize()));
        }
        return BigDecimal.ZERO;
    }

    protected String getBaseClassDataType(BaseClass baseClass) {
        String dataType = "text/html";
        if (baseClass instanceof Output) {
            Output output = (Output)baseClass;
            dataType = output.getDataType() != null ? output.getDataType().getValue() : "";
        } else if (baseClass instanceof DocumentContent) {
            DocumentContent docContent = (DocumentContent)baseClass;
            dataType = docContent.getDataType() != null ? docContent.getDataType().getValue() : "";
        }
        return dataType;
    }

    public String getDataType(Object attachment) {
        if (attachment instanceof BaseClass) {
            return this.getBaseClassDataType((BaseClass)attachment);
        }
        return ((MemoPartMIMEAttachment)attachment).getDataType();
    }

    public String isInline(Object attachment) {
        if (attachment instanceof BaseClass) {
            return this.getBaseClassDataType((BaseClass)attachment);
        }
        return ((MemoPartMIMEAttachment)attachment).getDataType();
    }

    protected void findMemoObject(MemoPart memoPart, SearchPathSingleObject searchPath, MemoHolders holders) {
        if (memoPart instanceof MemoPartObject) {
            SearchPathSingleObject memoObjectPath = ((MemoPartObject)memoPart).getSearchPath();
            if (searchPath != null && searchPath.equals((Object)memoObjectPath)) {
                holders.memoPartObject = (MemoPartObject)memoPart;
            }
        } else if (memoPart instanceof MemoPartComposite) {
            holders.parentMemoPart = (MemoPartComposite)memoPart;
            MemoPart[] compositeParts = holders.parentMemoPart.getParts();
            for (int i = 0; i < compositeParts.length && holders.memoPartObject == null; ++i) {
                this.findMemoObject(compositeParts[i], searchPath, holders);
            }
        }
    }

    protected void findMemoObject(MemoPart memoPart, MemoPart attachment, MemoHolders holders) {
        if (memoPart instanceof MemoPartMIMEAttachment) {
            if (attachment == memoPart) {
                holders.memoPartMime = (MemoPartMIMEAttachment)memoPart;
            }
        } else if (memoPart instanceof MemoPartComposite) {
            MemoPartComposite parent = (MemoPartComposite)memoPart;
            MemoPart[] compositeParts = parent.getParts();
            for (int i = 0; i < compositeParts.length && holders.memoPartMime == null; ++i) {
                this.findMemoObject(compositeParts[i], attachment, holders);
            }
            if (holders.memoPartMime != null && holders.parentMemoPart == null) {
                holders.parentMemoPart = parent;
            }
        }
    }

    protected class MemoHolders {
        public MemoPartObject memoPartObject;
        public MemoPartMIMEAttachment memoPartMime;
        public MemoPartComposite parentMemoPart;
    }
}

