/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.util.attachmentcheck;

import com.cognos.developer.schemas.bibus._3.Base64BinaryMIMEProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.DocumentContent;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartComposite;
import com.cognos.developer.schemas.bibus._3.MemoPartMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.MemoPartObject;
import com.cognos.developer.schemas.bibus._3.MemoPartString;
import com.cognos.developer.schemas.bibus._3.NonNegativeIntegerProp;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.SmtpContentDispositionEnum;
import com.cognos.developer.schemas.bibus._3.SmtpContentTypeEnum;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.dls.util.EmailLimits;
import com.cognos.dls.util.attachmentcheck.AttachmentProcessor;
import com.cognos.dls.util.attachmentcheck.BaseAttachmentCheck;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;

public class TruncationAttachmentProcessor
extends BaseAttachmentCheck
implements AttachmentProcessor {
    static String _inTestMessage = null;
    private static final String OVERSIZEMARKER = "?oversizemarker?";

    @Override
    public long estimateReplacementSize(long origAttSize, String dataType, boolean isInline) {
        return 150L;
    }

    @Override
    public void replaceAttachmentMemoPart(MemoPartObject mpo, MemoPartComposite parent, BaseClass baseClass, boolean isContentInline) {
        if (baseClass == null) {
            return;
        }
        String attachmentName = this.generateTruncatedName(mpo.getName());
        String origOutputFormat = this.getBaseClassDataType(baseClass);
        if ("text/plain".equals(origOutputFormat) || mpo.getName() == null || mpo.getName().endsWith(".txt")) {
            return;
        }
        BigDecimal dataSize = this.getSize(baseClass);
        Object[] msgParams = new Object[]{attachmentName, origOutputFormat, dataSize, EmailLimits.packageTotalSizeLimitMB()};
        I18NCode msgCode = I18NCode.MSG_ATTACHMENT_SIZE_LIMIT_EXCEEDED;
        if (isContentInline) {
            msgParams = new Object[]{dataSize, EmailLimits.packageTotalSizeLimitMB()};
            msgCode = I18NCode.MSG_CONTENT_SIZE_LIMIT_EXCEEDED;
        }
        byte[] contentBytes = this.getOverSizedAttachmentMessageBytes(msgCode, msgParams);
        this.setData(baseClass, contentBytes);
        this.setDataSize(baseClass, contentBytes);
        this.setDataType(baseClass, "text/plain");
        mpo.setName(attachmentName);
    }

    protected String getOverSizedAttachmentMessageString(int size) {
        BigDecimal dataSize = this.formatSize(size);
        Object[] msgParams = new Object[]{dataSize, EmailLimits.packageTotalSizeLimitMB()};
        I18NCode msgCode = I18NCode.MSG_CONTENT_SIZE_LIMIT_EXCEEDED;
        return this.getOverSizedAttachmentMessageString(msgCode, msgParams);
    }

    protected String getOverSizedAttachmentMessageString(I18NCode msgCode, Object[] msgParams) {
        if (_inTestMessage != null) {
            return _inTestMessage;
        }
        I18NMessage msg = new I18NMessage(msgCode, msgParams, SeverityEnum.warn);
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.AUDIT).log(SDSLevel.WARN, msgCode, msgParams);
        return msg.getMessage(Locale.getDefault());
    }

    protected byte[] getOverSizedAttachmentMessageBytes(I18NCode msgCode, Object[] msgParams) {
        String localisedMsg = this.getOverSizedAttachmentMessageString(msgCode, msgParams);
        byte[] byteArrayStr = null;
        try {
            byteArrayStr = localisedMsg.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_ATTACHMENT_SIZE_LIMIT_EXCEEDED);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug((Throwable)e);
        }
        return byteArrayStr;
    }

    protected BigDecimal getSize(BaseClass baseClass) {
        BigDecimal dataSize = BigDecimal.ZERO;
        if (baseClass instanceof Output) {
            dataSize = this.getFormattedOutputSize((Output)baseClass);
        } else if (baseClass instanceof DocumentContent) {
            dataSize = this.getFormattedDocumentContentSize((DocumentContent)baseClass);
        }
        return dataSize;
    }

    protected byte[] getData(BaseClass baseClass) {
        byte[] data = null;
        if (baseClass instanceof Output) {
            data = ((Output)baseClass).getData().getValue();
        } else if (baseClass instanceof DocumentContent) {
            data = ((DocumentContent)baseClass).getData().getValue();
        }
        return data;
    }

    protected void setDataType(BaseClass baseClass, String dataType) {
        StringProp strProp = new StringProp();
        strProp.setValue(dataType);
        if (baseClass instanceof Output) {
            ((Output)baseClass).setDataType(strProp);
        } else if (baseClass instanceof DocumentContent) {
            ((DocumentContent)baseClass).setDataType(strProp);
        }
    }

    protected void setDataSize(BaseClass baseClass, byte[] contentBytes) {
        NonNegativeIntegerProp dataSizeProp = new NonNegativeIntegerProp();
        dataSizeProp.setValue(new BigInteger(Integer.toString(contentBytes.length)));
        if (baseClass instanceof Output) {
            ((Output)baseClass).setDataSize(dataSizeProp);
        } else if (baseClass instanceof DocumentContent) {
            ((DocumentContent)baseClass).setDataSize(dataSizeProp);
        }
    }

    protected void setData(BaseClass baseClass, byte[] contentBytes) {
        Base64BinaryMIMEProp mimeMessageData = new Base64BinaryMIMEProp();
        mimeMessageData.setValue(contentBytes);
        if (baseClass instanceof Output) {
            ((Output)baseClass).setData(mimeMessageData);
        } else if (baseClass instanceof DocumentContent) {
            ((DocumentContent)baseClass).setData(mimeMessageData);
        }
    }

    @Override
    public boolean replaceMemoPartString(MemoPartString mps) {
        boolean replaced = false;
        if (mps.getText() == null || mps.getText().length() <= 0 || mps.getText().contains(OVERSIZEMARKER)) {
            if (mps.getText().contains(OVERSIZEMARKER)) {
                String sizeStr = mps.getText().substring(OVERSIZEMARKER.length());
                String text = this.getOverSizedAttachmentMessageString(Integer.valueOf(sizeStr));
                mps.setText(text);
            }
            replaced = true;
        } else {
            try {
                int size = mps.getText().getBytes("UTF-8").length;
                if (EmailLimits.exceedsTotalSizeLimit(size)) {
                    String text = this.getOverSizedAttachmentMessageString(size);
                    mps.setText(text);
                    replaced = true;
                }
            }
            catch (UnsupportedEncodingException e) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.INFO, (Throwable)e);
            }
        }
        return replaced;
    }

    private String generateTruncatedName(String name) {
        int indexOfZip = -1;
        if (name == null) {
            name = "";
        } else {
            indexOfZip = name.indexOf(".zip");
            if (indexOfZip != -1) {
                name = name.substring(0, indexOfZip);
            }
        }
        return name.length() > 0 ? name + ".txt" : name;
    }

    @Override
    public void replaceAttachmentMemoPart(MemoPartMIMEAttachment origAttachment, MemoPartComposite parent, long origAttSize) {
        String orgAttName = origAttachment.getName();
        String origOutputFormat = origAttachment.getDataType();
        if ("text/plain".equals(origOutputFormat) || orgAttName == null || orgAttName.endsWith(".txt")) {
            return;
        }
        origAttachment.setName(this.generateTruncatedName(orgAttName));
        BigDecimal dataSize = this.formatSize(origAttSize);
        Object[] msgParams = new Object[]{orgAttName, origOutputFormat, dataSize, EmailLimits.packageTotalSizeLimitMB(), EmailLimits.SERVICE_NAME};
        I18NCode msgCode = I18NCode.MSG_ATTACHMENT_SIZE_LIMIT_EXCEEDED;
        SmtpContentDispositionEnum origContentEnum = origAttachment.getContentDisposition();
        if (origContentEnum != null) {
            if (origContentEnum.equals((Object)SmtpContentDispositionEnum.inline)) {
                msgParams = new Object[]{dataSize, EmailLimits.packageTotalSizeLimitMB()};
                msgCode = I18NCode.MSG_CONTENT_SIZE_LIMIT_EXCEEDED;
                origAttachment.setDataType("text/html");
            } else {
                origAttachment.setDataType("text/plain; charset=utf-8");
            }
        }
        byte[] warningMsgBytes = this.getOverSizedAttachmentMessageBytes(msgCode, msgParams);
        origAttachment.setData(warningMsgBytes);
        origAttachment.setDataSize(BigInteger.valueOf(warningMsgBytes.length));
        if (parent != null && SmtpContentTypeEnum.related.equals((Object)parent.getContentType())) {
            parent.setParts(new MemoPart[]{origAttachment});
            parent.setContentDisposition(SmtpContentDispositionEnum.attachment);
        }
    }

    @Override
    public boolean isAttachmentSizeOK(long size) {
        return !EmailLimits.exceedsTotalSizeLimit(size);
    }

    @Override
    public short priority() {
        return 1;
    }
}

