/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.util.attachmentcheck;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionEnum;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionMemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartComposite;
import com.cognos.developer.schemas.bibus._3.MemoPartMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.MemoPartObject;
import com.cognos.developer.schemas.bibus._3.MemoPartString;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.SmtpContentDispositionEnum;
import com.cognos.developer.schemas.bibus._3.SmtpContentTypeEnum;
import com.cognos.dls.smtp.EmailOptionsDeliverable;
import com.cognos.dls.smtp.MimeTextEncoder;
import com.cognos.dls.smtp.SMTPPropertiesFactory;
import com.cognos.dls.util.EmailLimits;
import com.cognos.dls.util.attachmentcheck.TruncationAttachmentProcessor;
import com.cognos.jsmcommon.util.DataSizeChecker;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.ZipToFileUtil;
import com.cognos.jsmcommon.util.ZipUtils;
import com.cognos.jsmcommon.util.datasource.DataSourceFactory;
import com.cognos.jsmcommon.util.datasource.NCDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.io.IOUtils;

public class ZippingAttachmentProcessor
extends TruncationAttachmentProcessor {
    private Properties smtpProperties = null;
    private Session session = null;
    String emailEncoding = this.getSession().getProperty("email.encoding");
    private MimeTextEncoder mimeTextEncoder = new MimeTextEncoder(this.emailEncoding);
    private EmailOptionsDeliverable emailOptionsDeliverable;

    public ZippingAttachmentProcessor(EmailOptionsDeliverable eod) {
        this.emailOptionsDeliverable = eod;
    }

    private Session getSession() {
        if (this.session == null) {
            this.session = Session.getDefaultInstance((Properties)this.getProperties());
        }
        return this.session;
    }

    private Properties getProperties() {
        if (this.smtpProperties == null) {
            this.smtpProperties = SMTPPropertiesFactory.getProperties();
        }
        return this.smtpProperties;
    }

    @Override
    public long estimateReplacementSize(long origAttSize, String dataType, boolean isInline) {
        return ZipUtils.estimateZippedSize((long)origAttSize, (String)dataType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAttachmentMemoPart(MemoPartMIMEAttachment origAttachment, MemoPartComposite parent, long origAttSize) {
        if (origAttachment == null) {
            return;
        }
        String origOutputFormat = origAttachment.getDataType();
        if ("application/x-zip-compressed".equals(origOutputFormat) || "text/plain".equals(origOutputFormat)) {
            return;
        }
        if (parent != null && SmtpContentTypeEnum.related.equals((Object)parent.getContentType())) {
            MemoPartComposite grandParent;
            MemoPart memoPart;
            DeliveryOption memoPartOption;
            ArrayList<MemoPart> parts = new ArrayList<MemoPart>();
            for (MemoPart part : parent.getParts()) {
                parts.add(part);
            }
            if (this.emailOptionsDeliverable != null) {
                this.emailOptionsDeliverable.removeMemoPartMIMEAttachment(origAttachment);
            }
            boolean wasInline = SmtpContentDispositionEnum.inline.equals((Object)origAttachment.getContentDisposition());
            MemoPartMIMEAttachment zippedRelated = this.makeZippedAttachmentPart(parts, parent.getName(), origOutputFormat, wasInline);
            parent.setParts(new MemoPart[]{zippedRelated});
            if (this.emailOptionsDeliverable != null) {
                this.emailOptionsDeliverable.addMemoPartMIMEAttachment(zippedRelated);
            }
            parent.setContentDisposition(SmtpContentDispositionEnum.attachment);
            if (parent.getName() != null) {
                parent.setName(this.getZippedFileName(parent.getName()));
            }
            if (wasInline && origOutputFormat != null && origOutputFormat.toLowerCase().contains("text/html") && (memoPartOption = (DeliveryOption)OptionUtils.findFirstOptionWithNameEnum((Option[])this.emailOptionsDeliverable.getDeliveryOptions(), (Object)DeliveryOptionEnum.memoPart)).getName() == DeliveryOptionEnum.memoPart && (memoPart = ((DeliveryOptionMemoPart)memoPartOption).getValue()) instanceof MemoPartComposite && (grandParent = this.findParentPart((MemoPartComposite)memoPart, (MemoPart)parent)) != null && grandParent.getContentType() == SmtpContentTypeEnum.alternative) {
                grandParent.setContentType(SmtpContentTypeEnum.mixed);
            }
            return;
        }
        String orgAttName = origAttachment.getName();
        String zippedName = this.getZippedFileName(orgAttName);
        if (orgAttName == null || orgAttName.trim().length() == 0 || !DataSizeChecker.hasData((Object)origAttachment) || orgAttName.endsWith(".zip")) {
            return;
        }
        SmtpContentDispositionEnum origContentEnum = origAttachment.getContentDisposition();
        if (origContentEnum != null && origContentEnum.equals((Object)SmtpContentDispositionEnum.inline)) {
            origAttachment.setContentDisposition(SmtpContentDispositionEnum.attachment);
        }
        ZipToFileUtil zipToFileUtil = null;
        try {
            zipToFileUtil = new ZipToFileUtil(EmailLimits.getTotalSizeLimit(), orgAttName);
            zipToFileUtil.writeToFile(origAttachment.getData());
            zipToFileUtil.close();
            if (zipToFileUtil.tempFile == null) {
                origAttachment.setData(ZipUtils.zip((byte[])origAttachment.getData(), (String)origAttachment.getName(), (long)EmailLimits.getTotalSizeLimit()));
            } else {
                origAttachment.setData(null);
                origAttachment.setData(zipToFileUtil.getZippedBytes());
            }
            origAttachment.setDataType("application/x-zip-compressed");
            origAttachment.setName(zippedName);
            origAttachment.setDataSize(BigInteger.valueOf(origAttachment.getData().length));
        }
        catch (Throwable e) {
            super.replaceAttachmentMemoPart(origAttachment, parent, origAttSize);
        }
        finally {
            if (zipToFileUtil != null) {
                zipToFileUtil.cleanup();
            }
        }
    }

    @Override
    public boolean replaceMemoPartString(MemoPartString mps) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAttachmentMemoPart(MemoPartObject mpo, MemoPartComposite parent, BaseClass baseClass, boolean isContentInline) {
        if (baseClass == null) {
            return;
        }
        String dataType = this.getDataType(baseClass);
        if ("application/x-zip-compressed".equals(dataType) || "text/plain".equals(dataType)) {
            return;
        }
        if (parent != null && SmtpContentTypeEnum.related.equals((Object)parent.getContentType())) {
            ArrayList<MemoPart> parts = new ArrayList<MemoPart>();
            for (MemoPart part : parent.getParts()) {
                parts.add(part);
            }
            MemoPartMIMEAttachment zippedRelated = this.makeZippedAttachmentPart(parts, parent.getName(), dataType, isContentInline);
            parent.setParts(new MemoPart[]{zippedRelated});
            if (this.emailOptionsDeliverable != null) {
                this.emailOptionsDeliverable.addMemoPartMIMEAttachment(zippedRelated);
            }
            parent.setContentDisposition(SmtpContentDispositionEnum.attachment);
            if (parent.getName() != null) {
                parent.setName(this.getZippedFileName(parent.getName()));
            }
            return;
        }
        if (mpo.getName() == null || !DataSizeChecker.hasData((Object)baseClass)) {
            return;
        }
        if (isContentInline) {
            parent.setContentDisposition(SmtpContentDispositionEnum.attachment);
            mpo.setContentDisposition(SmtpContentDispositionEnum.attachment);
        }
        String attachmentName = mpo.getName() + ".zip";
        ZipToFileUtil zipToFileUtil = null;
        try {
            zipToFileUtil = new ZipToFileUtil(EmailLimits.getTotalSizeLimit(), mpo.getName());
            zipToFileUtil.writeToFile(this.getData(baseClass));
            zipToFileUtil.close();
            if (zipToFileUtil.tempFile == null) {
                this.setData(baseClass, ZipUtils.zip((byte[])this.getData(baseClass), (String)mpo.getName(), (long)EmailLimits.getTotalSizeLimit()));
            } else {
                this.setData(baseClass, null);
                this.setData(baseClass, zipToFileUtil.getZippedBytes());
            }
            this.setDataType(baseClass, "application/x-zip-compressed");
            this.setDataSize(baseClass, this.getData(baseClass));
            mpo.setName(attachmentName);
        }
        catch (Throwable e) {
            super.replaceAttachmentMemoPart(mpo, parent, baseClass, isContentInline);
        }
        finally {
            if (zipToFileUtil != null) {
                zipToFileUtil.cleanup();
            }
        }
    }

    private MemoPartComposite findParentPart(MemoPartComposite candidateParent, MemoPart child) {
        MemoPart[] parts = candidateParent.getParts();
        for (int i = 0; i < parts.length; ++i) {
            MemoPartComposite next;
            MemoPart part = parts[i];
            if (part == child) {
                return candidateParent;
            }
            if (!(part instanceof MemoPartComposite) || (next = this.findParentPart((MemoPartComposite)part, child)) == null) continue;
            return next;
        }
        return null;
    }

    @Override
    public boolean isAttachmentSizeOK(long size) {
        return !EmailLimits.exceedsUncompressedAttachmentLimit(size);
    }

    private MimeMultipart makeRelatedMimeMultipart(List<?> mimeAttachments) throws MessagingException, IOException {
        MimeMultipart mp = new MimeMultipart("related");
        for (Object object : mimeAttachments) {
            String contentID;
            String contentLocation;
            if (!(object instanceof MemoPartMIMEAttachment)) continue;
            MemoPartMIMEAttachment mpmaChild = (MemoPartMIMEAttachment)object;
            MimeBodyPart childbp = new MimeBodyPart();
            if (mpmaChild.getName() != null) {
                childbp.setFileName(this.mimeTextEncoder.encodeMimeText(mpmaChild.getName()));
            }
            if ((contentLocation = mpmaChild.getContentLocation()) != null && !contentLocation.equals("")) {
                childbp.setHeader("Content-Location", contentLocation);
            }
            if ((contentID = mpmaChild.getContentID()) != null && !contentID.equals("")) {
                childbp.setHeader("Content-ID", contentID);
            }
            childbp.setDisposition("attachment");
            mp.addBodyPart((BodyPart)childbp);
            NCDataSource ds = DataSourceFactory.getSimpleDataSource((byte[])mpmaChild.getData(), (String)mpmaChild.getDataType());
            childbp.setDataHandler(new DataHandler((DataSource)ds));
        }
        return mp;
    }

    private String getZippedFileName(String orgAttName) {
        if (orgAttName == null) {
            return null;
        }
        orgAttName = orgAttName + ".zip";
        return this.mimeTextEncoder.encodeMimeText(orgAttName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoPartMIMEAttachment makeZippedAttachmentPart(List<?> mimeAttachments, String fileName, String contentType, boolean wasInline) {
        MemoPartMIMEAttachment mpma = new MemoPartMIMEAttachment();
        ZipToFileUtil zipToFileUtil = null;
        try {
            MimeMultipart mp = this.makeRelatedMimeMultipart(mimeAttachments);
            MimeMessage mimeMessage = this.makeRelatedMimeMessage(mp);
            InputStream mimeStream = mimeMessage.getInputStream();
            if (fileName == null) {
                fileName = "attachment.mht";
            }
            zipToFileUtil = new ZipToFileUtil(EmailLimits.getTotalSizeLimit(), fileName);
            String mpContentType = mp.getContentType();
            byte[] prefix = ("MIME-Version: 1.0\nContent-Type: " + mpContentType + "\n\n").getBytes();
            zipToFileUtil.writeToFile(prefix);
            zipToFileUtil.writeToFile(mimeStream);
            zipToFileUtil.close();
            if (zipToFileUtil.tempFile == null) {
                mimeMessage = this.makeRelatedMimeMessage(this.makeRelatedMimeMultipart(mimeAttachments));
                byte[] bytes = IOUtils.toByteArray((InputStream)mimeMessage.getInputStream());
                byte[] total = new byte[prefix.length + bytes.length];
                System.arraycopy(prefix, 0, total, 0, prefix.length);
                System.arraycopy(bytes, 0, total, prefix.length, bytes.length);
                mpma.setData(ZipUtils.zip((byte[])total, (String)fileName, (long)EmailLimits.getTotalSizeLimit()));
            } else {
                mpma.setData(null);
                mpma.setData(zipToFileUtil.getZippedBytes());
            }
            mpma.setContentDisposition(SmtpContentDispositionEnum.attachment);
            mpma.setDataSize(new BigInteger(String.valueOf(mpma.getData().length)));
            mpma.setDataType("application/x-zip-compressed");
            mpma.setName(this.getZippedFileName(fileName));
        }
        catch (Exception e) {
            mpma = null;
        }
        finally {
            if (zipToFileUtil != null) {
                zipToFileUtil.cleanup();
            }
        }
        return mpma;
    }

    private MimeMessage makeRelatedMimeMessage(MimeMultipart mp) throws MessagingException {
        MimeMessage mimeMessage = new MimeMessage(this.getSession());
        mimeMessage.setContent((Multipart)mp);
        mimeMessage.saveChanges();
        return mimeMessage;
    }

    @Override
    public short priority() {
        return 2;
    }
}

