/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.util.attachmentcheck.strategy;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.DocumentContent;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.MemoPartObject;
import com.cognos.developer.schemas.bibus._3.MemoPartString;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SmtpContentDispositionEnum;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.EmailOptionsDeliverable;
import com.cognos.dls.util.AttachmentsProcessorFactory;
import com.cognos.dls.util.IAttachmentsProcessor;
import com.cognos.dls.util.attachmentcheck.AttachmentProcessor;
import com.cognos.dls.util.attachmentcheck.BaseAttachmentCheck;
import com.cognos.dls.util.attachmentcheck.strategy.AttachmentsSortedList;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.util.DataSizeChecker;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AttachmentCheckStrategy
extends BaseAttachmentCheck {
    public static String _zeroSizeTestMessage = null;
    private static final String DEFAULT_CONTENT_NAME = "content";
    private EmailOptionsDeliverable emailOptionsdeliverable;
    private AttachmentProcessor attachmentProcessor;
    private Charset utf8Charset;

    public AttachmentCheckStrategy(EmailOptionsDeliverable eod, AttachmentProcessor attachmentProcessor) {
        this.attachmentProcessor = attachmentProcessor;
        this.setEmailOptionsdeliverable(eod);
        this.utf8Charset = Charset.forName("UTF-8");
    }

    public boolean checkAttachment(MemoPartMIMEAttachment mpma) {
        if (this.checkZeroSizeAttachments(mpma)) {
            return true;
        }
        long dataSize = DataSizeChecker.getObjectSize((Object)mpma);
        if (!this.attachmentProcessor.isAttachmentSizeOK(dataSize)) {
            this.attachmentProcessor.replaceAttachmentMemoPart(mpma, null, dataSize);
            return true;
        }
        return false;
    }

    protected boolean checkZeroSizeAttachments(MemoPartMIMEAttachment mpma) {
        if (mpma == null) {
            return false;
        }
        long dataSize = DataSizeChecker.getObjectSize((Object)mpma);
        if (dataSize <= 0L) {
            this.processZeroSizeAttachment(mpma);
            return true;
        }
        if (dataSize > 0L && mpma.getData() == null) {
            this.processAttachmentExternalRemoval(mpma, this.formatSize(dataSize));
            return true;
        }
        return false;
    }

    protected void processZeroSizeAttachment(MemoPartMIMEAttachment mpma) {
        String msg = _zeroSizeTestMessage;
        if (msg == null) {
            Locale locale = this.emailOptionsdeliverable == null ? Locale.getDefault() : this.emailOptionsdeliverable.getLocale();
            String contentName = mpma.getName() != null ? mpma.getName() : DEFAULT_CONTENT_NAME;
            msg = this.isInlineContent(mpma) ? I18NUtil.getMessage((I18NCode)DlsI18NCode.MSG_DS_OUTPUT_NOT_AVALABLE, (Object)contentName, (Locale)locale) : I18NUtil.getMessage((I18NCode)DlsI18NCode.MSG_DS_OUTPUT_NOT_AVALABLE, (Object)contentName, (Locale)locale);
        }
        this.replaceContentWithMessage(mpma, msg);
    }

    protected void processAttachmentExternalRemoval(MemoPartMIMEAttachment mpma, BigDecimal dataSizeMB) {
        String msg = _zeroSizeTestMessage;
        if (msg == null) {
            Locale locale;
            Locale locale2 = locale = this.emailOptionsdeliverable == null ? Locale.getDefault() : this.emailOptionsdeliverable.getLocale();
            if (this.isInlineContent(mpma)) {
                Object[] msgParams = new Object[]{dataSizeMB};
                msg = I18NUtil.getMessage((I18NCode)I18NCode.MSG_CONTENT_REMOVED, (Object[])msgParams, (Locale)locale);
            } else {
                Object[] msgParams = new Object[]{mpma.getName(), mpma.getDataType(), dataSizeMB};
                msg = I18NUtil.getMessage((I18NCode)I18NCode.MSG_ATTACHMENT_REMOVED, (Object[])msgParams, (Locale)locale);
            }
        }
        this.replaceContentWithMessage(mpma, msg);
    }

    protected boolean isInlineContent(MemoPartMIMEAttachment mpma) {
        return mpma.getContentDisposition() != null && mpma.getContentDisposition().equals((Object)SmtpContentDispositionEnum.inline);
    }

    private void replaceContentWithMessage(MemoPartMIMEAttachment mpma, String msg) {
        if (this.isInlineContent(mpma)) {
            msg = "<html><body>" + msg + "</body></html>";
            mpma.setDataType("text/html; charset=utf-8");
        } else {
            mpma.setDataType("text/plain; charset=utf-8");
            mpma.setName(mpma.getName() + ".txt");
        }
        mpma.setData(msg.getBytes(this.utf8Charset));
        mpma.setDataSize(BigInteger.valueOf(mpma.getData().length));
    }

    public MemoPartMIMEAttachment checkRelatedAttachments(List<?> mimeAttachments, String fileName, boolean inLine) {
        Object attachment;
        MemoPartMIMEAttachment relatedMainPart;
        MemoPartMIMEAttachment mpma = null;
        if (mimeAttachments == null || mimeAttachments.size() == 0) {
            return mpma;
        }
        AttachmentsSortedList attachmentList = new AttachmentsSortedList();
        if (mimeAttachments != null) {
            attachmentList.addAttachments(mimeAttachments);
        }
        if (this.checkZeroSizeAttachments(relatedMainPart = (MemoPartMIMEAttachment)mimeAttachments.get(0))) {
            return relatedMainPart;
        }
        if (this.attachmentProcessor != null && !this.attachmentProcessor.isAttachmentSizeOK(attachmentList.getTotalSize()) && (attachment = attachmentList.get(0)) instanceof MemoPartMIMEAttachment) {
            mpma = (MemoPartMIMEAttachment)attachment;
            mpma.setName(fileName);
            mpma.setContentLocation(null);
            mpma.setDataType("text/plain; charset=utf-8");
            this.attachmentProcessor.replaceAttachmentMemoPart(mpma, null, DataSizeChecker.getObjectSize((Object)attachment));
        }
        attachmentList.clear();
        return mpma;
    }

    public void checkAllAttachments(MemoPart memoPart, MemoPartObject inlineMemoPartObject, Map<SearchPathSingleObject, BaseClass> attachmentsMap, List<?> mimeAttachments) {
        AttachmentsSortedList attachmentList = new AttachmentsSortedList();
        if (mimeAttachments != null) {
            attachmentList.addAttachments(mimeAttachments);
        }
        if (attachmentsMap != null) {
            SearchPathSingleObject inlineSp = inlineMemoPartObject != null ? inlineMemoPartObject.getSearchPath() : null;
            attachmentList.addBaseClassAttachments(attachmentsMap, inlineSp);
        }
        attachmentList.sortByEstimate();
        for (int i = 0; i < attachmentList.size() && !this.attachmentProcessor.isAttachmentSizeOK(attachmentList.getTotalSize()) && this.attachmentProcessor != null; ++i) {
            Object attachment = attachmentList.get(i);
            this.processAttachment(attachment, attachmentList, inlineMemoPartObject, attachmentsMap, this.attachmentProcessor, memoPart);
        }
        if (AttachmentsProcessorFactory.getInstance() != null) {
            IAttachmentsProcessor ap = AttachmentsProcessorFactory.getInstance();
            ap.loadAllAttachments(attachmentsMap.entrySet(), this.getEmailOptionsdeliverable());
        }
    }

    protected void processAttachment(Object attachment, AttachmentsSortedList attachmentList, MemoPartObject inlineMemoPartObject, Map<SearchPathSingleObject, BaseClass> attachmentsMap, AttachmentProcessor attachmentProcessor, MemoPart memoPart) {
        if (attachmentProcessor == null) {
            return;
        }
        if (attachment instanceof MemoPartMIMEAttachment) {
            BaseAttachmentCheck.MemoHolders memoObjects = new BaseAttachmentCheck.MemoHolders();
            this.findMemoObject(memoPart, (MemoPart)((MemoPartMIMEAttachment)attachment), memoObjects);
            attachmentProcessor.replaceAttachmentMemoPart((MemoPartMIMEAttachment)attachment, memoObjects.parentMemoPart, DataSizeChecker.getObjectSize((Object)attachment));
        } else if (attachment instanceof Output || attachment instanceof DocumentContent) {
            BaseClass attachmentObject = (BaseClass)attachment;
            Set<SearchPathSingleObject> keys = attachmentsMap.keySet();
            SearchPathSingleObject searchPath2 = null;
            for (SearchPathSingleObject searchPath2 : keys) {
                if (attachmentsMap.get(searchPath2).equals((Object)attachmentObject)) break;
            }
            if (searchPath2 != null) {
                BaseAttachmentCheck.MemoHolders memoObjects = new BaseAttachmentCheck.MemoHolders();
                this.findMemoObject(memoPart, searchPath2, memoObjects);
                boolean isInline = inlineMemoPartObject != null && inlineMemoPartObject.getSearchPath() != null && inlineMemoPartObject.getSearchPath().equals((Object)searchPath2);
                attachmentProcessor.replaceAttachmentMemoPart(memoObjects.memoPartObject, memoObjects.parentMemoPart, attachmentObject, isInline);
            }
        }
    }

    public boolean checkMemoPartString(MemoPartString mps) {
        return this.attachmentProcessor.replaceMemoPartString(mps);
    }

    public AttachmentProcessor getAttachmentProcessor() {
        return this.attachmentProcessor;
    }

    public void setAttachmentProcessor(AttachmentProcessor attachmentProcessor) {
        this.attachmentProcessor = attachmentProcessor;
    }

    public EmailOptionsDeliverable getEmailOptionsdeliverable() {
        return this.emailOptionsdeliverable;
    }

    public void setEmailOptionsdeliverable(EmailOptionsDeliverable emailOptionsdeliverable) {
        this.emailOptionsdeliverable = emailOptionsdeliverable;
    }
}

