/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.util.attachmentcheck.strategy;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.dls.util.attachmentcheck.AttachmentProcessor;
import com.cognos.dls.util.attachmentcheck.BaseAttachmentCheck;
import com.cognos.dls.util.attachmentcheck.NullAttachmentProcessor;
import com.cognos.jsmcommon.util.DataSizeChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AttachmentsSortedList
extends BaseAttachmentCheck {
    private List<Object> attachments = new ArrayList<Object>();
    private List<AttachmentProcessorObject> attachmentProcessors = new ArrayList<AttachmentProcessorObject>();
    private Comparator<Object> comparator = new AttachmentSizeComparator<Object>();
    private Comparator<Object> estimateComparator = new AttachmentSizeComparator<Object>();
    private long estimatedTotalSize = 0L;
    private Object inlineAttachment;

    public long getTotalSize() {
        long total = 0L;
        Iterator<Object> itr = this.attachments.iterator();
        while (itr.hasNext()) {
            total += DataSizeChecker.getObjectSize((Object)itr.next());
        }
        return total;
    }

    public long estimateProcessedSize() {
        return this.estimatedTotalSize;
    }

    private void addToEstimateProcessedSize(Object attachment) {
        this.estimatedTotalSize += DataSizeChecker.getObjectSize((Object)attachment);
    }

    public List<Object> getAttachments() {
        return this.attachments;
    }

    public void resetEstimate() {
        this.estimatedTotalSize = 0L;
        for (Object attachment : this.attachments) {
            this.addToEstimateProcessedSize(attachment);
        }
    }

    public long getEstimatedSize(Object attachment) {
        return this.getProcessor(attachment).estimateReplacementSize(DataSizeChecker.getObjectSize((Object)attachment), this.getDataType(attachment), attachment == this.inlineAttachment);
    }

    public void clear() {
        this.attachments.clear();
        this.attachmentProcessors.clear();
        this.estimatedTotalSize = 0L;
    }

    public Object get(int i) {
        return this.attachments.get(i);
    }

    public void addAttachment(Object attachment) {
        this.attachments.add(attachment);
        this.addToEstimateProcessedSize(attachment);
    }

    public void addAttachments(Collection<?> attachments) {
        for (Object object : attachments) {
            this.addAttachment(object);
        }
    }

    public void addBaseClassAttachments(Map<SearchPathSingleObject, BaseClass> attachments, SearchPathSingleObject inlineSearchPath) {
        for (SearchPathSingleObject searchpath : attachments.keySet()) {
            BaseClass attachment = attachments.get(searchpath);
            if (inlineSearchPath != null && searchpath.equals((Object)inlineSearchPath)) {
                this.inlineAttachment = attachment;
            }
            this.addAttachment(attachment);
        }
    }

    public boolean setProcessor(Object attachment, AttachmentProcessor processor) {
        return this.setProcessor(attachment, processor, false);
    }

    public boolean setProcessor(Object attachment, AttachmentProcessor processor, boolean force) {
        short oldPriority;
        AttachmentProcessorObject oldProcessorHolder = this.getProcessorHolder(attachment);
        AttachmentProcessor oldprocessor = null;
        short s = oldPriority = oldProcessorHolder == null ? (short)Short.MAX_VALUE : (short)oldProcessorHolder.processor.priority();
        if (oldPriority == processor.priority() || !force && oldPriority < processor.priority()) {
            return false;
        }
        if (oldProcessorHolder != null) {
            oldprocessor = oldProcessorHolder.processor;
            oldProcessorHolder.processor = processor;
        } else {
            this.attachmentProcessors.add(new AttachmentProcessorObject(attachment, processor));
        }
        long realAttachSize = DataSizeChecker.getObjectSize((Object)attachment);
        String dataType = this.getDataType(attachment);
        long attachSize = oldprocessor == null ? realAttachSize : oldprocessor.estimateReplacementSize(realAttachSize, dataType, attachment == this.inlineAttachment);
        this.estimatedTotalSize -= attachSize;
        this.estimatedTotalSize += processor.estimateReplacementSize(realAttachSize, dataType, attachment == this.inlineAttachment);
        return true;
    }

    public AttachmentProcessor getProcessor(Object attachment) {
        AttachmentProcessorObject processor = this.getProcessorHolder(attachment);
        return processor == null ? new NullAttachmentProcessor() : processor.processor;
    }

    public AttachmentProcessorObject getProcessorHolder(Object attachment) {
        AttachmentProcessorObject processor = null;
        for (AttachmentProcessorObject attachmentHolder : this.attachmentProcessors) {
            if (attachmentHolder.object != attachment) continue;
            processor = attachmentHolder;
            break;
        }
        return processor;
    }

    public int size() {
        return this.attachments.size();
    }

    public void sortByEstimate() {
        Collections.sort(this.attachments, this.estimateComparator);
    }

    public void sortByEstimatedReduction(AttachmentProcessor processor) {
        Collections.sort(this.attachments, new AttachmentEstimateComparator(processor));
    }

    public void sortBySize() {
        Collections.sort(this.attachments, this.comparator);
    }

    class AttachmentProcessorObject {
        Object object;
        AttachmentProcessor processor;

        AttachmentProcessorObject(Object object, AttachmentProcessor processor) {
            this.object = object;
            this.processor = processor;
        }
    }

    protected class AttachmentSizeComparator<T>
    implements Comparator<T> {
        protected AttachmentSizeComparator() {
        }

        @Override
        public int compare(Object attach1, Object attach2) {
            long size2 = AttachmentsSortedList.this.getEstimatedSize(attach1);
            long size1 = AttachmentsSortedList.this.getEstimatedSize(attach2);
            if (size1 > size2) {
                return 1;
            }
            if (size1 < size2) {
                return -1;
            }
            return 0;
        }
    }

    protected class AttachmentEstimateComparator<T>
    implements Comparator<T> {
        AttachmentProcessor processor;

        AttachmentEstimateComparator() {
        }

        AttachmentEstimateComparator(AttachmentProcessor processor) {
            this.processor = processor;
        }

        @Override
        public int compare(Object attach1, Object attach2) {
            long sizeDrop1;
            long realSize1 = AttachmentsSortedList.this.getEstimatedSize(attach1);
            long realSize2 = AttachmentsSortedList.this.getEstimatedSize(attach2);
            long estimatedSize1 = this.processor.estimateReplacementSize(DataSizeChecker.getObjectSize((Object)attach1), AttachmentsSortedList.this.getDataType(attach1), attach1 == AttachmentsSortedList.this.inlineAttachment);
            long estimatedSize2 = this.processor.estimateReplacementSize(DataSizeChecker.getObjectSize((Object)attach2), AttachmentsSortedList.this.getDataType(attach2), attach2 == AttachmentsSortedList.this.inlineAttachment);
            long sizeDrop2 = realSize2 - estimatedSize2;
            if (sizeDrop2 > (sizeDrop1 = realSize1 - estimatedSize1)) {
                return 1;
            }
            if (sizeDrop2 < sizeDrop1) {
                return -1;
            }
            return 0;
        }
    }
}

