/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.util.attachmentcheck.strategy;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.MemoPartObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.dls.smtp.EmailOptionsDeliverable;
import com.cognos.dls.util.AttachmentsProcessorFactory;
import com.cognos.dls.util.EmailLimits;
import com.cognos.dls.util.IAttachmentsProcessor;
import com.cognos.dls.util.attachmentcheck.AttachmentProcessor;
import com.cognos.dls.util.attachmentcheck.NullAttachmentProcessor;
import com.cognos.dls.util.attachmentcheck.ZippingAttachmentProcessor;
import com.cognos.dls.util.attachmentcheck.strategy.AttachmentCheckStrategy;
import com.cognos.dls.util.attachmentcheck.strategy.AttachmentCheckStrategyFactory;
import com.cognos.dls.util.attachmentcheck.strategy.AttachmentsSortedList;
import com.cognos.jsmcommon.util.DataSizeChecker;
import java.util.List;
import java.util.Map;

public class ZipAttachmentCheckStrategy
extends AttachmentCheckStrategy {
    protected NullAttachmentProcessor nullProcessor = new NullAttachmentProcessor();

    public ZipAttachmentCheckStrategy(EmailOptionsDeliverable eod, AttachmentProcessor processor) {
        super(eod, processor);
    }

    public ZipAttachmentCheckStrategy(EmailOptionsDeliverable eod) {
        super(eod, new ZippingAttachmentProcessor(eod));
    }

    @Override
    public MemoPartMIMEAttachment checkRelatedAttachments(List<?> mimeAttachments, String fileName, boolean inline) {
        MemoPartMIMEAttachment relatedMainPart;
        MemoPartMIMEAttachment mpma = null;
        if (mimeAttachments == null || mimeAttachments.size() == 0 || inline) {
            return mpma;
        }
        AttachmentsSortedList attachmentList = new AttachmentsSortedList();
        if (mimeAttachments != null) {
            attachmentList.addAttachments(mimeAttachments);
        }
        if (this.checkZeroSizeAttachments(relatedMainPart = (MemoPartMIMEAttachment)attachmentList.get(0))) {
            return relatedMainPart;
        }
        if (!this.getAttachmentProcessor().isAttachmentSizeOK(attachmentList.getTotalSize())) {
            String contentType = this.getDataType(mimeAttachments.get(0));
            ZippingAttachmentProcessor zipProcessor = (ZippingAttachmentProcessor)this.getAttachmentProcessor();
            mpma = zipProcessor.makeZippedAttachmentPart(mimeAttachments, fileName, contentType, inline);
            if (mpma == null) {
                mpma = AttachmentCheckStrategyFactory.getTruncationStrategy().checkRelatedAttachments(mimeAttachments, fileName, inline);
            }
        }
        return mpma;
    }

    @Override
    public void checkAllAttachments(MemoPart memoPart, MemoPartObject inlineMemoPartObject, Map<SearchPathSingleObject, BaseClass> attachmentsMap, List<?> mimeAttachments) {
        AttachmentsSortedList attachmentList = new AttachmentsSortedList();
        if (mimeAttachments != null) {
            attachmentList.addAttachments(mimeAttachments);
        }
        if (attachmentsMap != null) {
            SearchPathSingleObject inlineSp = inlineMemoPartObject != null ? inlineMemoPartObject.getSearchPath() : null;
            attachmentList.addBaseClassAttachments(attachmentsMap, inlineSp);
        }
        this.setRecommendedAttachmentProcessorList(attachmentList);
        if (AttachmentsProcessorFactory.getInstance() != null) {
            IAttachmentsProcessor ap = AttachmentsProcessorFactory.getInstance();
            ap.loadAllAttachments(attachmentsMap.entrySet(), this.getEmailOptionsdeliverable());
        }
        for (int i = 0; i < attachmentList.size(); ++i) {
            Object attachment = attachmentList.get(i);
            this.processAttachment(attachment, attachmentList, inlineMemoPartObject, attachmentsMap, attachmentList.getProcessor(attachment), memoPart);
        }
    }

    protected boolean setProcessor(AttachmentsSortedList attachmentList, AttachmentProcessor recomended) {
        boolean oneSet = false;
        for (int i = 0; i < attachmentList.size() && !recomended.isAttachmentSizeOK(attachmentList.estimateProcessedSize()); ++i) {
            Object attachment = attachmentList.get(i);
            oneSet |= attachmentList.setProcessor(attachment, recomended);
        }
        return oneSet;
    }

    private void setRecommendedAttachmentProcessorList(AttachmentsSortedList attachmentList) {
        long totalSize = attachmentList.getTotalSize();
        if (!EmailLimits.exceedsUncompressedAttachmentLimit(totalSize)) {
            return;
        }
        this.setBestIndividualProcessors(attachmentList);
        attachmentList.sortByEstimatedReduction(this.getAttachmentProcessor());
    }

    protected void setBestIndividualProcessors(AttachmentsSortedList attachmentList) {
        for (int i = 0; i < attachmentList.size(); ++i) {
            Object attachment = attachmentList.get(i);
            AttachmentProcessor bestProcessor = this.getAttachmentProcessor(attachment);
            attachmentList.setProcessor(attachment, bestProcessor);
        }
    }

    protected AttachmentProcessor getAttachmentProcessor(Object attachment) {
        AttachmentProcessor processor = this.nullProcessor;
        if ("application/x-zip-compressed".equals(this.getDataType(attachment))) {
            return processor;
        }
        if (EmailLimits.exceedsUncompressedAttachmentLimit(DataSizeChecker.getObjectSize((Object)attachment))) {
            processor = this.getAttachmentProcessor();
        }
        return processor;
    }
}

