/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.util.attachmentcheck.strategy;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.MemoPartObject;
import com.cognos.developer.schemas.bibus._3.MemoPartString;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.dls.smtp.EmailOptionsDeliverable;
import com.cognos.dls.util.AttachmentsProcessorFactory;
import com.cognos.dls.util.EmailLimits;
import com.cognos.dls.util.IAttachmentsProcessor;
import com.cognos.dls.util.attachmentcheck.AttachmentProcessor;
import com.cognos.dls.util.attachmentcheck.TruncationAttachmentProcessor;
import com.cognos.dls.util.attachmentcheck.ZippingAttachmentProcessor;
import com.cognos.dls.util.attachmentcheck.strategy.AttachmentsSortedList;
import com.cognos.dls.util.attachmentcheck.strategy.ZipAttachmentCheckStrategy;
import com.cognos.jsmcommon.util.DataSizeChecker;
import java.util.List;
import java.util.Map;

public class ZipOrTruncateAttachmentCheckStrategy
extends ZipAttachmentCheckStrategy {
    private ZippingAttachmentProcessor zipAttachmentProcessor;

    public ZipOrTruncateAttachmentCheckStrategy() {
        super(null, new TruncationAttachmentProcessor());
    }

    public ZipOrTruncateAttachmentCheckStrategy(EmailOptionsDeliverable eod) {
        super(eod, new TruncationAttachmentProcessor());
        this.setEmailOptionsdeliverable(eod);
        this.zipAttachmentProcessor = new ZippingAttachmentProcessor(eod);
    }

    @Override
    public MemoPartMIMEAttachment checkRelatedAttachments(List<?> mimeAttachments, String fileName, boolean inline) {
        MemoPartMIMEAttachment relatedMainPart;
        MemoPartMIMEAttachment attachment = null;
        if (mimeAttachments == null || mimeAttachments.size() == 0) {
            return attachment;
        }
        AttachmentsSortedList attachmentList = new AttachmentsSortedList();
        if (mimeAttachments != null) {
            attachmentList.addAttachments(mimeAttachments);
        }
        if (this.checkZeroSizeAttachments(relatedMainPart = (MemoPartMIMEAttachment)attachmentList.get(0))) {
            return relatedMainPart;
        }
        AttachmentProcessor processor = this.getAttachmentProcessor(relatedMainPart);
        if (processor.priority() == 2) {
            ZippingAttachmentProcessor zipProcessor = (ZippingAttachmentProcessor)processor;
            attachment = zipProcessor.makeZippedAttachmentPart(mimeAttachments, fileName, relatedMainPart.getDataType(), inline);
        } else if (processor.priority() == 1) {
            relatedMainPart.setName(fileName);
            processor.replaceAttachmentMemoPart(relatedMainPart, null, DataSizeChecker.getObjectSize((Object)attachment));
            attachment = relatedMainPart;
        }
        return attachment;
    }

    private boolean isDataSizeOk(long size) {
        long emailSizeLimit = EmailLimits.getTotalSizeLimit();
        long zipLimit = EmailLimits.getUncompressedAttachmentLimit();
        long checkLimit = emailSizeLimit > 0L && zipLimit > 0L ? Math.min(emailSizeLimit, zipLimit) : Math.max(emailSizeLimit, zipLimit);
        return DataSizeChecker.checkSize((long)size, (long)checkLimit);
    }

    @Override
    public boolean checkMemoPartString(MemoPartString mps) {
        return this.getTruncatingAttachmentProcesor().replaceMemoPartString(mps);
    }

    private AttachmentProcessor getTruncatingAttachmentProcesor() {
        return super.getAttachmentProcessor();
    }

    private void setRecommendedAttachmentProcessorList(AttachmentsSortedList attachmentList) {
        long totalSize = attachmentList.getTotalSize();
        if (this.isDataSizeOk(totalSize)) {
            return;
        }
        this.setBestIndividualProcessors(attachmentList);
        attachmentList.sortByEstimatedReduction(this.zipAttachmentProcessor);
        if (EmailLimits.exceedsTotalSizeLimit(attachmentList.estimateProcessedSize())) {
            attachmentList.sortByEstimatedReduction(this.getTruncatingAttachmentProcesor());
            this.setProcessor(attachmentList, this.getTruncatingAttachmentProcesor());
            attachmentList.sortByEstimate();
        }
    }

    @Override
    public void checkAllAttachments(MemoPart memoPart, MemoPartObject inlineMemoPartObject, Map<SearchPathSingleObject, BaseClass> attachmentsMap, List<?> mimeAttachments) {
        int i;
        AttachmentProcessor processor;
        Object attachment;
        AttachmentsSortedList attachmentList = new AttachmentsSortedList();
        if (mimeAttachments != null) {
            attachmentList.addAttachments(mimeAttachments);
        }
        if (attachmentsMap != null) {
            SearchPathSingleObject inlineSp = inlineMemoPartObject != null ? inlineMemoPartObject.getSearchPath() : null;
            attachmentList.addBaseClassAttachments(attachmentsMap, inlineSp);
        }
        this.setRecommendedAttachmentProcessorList(attachmentList);
        for (int i2 = 0; i2 < attachmentList.size(); ++i2) {
            attachment = attachmentList.get(i2);
            processor = attachmentList.getProcessor(attachment);
            if (processor.priority() != 1) continue;
            this.processAttachment(attachment, attachmentList, inlineMemoPartObject, attachmentsMap, processor, memoPart);
        }
        if (AttachmentsProcessorFactory.getInstance() != null) {
            IAttachmentsProcessor ap = AttachmentsProcessorFactory.getInstance();
            ap.loadAllAttachments(attachmentsMap.entrySet(), this.getEmailOptionsdeliverable());
        }
        for (i = 0; i < attachmentList.size(); ++i) {
            attachment = attachmentList.get(i);
            processor = attachmentList.getProcessor(attachment);
            if (processor.priority() == 1) continue;
            this.processAttachment(attachment, attachmentList, inlineMemoPartObject, attachmentsMap, attachmentList.getProcessor(attachment), memoPart);
        }
        if (EmailLimits.exceedsTotalSizeLimit(attachmentList.getTotalSize())) {
            attachmentList.resetEstimate();
            attachmentList.sortBySize();
            for (i = 0; i < attachmentList.size() && EmailLimits.exceedsTotalSizeLimit(attachmentList.getTotalSize()); ++i) {
                attachment = attachmentList.get(i);
                this.processAttachment(attachment, attachmentList, inlineMemoPartObject, attachmentsMap, this.getTruncatingAttachmentProcesor(), memoPart);
            }
        }
    }

    @Override
    public boolean checkAttachment(MemoPartMIMEAttachment mpma) {
        if (this.checkZeroSizeAttachments(mpma)) {
            return true;
        }
        long size = DataSizeChecker.getObjectSize((Object)mpma);
        if (this.isDataSizeOk(size)) {
            return false;
        }
        AttachmentProcessor processor = this.getAttachmentProcessor(mpma);
        processor.replaceAttachmentMemoPart(mpma, null, size);
        return true;
    }

    @Override
    protected AttachmentProcessor getAttachmentProcessor(Object attachment) {
        AttachmentProcessor processor = this.nullProcessor;
        if ("text/plain".equals(this.getDataType(attachment))) {
            return processor;
        }
        long size = DataSizeChecker.getObjectSize((Object)attachment);
        if (EmailLimits.exceedsUncompressedAttachmentLimit(size)) {
            processor = this.zipAttachmentProcessor;
        } else if (EmailLimits.exceedsTotalSizeLimit(size)) {
            processor = this.getTruncatingAttachmentProcesor();
        }
        return processor;
    }
}

