/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.control;

import com.cognos.ccl4j.exceptions.CCLException;
import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.dispatcherJSP.api.IApplication;
import com.cognos.dispatcherJSP.control.settings.ControlSettings;
import com.cognos.dispatcherJSP.jspc.JspcControl;
import com.cognos.dispatcherJSP.logging.LogControl;
import com.cognos.dispatcherJSP.pagemap.manager.PageMapObjectManager;
import com.cognos.dispatcherJSP.view.views.JSPView;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DispatcherJSP {
    public static final String ID_REQUEST_COMPLETE = "alp.request.done";
    public static final String ID_MSG_CONTEXT = "bibus.context";
    public static final String ID_DISPATCHER_JSP = "DispatcherJSP";
    public static final String PARAM_PAGE_ID = "pid";
    private ServletContext m_servletContext = null;
    private String m_basePath = null;
    private IApplication m_application = null;
    private PageMapObjectManager m_pageMapObjectManager = null;
    private boolean m_initialized = false;
    private static ControlSettings g_controlSettings = new ControlSettings();

    public synchronized void initialize(IApplication application, ServletConfig servletConfig, ServletContext servletContext) throws CCLException {
        if (application == null || servletConfig == null || servletContext == null) {
            throw new CCLRuntimeException("Null parameter passed to Alp initialize");
        }
        this.m_application = application;
        this.m_servletContext = servletContext;
        this.m_basePath = this.m_servletContext.getRealPath("/");
        if (!JspcControl.isInitialized()) {
            JspcControl.initialize(this.m_basePath, ControlSettings.getExecuteDynamicJSPCs());
        }
        String pageMapPath = this.m_application.getPageMapPath();
        this.m_pageMapObjectManager = new PageMapObjectManager();
        this.m_pageMapObjectManager.initialize(pageMapPath, ControlSettings.getPageMapDynamicReload(), servletConfig, servletContext, this.m_basePath);
        try {
            this.recoverableInitialize();
        }
        catch (Exception e) {
            String string = "Failed to initialize ALP. Will try again on demand. Caught Exception.";
        }
    }

    protected synchronized void recoverableInitialize() throws Exception {
        if (this.m_initialized) {
            return;
        }
        Throwable throwable = null;
        try {
            if (!this.m_application.isInitialized()) {
                this.m_application.initialize(this.m_pageMapObjectManager);
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        finally {
            if (throwable != null) {
                throw new CCLRuntimeException(throwable, "Initializing the application");
            }
        }
        this.m_initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) {
        String pid = "";
        boolean bShowDebugPage = false;
        try {
            LogControl.getInstance().logHttpServletRequest(request);
            request.setAttribute(ID_DISPATCHER_JSP, (Object)this);
            this.m_pageMapObjectManager.reloadIfNecessary();
            this.m_application.startRequest(request);
            if (!this.m_initialized) {
                Throwable throwable = null;
                try {
                    this.recoverableInitialize();
                }
                catch (Throwable t) {
                    throwable = t;
                }
                if (!this.m_initialized) {
                    throw new CCLRuntimeException(throwable, "attempting to recover from previous initialization failure. Requested pid (" + pid + ")");
                }
            }
            boolean skipApp = false;
            boolean bIsAppErrorPage = false;
            boolean applicationProcessedOk = false;
            applicationProcessedOk = this.m_application.processRequest(request, response);
            if (!applicationProcessedOk) {
                return;
            }
            pid = request.getParameter(PARAM_PAGE_ID);
            if (pid == null) {
                throw new CCLRuntimeException("Attempting to execute a page with a null page id (pid)");
            }
            this.executePage(pid, request, response);
        }
        catch (Throwable t) {
            String appErrorPid = this.m_application.getErrorPageID(request);
            boolean handled = false;
            if (pid != null && appErrorPid != null && !pid.equals(appErrorPid)) {
                int processingCode = this.m_application.prepareForErrorPage(pid, t, request, response);
                if (processingCode == 1) {
                    if (!response.isCommitted()) {
                        response.resetBuffer();
                        this.executePage(appErrorPid, request, response);
                        handled = true;
                    }
                } else if (processingCode == 2) {
                    handled = true;
                }
            }
            if (!handled) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new CCLRuntimeException(t, "Exception occured processing pid " + pid);
            }
            LogControl.getInstance().logException(t);
        }
        finally {
            if (this.m_application != null) {
                this.m_application.endRequest(request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executePage(String pid, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (pid == null || request == null || response == null) {
                throw new CCLRuntimeException("Null request, response, or page id");
            }
            this.executeView(request, response, pid);
        }
        finally {
            if (pid != null) {
                request.setAttribute(ID_REQUEST_COMPLETE, (Object)pid);
            }
        }
    }

    private void executeView(HttpServletRequest request, HttpServletResponse response, String pid) {
        if (request == null || response == null) {
            return;
        }
        JSPView view = this.getView(request, pid);
        if (view == null) {
            return;
        }
        try {
            view.render(request, response, pid);
        }
        catch (RuntimeException rt) {
            throw rt;
        }
        catch (Exception t) {
            throw new CCLRuntimeException((Throwable)t, "dispatching to pid '" + pid + "', view '" + view);
        }
    }

    final JSPView getView(HttpServletRequest request, String pid) {
        if (this.m_pageMapObjectManager == null) {
            throw new CCLRuntimeException("Attempting to get PageMapObjectManager when it has not yet been set");
        }
        return this.m_pageMapObjectManager.getView(request, pid);
    }

    private static void throwPageNotFoundException(HttpServletRequest request, HttpServletResponse response) throws CCLRuntimeException {
        String sContext = request.getContextPath();
        String sURI = request.getRequestURI();
        String sPID = request.getParameter(PARAM_PAGE_ID);
        throw new CCLRuntimeException("Specified PID could not be found in the pagemap. URI='" + sURI + "'  PID='" + sPID + "' Context Path='" + sContext + "'");
    }

    public final IApplication getApplication() {
        return this.m_application;
    }

    public final boolean isInitialized() {
        return this.m_initialized;
    }

    public final void dispose() {
        if (this.m_application != null) {
            this.m_application.close();
        }
        this.m_application = null;
        if (this.m_pageMapObjectManager != null) {
            this.m_pageMapObjectManager.close();
            this.m_pageMapObjectManager = null;
        }
        this.m_servletContext = null;
        this.m_initialized = false;
    }
}

