/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.dispatcher;

import com.cognos.ccl4j.exceptions.CCLException;
import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.dispatcherJSP.api.DispatcherJSPDriver;
import com.cognos.dispatcherJSP.api.IApplication;
import com.cognos.dispatcherJSP.control.DispatcherJSP;
import com.cognos.dispatcherJSP.control.settings.ControlSettings;
import com.cognos.dispatcherJSP.dispatcher.CleanableAlpRequest;
import com.cognos.dispatcherJSP.dispatcher.MessageContextWrapper;
import com.cognos.dispatcherJSP.logging.LogControl;
import com.cognos.dispatcherJSP.servlet.BufferedIOResponseStream;
import com.cognos.dispatcherJSP.servlet.StandaloneHttpServletRequest;
import com.cognos.dispatcherJSP.servlet.StandaloneHttpServletResponse;
import com.cognos.dispatcherJSP.servlet.StandaloneServletConfig;
import com.cognos.dispatcherJSP.servlet.StandaloneServletContext;
import com.cognos.pogo.pdk.MessageContext;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.mail.internet.InternetHeaders;
import org.apache.soap.util.mime.MimeUtils;

public class DispatcherAlpDriver
extends DispatcherJSPDriver {
    public static final int RESPONSE_BUFFER_SIZE = 16384;
    private static boolean _bNeverTimeout = ControlSettings.getBufferNeverTimeout();
    private static int _bufferTimeout = ControlSettings.getBufferTimeout();
    private static final int DEFAULT_WORKTHREADCOMMIT_TIMEOUT = 360000;
    public static int _threadID = 1;
    private static final String DEFAULT_PATH_INFO = "";
    private static final String DEFAULT_PROTOCOL = "HTTP/1.1";
    private static final String DEFAULT_SERVLET_PATH = "notapplicable";
    protected String m_host = null;
    protected int m_port = 0;
    protected String m_basePath = null;
    protected String m_serverInfo = null;
    protected String m_servletContextName = null;
    private StandaloneServletConfig m_servletConfig = null;
    private StandaloneServletContext m_servletContext = null;
    private Throwable m_initializeThrowable = null;
    protected DispatcherJSP m_alp = null;
    protected IApplication m_application = null;

    public DispatcherAlpDriver(IApplication application, String host, int port, String basePath, String serverInfo, String servletContextName) throws CCLException {
        if (application == null || host == null || port < 0 || basePath == null || serverInfo == null || servletContextName == null) {
            throw new CCLRuntimeException("Invalid parameter to StandaloneAlpDriver.");
        }
        this.m_application = application;
        this.m_host = host;
        this.m_port = port;
        this.m_basePath = basePath;
        this.m_serverInfo = serverInfo;
        this.m_servletContextName = servletContextName;
    }

    public void initialize() {
        try {
            this.m_servletConfig = new StandaloneServletConfig(this.getServletName());
            this.m_servletContext = new StandaloneServletContext(this.m_basePath, this.m_serverInfo, this.m_servletContextName, this.m_servletConfig);
            this.m_servletConfig.setServletContext(this.m_servletContext);
            this.m_alp = new DispatcherJSP();
            this.m_alp.initialize(this.m_application, this.m_servletConfig, this.m_servletContext);
        }
        catch (Throwable t) {
            this.m_initializeThrowable = t;
            throw new CCLRuntimeException(t, "initializing StandaloneAlpDriver");
        }
        this.m_initializeThrowable = null;
    }

    @Override
    public final void service(MessageContext requestObject) {
        try {
            this.serviceThreaded(requestObject);
        }
        catch (ClassCastException e) {
            throw new CCLRuntimeException((Throwable)e, "This implementation of AbstractStandaloneAlpDriver is expecting a MessageContext.");
        }
    }

    @Override
    public void dispose() {
        if (this.m_alp != null) {
            this.m_alp.dispose();
            this.m_alp = null;
        }
        this.m_servletConfig = null;
        this.m_servletContext = null;
        this.m_application = null;
    }

    public final String getRequestURI() {
        return "unsupported";
    }

    public final String getContextPath() {
        return "unsupported";
    }

    public String getServletName() {
        return "unsupported";
    }

    private void serviceThreaded(MessageContext msgContext) {
        LogControl.getInstance().logMessageContext(msgContext);
        if (msgContext == null) {
            throw new CCLRuntimeException("Null parameter");
        }
        try {
            Throwable runThrowable;
            if (this.m_initializeThrowable != null) {
                this.m_alp.initialize(this.m_application, this.m_servletConfig, this.m_servletContext);
            }
            MessageContextWrapper wrappedMsgCtx = new MessageContextWrapper(msgContext);
            Map parameterMap = wrappedMsgCtx.messageContextToParameterMap();
            StandaloneHttpServletRequest request = this.buildRequest(parameterMap);
            request.setAttribute("bibus.context", msgContext);
            InternetHeaders mailHeaders = (InternetHeaders)msgContext.getProperty("request.headers");
            request.addInternetHeaders(mailHeaders);
            StandaloneHttpServletResponse response = null;
            long nTimeout = _bufferTimeout;
            if (nTimeout <= 0L) {
                nTimeout = 360000L;
            }
            if (_bNeverTimeout) {
                nTimeout = 0L;
            }
            BufferedIOResponseStream inputStream = null;
            try {
                response = new StandaloneHttpServletResponse(request, null);
                inputStream = new BufferedIOResponseStream(nTimeout, response);
                response.setStream(inputStream.getOutputStream());
            }
            catch (Exception e) {
                throw new CCLRuntimeException((Throwable)e, "setting up streams");
            }
            Thread thrdCurrent = Thread.currentThread();
            String sThreadName = thrdCurrent.getName();
            CleanableAlpRequest alpRequest = new CleanableAlpRequest(this, request, response, inputStream, sThreadName);
            alpRequest.start();
            long nTimeoutWaitStartMillis = System.currentTimeMillis();
            boolean bCommitted = false;
            try {
                bCommitted = response.waitForCommit(nTimeout);
            }
            catch (InterruptedException ie) {
                long nTimeoutWaitMillis = System.currentTimeMillis() - nTimeoutWaitStartMillis;
                throw new CCLRuntimeException("Timed out after waiting " + nTimeoutWaitMillis + " milliseconds work thread");
            }
            int responseStatus = response.getStatus();
            msgContext.setProperty("response.status_code", (Object)Integer.toString(responseStatus));
            if (bCommitted) {
                ArrayList<BufferedIOResponseStream> responseList = new ArrayList<BufferedIOResponseStream>(1);
                responseList.add(inputStream);
                msgContext.setProperty("response.attachments", responseList.iterator());
                msgContext.setProperty("response.boundary", (Object)MimeUtils.getUniqueValue());
            }
            if ((runThrowable = alpRequest.getRunThrowable()) != null) {
                throw runThrowable;
            }
        }
        catch (Throwable t) {
            LogControl.getInstance().logException(t);
            throw new CCLRuntimeException(t, "CMM request driver executing threaded request");
        }
    }

    protected StandaloneHttpServletRequest buildRequest(Map parameterMap) {
        return new StandaloneHttpServletRequest(this.m_host, this.m_port, this.getRequestURI(), this.getContextPath(), this.m_basePath, DEFAULT_SERVLET_PATH, DEFAULT_PATH_INFO, DEFAULT_PROTOCOL, parameterMap, this.m_servletConfig, this.m_servletContext);
    }

    protected void closeResponseStream(StandaloneHttpServletResponse response) {
        if (response == null) {
            return;
        }
        OutputStream outputStream = response.getStream();
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

