/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.dispatcher;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.dispatcherJSP.dispatcher.DispatcherAlpDriver;
import com.cognos.dispatcherJSP.logging.LogControl;
import com.cognos.dispatcherJSP.servlet.BufferedIOResponseStream;
import com.cognos.dispatcherJSP.servlet.StandaloneHttpServletRequest;
import com.cognos.dispatcherJSP.servlet.StandaloneHttpServletResponse;

class RunnableAlpRequest
implements Runnable {
    private final DispatcherAlpDriver m_dispatcherAlpDriver;
    protected StandaloneHttpServletRequest m_request = null;
    protected StandaloneHttpServletResponse m_response = null;
    protected BufferedIOResponseStream m_inputStream = null;
    protected String m_sParentThreadName = null;
    protected Throwable m_runThrowable = null;
    protected Thread m_requestThread = null;

    public RunnableAlpRequest(DispatcherAlpDriver dispatcherAlpDriver, StandaloneHttpServletRequest request, StandaloneHttpServletResponse response, BufferedIOResponseStream inputStream, String sParentThreadName) {
        this.m_dispatcherAlpDriver = dispatcherAlpDriver;
        this.init(request, response, inputStream, sParentThreadName);
    }

    private void init(StandaloneHttpServletRequest request, StandaloneHttpServletResponse response, BufferedIOResponseStream inputStream, String sParentThreadName) {
        if (request == null || response == null || inputStream == null) {
            throw new CCLRuntimeException("Null parameter.");
        }
        this.m_request = request;
        this.m_response = response;
        this.m_inputStream = inputStream;
        this.m_sParentThreadName = sParentThreadName;
    }

    public void start() {
        String sNewThreadName = "ExecuteThread-" + DispatcherAlpDriver._threadID++;
        if (this.m_sParentThreadName != null) {
            sNewThreadName = this.m_sParentThreadName + "-ALPDriver";
        }
        this.m_requestThread = new Thread((Runnable)this, sNewThreadName);
        this.m_requestThread.start();
    }

    public void close() {
        this.m_dispatcherAlpDriver.closeResponseStream(this.m_response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_runThrowable = null;
        try {
            this.m_dispatcherAlpDriver.m_alp.service(this.m_request, this.m_response);
            this.m_inputStream.markEndOfReceiverStream();
            this.m_response.finishResponse();
        }
        catch (Throwable th) {
            LogControl.getInstance().logException(th);
            CCLRuntimeException alpEx = new CCLRuntimeException(th, "in standalone ALP driver thread");
            this.m_runThrowable = alpEx;
            try {
                if (this.m_response.isCommitted()) {
                    // empty if block
                }
                this.m_response.finishResponse();
                this.m_inputStream.markEndOfReceiverStream();
            }
            catch (Exception e1) {
                CCLRuntimeException alpEx1 = new CCLRuntimeException((Throwable)e1, "recovering from ALP thread exception");
                alpEx1.printStackTrace();
            }
            finally {
                this.m_inputStream.markEndOfReceiverStream();
            }
        }
    }

    public Throwable getRunThrowable() {
        return this.m_runThrowable;
    }
}

