/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.jspc;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;

public class JspcBodyContentImpl
extends BodyContent {
    private char[] cb = new char[this.bufferSizeImpl];
    protected int bufferSizeImpl = 512;
    private int nextChar = 0;
    static String lineSeparator = System.getProperty("line.separator");
    private boolean closed = false;

    public JspcBodyContentImpl(JspWriter writer) {
        super(writer);
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public void write(int c) throws IOException {
        this.ensureOpen();
        if (this.nextChar >= this.bufferSizeImpl) {
            this.reAllocBuff(0);
        }
        this.cb[this.nextChar++] = (char)c;
    }

    private void reAllocBuff(int len) {
        char[] tmp = null;
        if (len <= 512) {
            tmp = new char[this.bufferSizeImpl + 512];
            this.bufferSizeImpl += 512;
        } else {
            tmp = new char[this.bufferSizeImpl + len];
            this.bufferSizeImpl += len;
        }
        System.arraycopy(this.cb, 0, tmp, 0, this.cb.length);
        this.cb = tmp;
        tmp = null;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (len >= this.bufferSizeImpl - this.nextChar) {
            this.reAllocBuff(len);
        }
        System.arraycopy(cbuf, off, this.cb, this.nextChar, len);
        this.nextChar += len;
    }

    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(String s, int off, int len) throws IOException {
        this.ensureOpen();
        if (len >= this.bufferSizeImpl - this.nextChar) {
            this.reAllocBuff(len);
        }
        s.getChars(off, off + len, this.cb, this.nextChar);
        this.nextChar += len;
    }

    public void write(String s) throws IOException {
        this.write(s, 0, s.length());
    }

    public void newLine() throws IOException {
        this.write(lineSeparator);
    }

    public void print(boolean b) throws IOException {
        this.write(b ? "true" : "false");
    }

    public void print(char c) throws IOException {
        this.write(String.valueOf(c));
    }

    public void print(int i) throws IOException {
        this.write(String.valueOf(i));
    }

    public void print(long l) throws IOException {
        this.write(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void print(char[] s) throws IOException {
        this.write(s);
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    public void print(Object obj) throws IOException {
        this.write(String.valueOf(obj));
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(char x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(int x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(long x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(float x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(double x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(char[] x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(String x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(Object x) throws IOException {
        this.print(x);
        this.println();
    }

    public void clear() throws IOException {
        this.nextChar = 0;
    }

    public void clearBuffer() throws IOException {
        this.clear();
    }

    public void close() throws IOException {
        this.cb = null;
        this.closed = true;
    }

    public int getRemaining() {
        return this.bufferSizeImpl - this.nextChar;
    }

    public Reader getReader() {
        return new CharArrayReader(this.cb, 0, this.nextChar);
    }

    public String getString() {
        return new String(this.cb, 0, this.nextChar);
    }

    public void writeOut(Writer out) throws IOException {
        out.write(this.cb, 0, this.nextChar);
    }
}

