/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.jspc;

import com.cognos.dispatcherJSP.control.settings.ControlSettings;
import com.cognos.dispatcherJSP.dynclass.DynClass;
import com.cognos.dispatcherJSP.dynclass.DynClassGenerator;
import com.cognos.dispatcherJSP.dynclass.DynClassLoader;
import com.cognos.dispatcherJSP.exceptions.DynamicException;
import com.cognos.dispatcherJSP.jspc.JspcClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;

public class JspcClassGenerator
extends DynClassGenerator {
    private static boolean _bClassInitDone = false;
    private static boolean _bJSPCCompileEnabled = false;
    private boolean _bInstanceInitDone = false;
    private String m_sRootDirpath;
    private String _sWebappRootDirpath;
    private int _nJSPCClassPackageRoot_length;
    private String _s_JSP_RootDirpath;
    private String _s_JSPJava_RootDirpath;
    private String _s_JSPCClasses_RootDirpath;
    private static Class _clsJavaCompiler = null;
    private String _sClasspath = null;
    private static final String JSPC_PREFIX = "jspc:/";
    private static final int JSPC_PREFIX_LEN = "jspc:/".length();

    public JspcClassGenerator(ClassLoader clParent) {
        super(clParent);
    }

    @Override
    public DynClassLoader getNewDynClassLoader() {
        JspcClassLoader dclRet = null;
        try {
            File fClassesDir = new File(this._s_JSPCClasses_RootDirpath);
            URL url = fClassesDir.toURL();
            URL[] vURL = new URL[]{url};
            dclRet = new JspcClassLoader(vURL, this._clParent);
        }
        catch (MalformedURLException mfu) {
            throw new RuntimeException(mfu.getMessage(), mfu);
        }
        return dclRet;
    }

    public static void initialize(String sClassesRootDirpath, String sCMMRootDirpath, boolean bSupportDynamicReload) {
        if (_bClassInitDone) {
            return;
        }
        _bClassInitDone = true;
        if (bSupportDynamicReload) {
            _bJSPCCompileEnabled = false;
            String sJavacClassname = "com.sun.tools.javac.Main";
            try {
                _clsJavaCompiler = Class.forName(sJavacClassname);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
            _bJSPCCompileEnabled = true;
        }
    }

    public void setRootDirpath(String sRootDirpath) {
        this.m_sRootDirpath = sRootDirpath;
    }

    public void setWebappRootDirpath(String sWebappRootDirpath) {
        this._sWebappRootDirpath = sWebappRootDirpath;
    }

    public void setJSPRootDirpath(String sJSPRootDirpath) {
        this._s_JSP_RootDirpath = sJSPRootDirpath;
    }

    public void setJSPJavaRootDirpath(String sJSPJavaRootDirpath) {
        this._s_JSPJava_RootDirpath = sJSPJavaRootDirpath;
    }

    public void setJSPCClassesRootDirpath(String sJSPCClassesRootDirpath) {
        this._s_JSPCClasses_RootDirpath = sJSPCClassesRootDirpath;
    }

    @Override
    public String getJavaClassName(String sName) {
        String sRet = null;
        sRet = sName.startsWith(JSPC_PREFIX) ? this.getClassname(sName) : sName;
        return sRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DynClass buildDynClass(String sName_param, DynClass dc_param) {
        DynClass dcRet;
        block22: {
            dcRet = dc_param;
            String sJspcName = this.getCanonicalName(sName_param);
            if (!this._bInstanceInitDone) {
                this.initializeGeneratorInstance();
            }
            try {
                String sJSPFilepath = this._s_JSP_RootDirpath + "/" + JspcClassGenerator.stripPrefix(sJspcName);
                if (!_bJSPCCompileEnabled) {
                    throw new RuntimeException("Attempt to compile JSPC when disabled");
                }
                String sJSPPackage = JspcClassGenerator.getPackageRoot(sJspcName);
                String sJSPJavaFilepath = this._s_JSPJava_RootDirpath + "/" + JspcClassGenerator.getFileClassnameRoot(sJspcName) + ".java";
                String sJSPCClassFilepath = this._s_JSPCClasses_RootDirpath + "/" + this.getFileClassname(sJspcName) + ".class";
                String sClassName = JspcClassGenerator.getClassnameBase(sJspcName);
                boolean bNeedsCompile = true;
                if (dcRet == null) {
                    dcRet = new DynClass(this, this._clParent, sJspcName);
                    try {
                        dcRet.loadClass();
                        long nJSPLastModified = JspcClassGenerator.getFileLastModifiedTime(sJSPCClassFilepath);
                        dcRet.setTimestamp(nJSPLastModified);
                        ArrayList vDependsOnFiles = new ArrayList();
                        vDependsOnFiles.add(sJSPFilepath);
                        if (dcRet != null) {
                            vDependsOnFiles = this.getDependsOnFiles(dcRet, vDependsOnFiles);
                            dcRet.setDependsOnFiles(vDependsOnFiles);
                            if (!dcRet.needsRebuild()) {
                                bNeedsCompile = false;
                            }
                        }
                    }
                    catch (ClassNotFoundException nJSPLastModified) {
                        // empty catch block
                    }
                }
                if (!bNeedsCompile) break block22;
                JspcClassGenerator nJSPLastModified = this;
                synchronized (nJSPLastModified) {
                    try {
                        boolean deleted = true;
                        File fJSPJava = new File(sJSPJavaFilepath);
                        if (fJSPJava.exists()) {
                            deleted = fJSPJava.delete();
                        }
                        if (deleted) {
                            this.compileJSP(sJSPFilepath, sClassName, sJSPPackage);
                            this.compileJSPJava(sJSPJavaFilepath);
                        }
                    }
                    catch (RuntimeException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("dynamically compiling JSPC file " + sJspcName, ex);
                    }
                }
                try {
                    dcRet.loadClass();
                    long nJSPLastModified2 = JspcClassGenerator.getFileLastModifiedTime(sJSPCClassFilepath);
                    dcRet.setTimestamp(nJSPLastModified2);
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new RuntimeException("loading dynamically compiling JSPC class " + sJspcName, ex);
                }
                ArrayList vDependsOnFiles = new ArrayList();
                vDependsOnFiles.add(sJSPFilepath);
                if (dcRet != null) {
                    vDependsOnFiles = this.getDependsOnFiles(dcRet, vDependsOnFiles);
                    dcRet.setDependsOnFiles(vDependsOnFiles);
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        return dcRet;
    }

    private ArrayList getDependsOnFiles(DynClass dc, ArrayList vFiles) {
        ArrayList vRet = vFiles;
        Vector vFilepaths = null;
        Class cls = dc.getClassObject();
        if (cls != null) {
            Method methGetFiles = null;
            try {
                methGetFiles = cls.getDeclaredMethod("getIncludes", new Class[0]);
            }
            catch (NoSuchMethodException nsm) {
                throw new RuntimeException(nsm.getMessage(), nsm);
            }
            try {
                Object[] vParms = new Object[]{};
                Object obj = methGetFiles.invoke(null, vParms);
                vFilepaths = (Vector)obj;
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException(ite.getMessage(), ite);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae.getMessage(), iae);
            }
            for (int i = 0; vFilepaths != null && i < vFilepaths.size(); ++i) {
                String sTail = (String)vFilepaths.elementAt(i);
                String sFilepath = this._s_JSP_RootDirpath + sTail;
                vRet.add(sFilepath);
            }
        }
        return vRet;
    }

    private static long getFileLastModifiedTime(String sFilepath) {
        long nRet = 0L;
        JspcClassGenerator.ensureFilepathExists(sFilepath);
        File f = new File(sFilepath);
        nRet = f.lastModified();
        return nRet;
    }

    private String getCanonicalName(String sName) {
        String sRet = sName;
        if (!sRet.startsWith(JSPC_PREFIX)) {
            StringBuffer sb = new StringBuffer(200);
            sb.append(JSPC_PREFIX);
            String sTemp = sRet.substring(this._nJSPCClassPackageRoot_length + 1, sRet.length() - 4);
            sTemp = sTemp.replace('.', '/');
            sb.append(sTemp);
            sb.append(".jsp");
            sRet = sb.toString();
        }
        return sRet;
    }

    private String getClassname(String sName) {
        StringBuffer sb = new StringBuffer(100);
        sb.append(JspcClassGenerator.getClassnameRoot(sName));
        String sRet = sb.toString();
        return sRet;
    }

    private String getFileClassname(String sName) {
        String sRet = this.getClassname(sName);
        sRet = sRet.replace('.', '/');
        return sRet;
    }

    private static String stripPrefix(String sName) {
        String sRet = sName;
        if (sName.startsWith(JSPC_PREFIX)) {
            sRet = sName.substring(JSPC_PREFIX_LEN);
        }
        return sRet;
    }

    private static String getClassnameRoot(String sName) {
        String sRet = JspcClassGenerator.stripPrefix(sName);
        int nIdx = sRet.indexOf(".jsp");
        if (nIdx > -1) {
            sRet = sRet.substring(0, nIdx);
            sRet = sRet + "_jsp";
        }
        sRet = sRet.replace('/', '.');
        return sRet;
    }

    private static String getClassnameBase(String sName) {
        String sRet = JspcClassGenerator.getClassnameRoot(sName);
        int nIdx = sRet.lastIndexOf(".");
        if (nIdx > -1) {
            sRet = sRet.substring(nIdx + 1);
        }
        return sRet;
    }

    private static String getFileClassnameRoot(String sName) {
        String sRet = JspcClassGenerator.getClassnameRoot(sName);
        sRet = sRet.replace('.', '/');
        return sRet;
    }

    private static String getPackageRoot(String sName) {
        String sRet = JspcClassGenerator.getClassnameRoot(sName);
        int nIdx = sRet.lastIndexOf(".");
        sRet = sRet.substring(0, nIdx);
        return sRet;
    }

    public static String getURLRoot(String sName) {
        String sRet = JspcClassGenerator.getFileClassnameRoot(sName);
        int nIdx = sRet.lastIndexOf("/");
        sRet = sRet.substring(0, nIdx);
        return sRet;
    }

    private void compileJSP(String sJSPFilepath, String sClassname, String sPackage) {
        JspcClassGenerator.ensureFilepathExists(sJSPFilepath);
        String sVerbosity = "-v2";
        try {
            Vector<String> vParms = new Vector<String>();
            vParms.add(sVerbosity);
            vParms.add("-d");
            vParms.add(this._s_JSPJava_RootDirpath);
            vParms.add("-uriroot");
            vParms.add(this._s_JSP_RootDirpath);
            vParms.add("-p");
            vParms.add(sPackage);
            vParms.add(sJSPFilepath);
            String[] aParms = new String[vParms.size()];
            for (int i = 0; i < vParms.size(); ++i) {
                aParms[i] = (String)vParms.get(i);
            }
            try {
                Class<?> alpJasper = Class.forName("com.cognos.dispatcherJSP.jspc.jasper.ALPJasper");
                Object jasper = alpJasper.newInstance();
                Class[] classes = new Class[]{String[].class};
                Method m = alpJasper.getMethod("setArgs", classes);
                Object[] arguments = new Object[]{aParms};
                m.invoke(jasper, arguments);
                Method executeMethod = alpJasper.getMethod("execute", new Class[0]);
                executeMethod.invoke(jasper, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable e1 = e.getTargetException();
                e1.printStackTrace();
                throw new DynamicException("Error attempting to compile JSP: " + sJSPFilepath, e1);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
                throw new DynamicException("Error attempting to compile JSP: " + sJSPFilepath, e);
            }
        }
        catch (Exception ex) {
            throw new DynamicException("Error attempting to compile JSP: " + sJSPFilepath, ex);
        }
    }

    private void compileJSPJava(String sJSPCJavaFilepath) {
        JspcClassGenerator.ensureFilepathExists(sJSPCJavaFilepath);
        int nRC = 0;
        try {
            Vector<String> vParms = new Vector<String>();
            vParms.add("-g");
            vParms.add("-d");
            vParms.add(this._s_JSPCClasses_RootDirpath);
            vParms.add("-classpath");
            vParms.add(this._sClasspath);
            vParms.add(sJSPCJavaFilepath);
            String[] aParms = new String[vParms.size()];
            for (int i = 0; i < vParms.size(); ++i) {
                aParms[i] = (String)vParms.get(i);
            }
            Class[] aParmTypes = new Class[]{aParms.getClass(), PrintWriter.class};
            Object javac = _clsJavaCompiler.newInstance();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            PrintWriter javacOutput = new PrintWriter(outStream);
            Method methMain = _clsJavaCompiler.getMethod("compile", aParmTypes);
            Object[] aParmList = new Object[]{aParms, javacOutput};
            Object objRC = methMain.invoke(javac, aParmList);
            Integer intRC = (Integer)objRC;
            nRC = intRC;
            if (nRC != 0) {
                throw new RuntimeException("Java compile error: \r\n" + outStream.toString());
            }
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae.getMessage(), iae);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie.getMessage(), ie);
        }
        catch (NoSuchMethodException nsm) {
            throw new RuntimeException(nsm.getMessage(), nsm);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite.getMessage(), ite);
        }
    }

    private void initializeGeneratorInstance() {
        this._bInstanceInitDone = true;
        this.makeDir(this._s_JSPJava_RootDirpath);
        this.makeDir(this._s_JSPCClasses_RootDirpath);
        this.buildClasspath();
    }

    private void makeDir(String sDirpath) {
        File fDir = new File(sDirpath);
        if (!fDir.exists()) {
            fDir.mkdirs();
        } else if (!fDir.isDirectory()) {
            throw new RuntimeException("JSPC dynamic compile: root dir is not a directory: '" + sDirpath + "'");
        }
    }

    private void buildClasspath() {
        StringBuffer sb = new StringBuffer(2000);
        String servletJar = ControlSettings.getProperty("dispatcherJSP.dev.jscp.servletClassesJar", "/tomcat/lib/servlet-api.jar");
        sb.append(this.m_sRootDirpath).append(servletJar);
        sb.append(";");
        String jspJar = ControlSettings.getProperty("dispatcherJSP.dev.jscp.jspClassesJar", "/tomcat/lib/jsp-api.jar");
        sb.append(this.m_sRootDirpath).append(jspJar);
        sb.append(";");
        sb.append(this._s_JSPCClasses_RootDirpath).append(";");
        sb.append(this._sWebappRootDirpath).append("/WEB-INF/classes");
        String sWebappLibDirpath = this._sWebappRootDirpath + "/WEB-INF/lib";
        this.addDirToClasspathToSB(sb, sWebappLibDirpath);
        this._sClasspath = sb.toString();
    }

    private void addDirToClasspathToSB(StringBuffer sb, String sDirpath) {
        JspcClassGenerator.ensureFilepathExists(sDirpath, true);
        File fWebappLib = new File(sDirpath);
        String[] vFiles = fWebappLib.list();
        for (int nIdx = 0; nIdx < vFiles.length; ++nIdx) {
            String sFilename = vFiles[nIdx];
            if (!sFilename.endsWith(".jar")) continue;
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(sDirpath);
            sb.append("/");
            sb.append(sFilename);
        }
    }

    private static void ensureFilepathExists(String sFilepath) {
        JspcClassGenerator.ensureFilepathExists(sFilepath, false);
    }

    private static void ensureFilepathExists(String sFilepath, boolean bIsDirectory) {
        File f = new File(sFilepath);
        if (!f.exists()) {
            throw new DynamicException("JSPC compile: file does not exist: " + sFilepath);
        }
        if (bIsDirectory && !f.isDirectory()) {
            throw new DynamicException("JSPC compile: path must be a directory: " + sFilepath);
        }
    }
}

