/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.jspc;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.dispatcherJSP.control.DispatcherJSP;
import com.cognos.dispatcherJSP.jspc.JspcClassGenerator;
import com.cognos.dispatcherJSP.jspc.JspcControl;
import com.cognos.dispatcherJSP.jspc.JspcPageBase;
import com.cognos.dispatcherJSP.servlet.StandaloneHttpServletRequest;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;

public class JspcDispatcher {
    public static JspcPageBase getJspcPage(String url) {
        JspcPageBase page = JspcControl.getJspcPageForURL(url);
        return page;
    }

    public static void dispatch(JspcPageBase jspcPage, ServletConfig servletConfig, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String url) {
        if (servletConfig == null || servletContext == null || request == null || response == null || url == null) {
            throw new IllegalArgumentException("Null parameter.");
        }
        try {
            if (jspcPage == null) {
                jspcPage = JspcDispatcher.getJspcPage(url);
            }
            jspcPage.init(servletConfig, servletContext);
            jspcPage.setPageURL(url);
            jspcPage.setIsIncluded(false);
            jspcPage.setPageURLRoot(JspcClassGenerator.getURLRoot(url));
            JspWriter out = null;
            jspcPage.prepForService_base(request, response, out);
            jspcPage.prepForService(request, response, out);
            jspcPage.renderPage();
        }
        catch (RuntimeException rt) {
            throw rt;
        }
        catch (Exception e) {
            String msg = "executing JSPC for url '" + url + "'";
            throw new CCLRuntimeException((Throwable)e, msg);
        }
    }

    public static void include(ServletContext context, HttpServletRequest request, HttpServletResponse response, String sRelativePath) {
        InputStreamReader fr = null;
        try {
            if (sRelativePath.startsWith("?")) {
                DispatcherJSP jspDispatcher = (DispatcherJSP)request.getAttribute("DispatcherJSP");
                if (request instanceof StandaloneHttpServletRequest) {
                    StandaloneHttpServletRequest sa = (StandaloneHttpServletRequest)request;
                    int nIdx = sRelativePath.indexOf("?");
                    String sParameters = null;
                    if (nIdx > -1) {
                        sParameters = sRelativePath.substring(nIdx + 1);
                        sRelativePath = sRelativePath.substring(0, nIdx);
                    }
                    HashMap mParameters = JspcDispatcher.getParametersFromString(sParameters);
                    StandaloneHttpServletRequest cloned = sa.cloneWithParameters(mParameters);
                    cloned.setAttribute("pid", mParameters.get("pid"));
                    jspDispatcher.service(cloned, response);
                }
            } else {
                fr = new FileReader(context.getRealPath(sRelativePath));
                PrintWriter writer = response.getWriter();
                char[] buffer = new char[1024];
                boolean totalRead = false;
                int read = -1;
                while ((read = fr.read(buffer, 0, 1023)) != -1) {
                    writer.write(buffer, 0, read);
                }
            }
        }
        catch (Exception e) {
            String msg = "Error attempting to include file: " + sRelativePath;
            throw new CCLRuntimeException((Throwable)e, msg);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String getNormalizedURL(String sURL) {
        String s;
        String sRet = null;
        ArrayList<String> vSegments = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(sURL, "/");
        while (st.hasMoreTokens()) {
            String sTok = st.nextToken();
            vSegments.add(sTok);
        }
        vSegments.add("");
        StringBuffer sb = new StringBuffer(200);
        int i = 0;
        while ((s = (String)vSegments.get(i)).length() != 0) {
            String sNext = (String)vSegments.get(i + 1);
            if (!sNext.equals("..") && !sNext.equals(".")) {
                sb.append("/");
                sb.append(s);
                ++i;
                continue;
            }
            if (sNext.equals(".")) {
                sb.append("/");
                sb.append(s);
            }
            ++i;
            ++i;
        }
        sRet = sb.toString();
        return sRet;
    }

    private static HashMap getParametersFromString(String s) {
        HashMap<String, String[]> mRet = null;
        if (s != null && s.length() > 0) {
            mRet = new HashMap<String, String[]>();
            int nIdxStart = 0;
            int nIdxEqual = -1;
            int nIdxAmp = -1;
            while (true) {
                nIdxEqual = s.indexOf("=", nIdxStart);
                String sKey = s.substring(nIdxStart, nIdxEqual);
                nIdxAmp = s.indexOf("&", nIdxEqual);
                String sValue = null;
                sValue = nIdxAmp > -1 ? s.substring(nIdxEqual + 1, nIdxAmp) : s.substring(nIdxEqual + 1);
                String[] vValue = new String[]{sValue};
                mRet.put(sKey, vValue);
                if (nIdxAmp <= -1) break;
                nIdxStart = ++nIdxAmp;
            }
        }
        return mRet;
    }
}

