/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.jspc;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.dispatcherJSP.dynclass.DynClass;
import com.cognos.dispatcherJSP.jspc.JspcControl;
import com.cognos.dispatcherJSP.jspc.JspcPageBase;

final class JspcPageCacheEntry {
    String m_sURL;
    String m_sJspcClassname;
    DynClass m_dynClass;
    Class m_class;

    JspcPageCacheEntry(String sURL) {
        this.m_sURL = sURL;
        this.m_sJspcClassname = "jspc:" + this.m_sURL;
        if (!JspcControl._bDoDynamicReload) {
            String sClassname = JspcControl._jspcClassGenerator.getJavaClassName(this.m_sJspcClassname);
            try {
                this.m_class = Class.forName(sClassname);
            }
            catch (Exception ex) {
                throw new CCLRuntimeException((Throwable)ex, "loading JSPC class '" + sClassname + "'");
            }
        }
    }

    synchronized JspcPageBase createInstance() {
        JspcPageBase retPage = null;
        if (JspcControl._bDoDynamicReload) {
            boolean bNeedsRebuild = true;
            if (this.m_dynClass != null) {
                bNeedsRebuild = this.m_dynClass.needsRebuild();
                if (!JspcControl._bAlwaysCompile || !bNeedsRebuild) {
                    // empty if block
                }
                if (JspcControl._bAlwaysCompile) {
                    bNeedsRebuild = true;
                }
            }
            if (bNeedsRebuild) {
                DynClass dcNew;
                this.m_dynClass = dcNew = JspcControl._jspcClassGenerator.buildDynClass(this.m_sJspcClassname, this.m_dynClass);
            }
            try {
                retPage = (JspcPageBase)this.m_dynClass.newInstance();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not create instance of dynamically compiled '" + this.m_sJspcClassname + "'", ex);
            }
        }
        try {
            retPage = (JspcPageBase)this.m_class.newInstance();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not create instance of '" + this.m_sJspcClassname + "'", ex);
        }
        return retPage;
    }
}

