/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.jspc;

import com.cognos.dispatcherJSP.jspc.JSPCException;
import com.cognos.dispatcherJSP.jspc.JspcIncludeResponseWrapper;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;

public class JspcRuntimeLibrary {
    public static Object convert(String propertyName, String s, Class t, Class propertyEditorClass) throws JSPCException {
        try {
            if (s == null) {
                if (t.equals(Boolean.class) || t.equals(Boolean.TYPE)) {
                    s = "false";
                } else {
                    return null;
                }
            }
            if (propertyEditorClass != null) {
                return JspcRuntimeLibrary.getValueFromBeanInfoPropertyEditor(t, propertyName, s, propertyEditorClass);
            }
            if (t.equals(Boolean.class) || t.equals(Boolean.TYPE)) {
                s = s.equalsIgnoreCase("on") || s.equalsIgnoreCase("true") ? "true" : "false";
                return new Boolean(s);
            }
            if (t.equals(Byte.class) || t.equals(Byte.TYPE)) {
                return new Byte(s);
            }
            if (t.equals(Character.class) || t.equals(Character.TYPE)) {
                return s.length() > 0 ? new Character(s.charAt(0)) : null;
            }
            if (t.equals(Short.class) || t.equals(Short.TYPE)) {
                return new Short(s);
            }
            if (t.equals(Integer.class) || t.equals(Integer.TYPE)) {
                return new Integer(s);
            }
            if (t.equals(Float.class) || t.equals(Float.TYPE)) {
                return new Float(s);
            }
            if (t.equals(Long.class) || t.equals(Long.TYPE)) {
                return new Long(s);
            }
            if (t.equals(Double.class) || t.equals(Double.TYPE)) {
                return new Double(s);
            }
            if (t.equals(String.class)) {
                return s;
            }
            if (t.equals(File.class)) {
                return new File(s);
            }
            if (t.getName().equals("java.lang.Object")) {
                return new Object[]{s};
            }
            return JspcRuntimeLibrary.getValueFromPropertyEditorManager(t, propertyName, s);
        }
        catch (Exception ex) {
            throw new JSPCException(ex.toString());
        }
    }

    public static void introspect(Object bean, ServletRequest request) throws JSPCException {
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = request.getParameter(name);
            JspcRuntimeLibrary.introspecthelper(bean, name, value, request, name, true);
        }
    }

    public static void introspecthelper(Object bean, String prop, String value, ServletRequest request, String param, boolean ignoreMethodNF) throws JSPCException {
        if (System.getSecurityManager() != null) {
            try {
                PrivilegedIntrospectHelper dp = new PrivilegedIntrospectHelper(bean, prop, value, request, param, ignoreMethodNF);
                AccessController.doPrivileged(dp);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                throw (JSPCException)((Object)e);
            }
        } else {
            JspcRuntimeLibrary.internalIntrospecthelper(bean, prop, value, request, param, ignoreMethodNF);
        }
    }

    private static void internalIntrospecthelper(Object bean, String prop, String value, ServletRequest request, String param, boolean ignoreMethodNF) throws JSPCException {
        Method method = null;
        Class<?> type = null;
        Class<?> propertyEditorClass = null;
        try {
            BeanInfo info = Introspector.getBeanInfo(bean.getClass());
            if (info != null) {
                PropertyDescriptor[] pd = info.getPropertyDescriptors();
                for (int i = 0; i < pd.length; ++i) {
                    if (!pd[i].getName().equals(prop)) continue;
                    method = pd[i].getWriteMethod();
                    type = pd[i].getPropertyType();
                    propertyEditorClass = pd[i].getPropertyEditorClass();
                    break;
                }
            }
            if (method != null) {
                if (type.isArray()) {
                    if (request == null) {
                        throw new JSPCException("jsp.error.beans.setproperty.noindexset");
                    }
                    Class<?> t = type.getComponentType();
                    String[] values = request.getParameterValues(param);
                    if (values == null) {
                        return;
                    }
                    if (t.equals(String.class)) {
                        method.invoke(bean, new Object[]{values});
                    } else {
                        JspcRuntimeLibrary.createTypedArray(prop, bean, method, values, t, propertyEditorClass);
                    }
                } else {
                    if (value == null || param != null && value.equals("")) {
                        return;
                    }
                    Object oval = JspcRuntimeLibrary.convert(prop, value, type, propertyEditorClass);
                    if (oval != null) {
                        method.invoke(bean, oval);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new JSPCException(ex.toString());
        }
        if (!ignoreMethodNF && method == null) {
            if (type == null) {
                throw new JSPCException("jsp.error.beans.noproperty");
            }
            throw new JSPCException("jsp.error.beans.nomethod.setproperty");
        }
    }

    public static String toString(Object o) {
        return o == null ? "" : o.toString();
    }

    public static String toString(byte b) {
        return new Byte(b).toString();
    }

    public static String toString(boolean b) {
        return new Boolean(b).toString();
    }

    public static String toString(short s) {
        return new Short(s).toString();
    }

    public static String toString(int i) {
        return new Integer(i).toString();
    }

    public static String toString(float f) {
        return new Float(f).toString();
    }

    public static String toString(long l) {
        return new Long(l).toString();
    }

    public static String toString(double d) {
        return new Double(d).toString();
    }

    public static String toString(char c) {
        return new Character(c).toString();
    }

    public static void createTypedArray(String propertyName, Object bean, Method method, String[] values, Class t, Class propertyEditorClass) throws JSPCException {
        try {
            if (propertyEditorClass != null) {
                Integer[] tmpval = new Integer[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = JspcRuntimeLibrary.getValueFromBeanInfoPropertyEditor(t, propertyName, values[i], propertyEditorClass);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Integer.class)) {
                Integer[] tmpval = new Integer[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = new Integer(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Byte.class)) {
                Byte[] tmpval = new Byte[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = new Byte(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Boolean.class)) {
                Boolean[] tmpval = new Boolean[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = new Boolean(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Short.class)) {
                Short[] tmpval = new Short[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = new Short(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Long.class)) {
                Long[] tmpval = new Long[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = new Long(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Double.class)) {
                Double[] tmpval = new Double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = new Double(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Float.class)) {
                Float[] tmpval = new Float[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = new Float(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Character.class)) {
                Character[] tmpval = new Character[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = new Character(values[i].charAt(0));
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Integer.TYPE)) {
                int[] tmpval = new int[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = Integer.parseInt(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Byte.TYPE)) {
                byte[] tmpval = new byte[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = Byte.parseByte(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Boolean.TYPE)) {
                boolean[] tmpval = new boolean[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = Boolean.valueOf(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Short.TYPE)) {
                short[] tmpval = new short[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = Short.parseShort(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Long.TYPE)) {
                long[] tmpval = new long[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = Long.parseLong(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Double.TYPE)) {
                double[] tmpval = new double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = Double.valueOf(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Float.TYPE)) {
                float[] tmpval = new float[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = Float.valueOf(values[i]).floatValue();
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Character.TYPE)) {
                char[] tmpval = new char[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = values[i].charAt(0);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else {
                Integer[] tmpval = new Integer[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = JspcRuntimeLibrary.getValueFromPropertyEditorManager(t, propertyName, values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            }
        }
        catch (Exception ex) {
            throw new JSPCException("error in invoking method");
        }
    }

    public static String escapeQueryString(String unescString) {
        if (unescString == null) {
            return null;
        }
        String escString = "";
        String shellSpChars = "&;`'\"|*?~<>^()[]{}$\\\n";
        for (int index = 0; index < unescString.length(); ++index) {
            char nextChar = unescString.charAt(index);
            if (shellSpChars.indexOf(nextChar) != -1) {
                escString = escString + "\\";
            }
            escString = escString + nextChar;
        }
        return escString;
    }

    public static String decode(String encoded) {
        if (encoded == null) {
            return null;
        }
        if (encoded.indexOf(37) == -1 && encoded.indexOf(43) == -1) {
            return encoded;
        }
        byte[] holdbuffer = new byte[encoded.length()];
        int bufcount = 0;
        for (int count = 0; count < encoded.length(); ++count) {
            char cur = encoded.charAt(count);
            if (cur == '%') {
                holdbuffer[bufcount++] = (byte)Integer.parseInt(encoded.substring(count + 1, count + 3), 16);
                if (count + 2 >= encoded.length()) {
                    count = encoded.length();
                    continue;
                }
                count += 2;
                continue;
            }
            holdbuffer[bufcount++] = cur == '+' ? 32 : (byte)cur;
        }
        return new String(holdbuffer, 0, bufcount);
    }

    public static Object handleGetProperty(Object o, String prop) throws JSPCException {
        if (o == null) {
            throw new JSPCException("jsp.error.beans.nullbean");
        }
        Object value = null;
        try {
            Method method = JspcRuntimeLibrary.getReadMethod(o.getClass(), prop);
            value = method.invoke(o, new Object[0]);
        }
        catch (Exception ex) {
            throw new JSPCException(ex.toString());
        }
        return value;
    }

    public static void handleSetProperty(Object bean, String prop, Object value) throws JSPCException {
        try {
            Method method = JspcRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, value);
        }
        catch (Exception ex) {
            throw new JSPCException(ex.toString());
        }
    }

    public static void handleSetProperty(Object bean, String prop, int value) throws JSPCException {
        try {
            Method method = JspcRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, new Integer(value));
        }
        catch (Exception ex) {
            throw new JSPCException(ex.toString());
        }
    }

    public static void handleSetProperty(Object bean, String prop, short value) throws JSPCException {
        try {
            Method method = JspcRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, new Short(value));
        }
        catch (Exception ex) {
            throw new JSPCException(ex.toString());
        }
    }

    public static void handleSetProperty(Object bean, String prop, long value) throws JSPCException {
        try {
            Method method = JspcRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, new Long(value));
        }
        catch (Exception ex) {
            throw new JSPCException(ex.toString());
        }
    }

    public static void handleSetProperty(Object bean, String prop, double value) throws JSPCException {
        try {
            Method method = JspcRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, new Double(value));
        }
        catch (Exception ex) {
            throw new JSPCException(ex.toString());
        }
    }

    public static void handleSetProperty(Object bean, String prop, float value) throws JSPCException {
        try {
            Method method = JspcRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, new Float(value));
        }
        catch (Exception ex) {
            throw new JSPCException(ex.toString());
        }
    }

    public static void handleSetProperty(Object bean, String prop, char value) throws JSPCException {
        try {
            Method method = JspcRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, new Character(value));
        }
        catch (Exception ex) {
            throw new JSPCException(ex.toString());
        }
    }

    public static void handleSetProperty(Object bean, String prop, byte value) throws JSPCException {
        try {
            Method method = JspcRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, new Byte(value));
        }
        catch (Exception ex) {
            throw new JSPCException(ex.toString());
        }
    }

    public static void handleSetProperty(Object bean, String prop, boolean value) throws JSPCException {
        try {
            Method method = JspcRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, new Boolean(value));
        }
        catch (Exception ex) {
            throw new JSPCException(ex.toString());
        }
    }

    public static Method getWriteMethod(Class beanClass, String prop) throws JSPCException {
        Class<?> type;
        Method method;
        block6: {
            method = null;
            type = null;
            try {
                BeanInfo info = Introspector.getBeanInfo(beanClass);
                if (info != null) {
                    PropertyDescriptor[] pd = info.getPropertyDescriptors();
                    for (int i = 0; i < pd.length; ++i) {
                        if (!pd[i].getName().equals(prop)) continue;
                        method = pd[i].getWriteMethod();
                        type = pd[i].getPropertyType();
                        break block6;
                    }
                    break block6;
                }
                throw new JSPCException("jsp.error.beans.nobeaninfo");
            }
            catch (Exception ex) {
                throw new JSPCException(ex.toString());
            }
        }
        if (method == null) {
            if (type == null) {
                throw new JSPCException("jsp.error.beans.noproperty");
            }
            throw new JSPCException("jsp.error.beans.nomethod.setproperty");
        }
        return method;
    }

    public static Method getReadMethod(Class beanClass, String prop) throws JSPCException {
        Class<?> type;
        Method method;
        block6: {
            method = null;
            type = null;
            try {
                BeanInfo info = Introspector.getBeanInfo(beanClass);
                if (info != null) {
                    PropertyDescriptor[] pd = info.getPropertyDescriptors();
                    for (int i = 0; i < pd.length; ++i) {
                        if (!pd[i].getName().equals(prop)) continue;
                        method = pd[i].getReadMethod();
                        type = pd[i].getPropertyType();
                        break block6;
                    }
                    break block6;
                }
                throw new JSPCException("jsp.error.beans.nobeaninfo");
            }
            catch (Exception ex) {
                throw new JSPCException(ex.toString());
            }
        }
        if (method == null) {
            if (type == null) {
                throw new JSPCException("jsp.error.beans.noproperty");
            }
            throw new JSPCException("jsp.error.beans.nomethod");
        }
        return method;
    }

    public static Object getValueFromBeanInfoPropertyEditor(Class attrClass, String attrName, String attrValue, Class propertyEditorClass) throws JSPCException {
        try {
            PropertyEditor pe = (PropertyEditor)propertyEditorClass.newInstance();
            pe.setAsText(attrValue);
            return pe.getValue();
        }
        catch (Exception ex) {
            throw new JSPCException("Unable to convert string '" + attrValue + "' to class " + attrClass.getName() + " for attribute " + attrName + ": " + ex);
        }
    }

    public static Object getValueFromPropertyEditorManager(Class attrClass, String attrName, String attrValue) throws JSPCException {
        try {
            PropertyEditor propEditor = PropertyEditorManager.findEditor(attrClass);
            if (propEditor != null) {
                propEditor.setAsText(attrValue);
                return propEditor.getValue();
            }
            throw new IllegalArgumentException("Property Editor not registered with the PropertyEditorManager");
        }
        catch (IllegalArgumentException ex) {
            throw new JSPCException("Unable to convert string '" + attrValue + "' to class " + attrClass.getName() + " for attribute " + attrName + ": " + ex);
        }
    }

    public static String getContextRelativePath(ServletRequest request, String relativePath) {
        if (relativePath.startsWith("/")) {
            return relativePath;
        }
        if (!(request instanceof HttpServletRequest)) {
            return relativePath;
        }
        HttpServletRequest hrequest = (HttpServletRequest)request;
        String uri = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (uri == null) {
            uri = hrequest.getServletPath();
        }
        return uri.substring(0, uri.lastIndexOf(47)) + '/' + relativePath;
    }

    public static void include(HttpServletRequest request, HttpServletResponse response, String relativePath, JspWriter out, boolean flush) throws IOException, ServletException {
        if (flush && !(out instanceof BodyContent)) {
            out.flush();
        }
        RequestDispatcher rd = request.getRequestDispatcher(relativePath);
        rd.include((ServletRequest)request, (ServletResponse)new JspcIncludeResponseWrapper((ServletResponse)response, out));
    }

    protected static class PrivilegedIntrospectHelper
    implements PrivilegedExceptionAction {
        private Object bean;
        private String prop;
        private String value;
        private ServletRequest request;
        private String param;
        private boolean ignoreMethodNF;

        PrivilegedIntrospectHelper(Object bean, String prop, String value, ServletRequest request, String param, boolean ignoreMethodNF) {
            this.bean = bean;
            this.prop = prop;
            this.value = value;
            this.request = request;
            this.param = param;
            this.ignoreMethodNF = ignoreMethodNF;
        }

        public Object run() throws JSPCException {
            JspcRuntimeLibrary.internalIntrospecthelper(this.bean, this.prop, this.value, this.request, this.param, this.ignoreMethodNF);
            return null;
        }
    }
}

