/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.jspc;

import com.cognos.ccl4j.diagnostics.CCLCheck;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspWriter;

public final class JspcWriterImpl
extends JspWriter {
    private Writer _outWriter = null;
    private ServletResponse _response = null;
    private boolean _closed = false;
    static final String lineSeparator = System.getProperty("line.separator");

    public JspcWriterImpl(ServletResponse response, int nBufferSize, boolean autoFlush) {
        super(nBufferSize, autoFlush);
        this._response = response;
        response.setBufferSize(nBufferSize);
    }

    void init(ServletResponse response, int sz, boolean autoFlush) {
        this._response = response;
    }

    void recycle() {
        this._closed = false;
        this._outWriter = null;
    }

    public void initializeOutput() throws IOException {
        if (this._outWriter == null) {
            this._outWriter = this._response.getWriter();
        }
    }

    public final void clear() throws IOException {
        if (this._response != null && this._response.isCommitted()) {
            throw new IllegalStateException("Cannot clear response has already been commited");
        }
        this.clearBuffer();
    }

    public void clearBuffer() throws IOException {
        if (this._response != null && !this._response.isCommitted()) {
            this._response.reset();
        }
    }

    public void flush() throws IOException {
        if (this._outWriter != null) {
            this._outWriter.flush();
        }
    }

    public void close() throws IOException {
        if (this._response == null || this._closed) {
            return;
        }
        if (this._outWriter != null) {
            this._outWriter.close();
        }
        this._closed = true;
    }

    public int getRemaining() {
        return 0;
    }

    public void write(int c) throws IOException {
        CCLCheck.throwUnsupported();
        this._outWriter.write(c);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this._outWriter.write(cbuf, off, len);
    }

    public void write(char[] buf) throws IOException {
        this.initializeOutput();
        this._outWriter.write(buf, 0, buf.length);
    }

    public void write(String s, int off, int len) throws IOException {
        this.initializeOutput();
        this._outWriter.write(s, off, len);
    }

    public void write(String s) throws IOException {
        this.initializeOutput();
        this._outWriter.write(s, 0, s.length());
    }

    public void newLine() throws IOException {
        this.write(lineSeparator);
    }

    public void print(boolean b) throws IOException {
        this.write(b ? "true" : "false");
    }

    public void print(char c) throws IOException {
        String s = String.valueOf(c);
        this.write(s);
    }

    public void print(int i) throws IOException {
        String s = String.valueOf(i);
        this.write(s);
    }

    public void print(long l) throws IOException {
        String s = String.valueOf(l);
        this.write(s);
    }

    public void print(float f) throws IOException {
        String s = String.valueOf(f);
        this.write(s);
    }

    public void print(double d) throws IOException {
        String s = String.valueOf(d);
        this.write(s);
    }

    public void print(char[] s) throws IOException {
        this.write(s);
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    public void print(Object obj) throws IOException {
        String s = String.valueOf(obj);
        this.write(s);
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(char x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(int x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(long x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(float x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(double x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(char[] x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(String x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(Object x) throws IOException {
        this.print(x);
        this.println();
    }
}

