/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.logging;

import com.cognos.dispatcherJSP.util.WebUtil;
import com.cognos.indications.LogTypedLogger;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Level;
import org.dom4j.Element;

public class LogControl {
    private static String CATEGORY_MESSAGECONTEXTLOGGER = "Trace.DISPATCHERJSP.MESSAGE_CONTEXT";
    private static String CATEGORY_SERVLETREQUESTLOGGER = "Trace.DISPATCHERJSP.REQUEST_RESPONSE";
    private static String CATEGORY_READBUFFER_RESPONSE = "Trace.DISPATCHERJSP.BUFFERIORESPONSE";
    private static String CATEGORY_EXCEPTIONS = "Trace.DISPATCHERJSP.EXCEPTIONS";
    private static String CATEGORY_REQUEST_EXECUTION = "Trace.DISPATCHERJSP.REQUESTEXECUTION";
    private LogTypedLogger m_messageContextLogger = LogTypedLogger.getLogger((String)CATEGORY_MESSAGECONTEXTLOGGER);
    private LogTypedLogger m_servletRequestLogger = LogTypedLogger.getLogger((String)CATEGORY_SERVLETREQUESTLOGGER);
    private LogTypedLogger m_responseBufferLogger = LogTypedLogger.getLogger((String)CATEGORY_READBUFFER_RESPONSE);
    private LogTypedLogger m_exceptionsLogger = LogTypedLogger.getLogger((String)CATEGORY_EXCEPTIONS);
    private LogTypedLogger m_requestExecutionLogger = LogTypedLogger.getLogger((String)CATEGORY_REQUEST_EXECUTION);
    private static LogControl S_LOG_CONTROL = null;

    public static LogControl getInstance() {
        if (S_LOG_CONTROL == null) {
            S_LOG_CONTROL = new LogControl();
        }
        return S_LOG_CONTROL;
    }

    private LogControl() {
    }

    public final void logMessageContext(MessageContext context) {
        if (this.m_messageContextLogger.isEnabledFor(Level.INFO)) {
            BIBusEnvelope requestEnvelope = (BIBusEnvelope)context.getProperty("request.envelope");
            Element envelope = requestEnvelope.getEnvelope();
            this.m_messageContextLogger.log(Level.INFO, envelope.asXML());
        }
    }

    public final void logHttpServletRequest(HttpServletRequest request) {
        if (this.m_servletRequestLogger.isEnabledFor(Level.INFO)) {
            String repr = WebUtil.requestToString(request);
            this.m_servletRequestLogger.log(Level.INFO, repr);
        }
    }

    public final void logResponseBufferRead(byte[] buffer, int startIndex, int length) {
        if (this.m_responseBufferLogger.isEnabledFor(Level.INFO)) {
            String str = new String(buffer, startIndex, length);
            this.m_responseBufferLogger.log(Level.INFO, str);
        }
    }

    public final void logException(Throwable th) {
        if (this.m_exceptionsLogger.isEnabledFor(Level.INFO)) {
            StringBuffer st = new StringBuffer(1024);
            while (th != null) {
                st.append(th.getMessage());
                st.append("\n");
                StackTraceElement[] stack = th.getStackTrace();
                for (int i = 0; i < stack.length; ++i) {
                    st.append(stack[i].toString());
                    st.append("\n");
                }
                th = th.getCause();
            }
            this.m_exceptionsLogger.log(Level.INFO, st.toString());
        }
    }
}

