/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.pagemap.manager;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.dispatcherJSP.pagemap.manager.MasterPageMap;
import com.cognos.dispatcherJSP.pagemap.meta.tags.PageMeta;
import com.cognos.dispatcherJSP.view.views.JSPView;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractPageObjectManager {
    public static final String LOGID = "manager";
    protected MasterPageMap m_masterPageMap = null;
    private HashMap m_pageObjectMap = null;
    private boolean m_dynamicPageMapReload = false;
    private boolean m_loaded = false;

    public AbstractPageObjectManager(MasterPageMap masterPageMap, boolean dynamicPageMapReload) {
        if (masterPageMap == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        this.m_masterPageMap = masterPageMap;
        this.m_dynamicPageMapReload = dynamicPageMapReload;
    }

    public void load() {
        try {
            this.loadFromPageMaps();
        }
        catch (Exception e) {
            throw new CCLRuntimeException((Throwable)e, "Exception initializing  manager.");
        }
    }

    private void loadFromPageMaps() throws ClassNotFoundException {
        HashMap pageHashMap = this.m_masterPageMap.getPageHashMap();
        this.m_pageObjectMap = new HashMap(this.getObjectCount());
        if (!this.m_dynamicPageMapReload) {
            if (this.m_loaded) {
                throw new CCLRuntimeException("The manager has already been loaded.");
            }
            Set keys = pageHashMap.keySet();
            Iterator iterPages = keys.iterator();
            String pid = null;
            while (iterPages.hasNext()) {
                pid = (String)iterPages.next();
                this.createObject(pid);
            }
            this.m_loaded = true;
        }
    }

    protected abstract Object createInstance(PageMeta var1) throws ClassNotFoundException;

    protected abstract int getObjectCount();

    protected Object getPageObject(String pid) {
        if (pid == null) {
            return null;
        }
        Object object = this.m_pageObjectMap.get(pid);
        if (this.m_dynamicPageMapReload && object == null) {
            object = this.createObject(pid);
        }
        if (object == null) {
            this.getPageMeta(pid);
        }
        return (JSPView)object;
    }

    protected PageMeta getPageMeta(String pid) {
        if (pid == null) {
            return null;
        }
        PageMeta pageMeta = this.m_masterPageMap.getPageMeta(pid);
        if (pageMeta == null) {
            throw new CCLRuntimeException("The specified page, '" + pid + "', could not be found in any of the page maps referenced by master page map '" + this.m_masterPageMap.getDocumentPath() + "'");
        }
        return pageMeta;
    }

    private Object createObject(String pid) {
        PageMeta pageMeta = this.getPageMeta(pid);
        if (pageMeta == null) {
            return null;
        }
        Object instance = null;
        try {
            instance = this.createInstance(pageMeta);
        }
        catch (Exception ex) {
            throw new CCLRuntimeException((Throwable)ex, "Exception creating view instance for pid " + pid);
        }
        this.m_pageObjectMap.put(pid, instance);
        return instance;
    }

    public boolean reloadIfNecessary() {
        boolean reloaded = false;
        try {
            reloaded = this.m_masterPageMap.reloadIfNecessary();
        }
        catch (Exception e) {
            throw new CCLRuntimeException((Throwable)e, "reloading pageMaps");
        }
        if (reloaded) {
            this.forceReload();
        }
        return reloaded;
    }

    public final void forceReload() {
        this.clear();
    }

    public void clear() {
        if (this.m_pageObjectMap != null) {
            this.m_pageObjectMap.clear();
        }
        this.m_pageObjectMap = new HashMap(this.getObjectCount());
    }

    public final MasterPageMap getMasterPageMap() {
        return this.m_masterPageMap;
    }
}

