/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.pagemap.manager;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.dispatcherJSP.pagemap.manager.PageMap;
import com.cognos.dispatcherJSP.pagemap.meta.tags.PageMeta;
import com.cognos.dispatcherJSP.util.BaseXMLDocument;
import com.cognos.dispatcherJSP.util.Maps;
import com.cognos.dispatcherJSP.util.SystemUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class MasterPageMap
extends BaseXMLDocument {
    public static final String PAGEMAP_FOLDER_NM = "pagemap";
    private PageMaps _pageMaps = null;
    protected boolean _isOldServletAPI = false;

    public MasterPageMap(String sourceFilePath, boolean isOldServletAPI, String jpfBasePath) throws FileNotFoundException, DocumentException, ClassNotFoundException, IOException {
        super(sourceFilePath);
        String pagemapsLocation = null;
        File file = new File(sourceFilePath);
        pagemapsLocation = file.getParent();
        this._isOldServletAPI = isOldServletAPI;
        try {
            Element pageMapsElem = null;
            try {
                pageMapsElem = this.getChild("pageMaps");
                if (pageMapsElem == null) {
                    throw new IllegalArgumentException("The XML document, '" + sourceFilePath + "' is missing the <" + "pageMaps" + "> tag.");
                }
            }
            catch (Exception e) {
                throw new CCLRuntimeException((Throwable)e, "loading the <pageMaps> tag");
            }
            try {
                this._pageMaps = new PageMaps(pageMapsElem, null, pagemapsLocation, jpfBasePath);
            }
            catch (Exception e) {
                throw new CCLRuntimeException((Throwable)e, "creating PageMaps");
            }
        }
        catch (Exception ex) {
            throw new CCLRuntimeException((Throwable)ex, "loading MasterPageMap file '" + sourceFilePath + "'");
        }
    }

    public String[] getAllPageIDs() {
        return this._pageMaps.getAllPageIDs();
    }

    public String[] getAllViews() {
        return this._pageMaps.getAllViews();
    }

    public HashMap getPageHashMap() {
        return this._pageMaps.getPageHashMap();
    }

    public int getViewCount() {
        return this._pageMaps.getViewCount();
    }

    public boolean reloadIfNecessary() throws FileNotFoundException, DocumentException, ClassNotFoundException {
        return this._pageMaps.reloadIfNecessary();
    }

    public final PageMeta getPageMeta(String pid) {
        return this._pageMaps.getPageMeta(pid);
    }

    public final boolean exists(String pid) {
        return this._pageMaps.exists(pid);
    }

    protected class PageMaps {
        protected static final String TAG_NAME = "pageMaps";
        private static final String ATTR_PAGEMAP_PATH = "relativePath";
        private static final String ATTR_IS_JAF_LOCATION = "isJafLocation";
        private PageMap[] _pageMapArray = null;
        private HashMap _pageMapHashMap = null;
        private HashMap _allPagesMap = null;
        private HashMap _allViews = null;
        private Exception _loadException = null;

        public PageMaps(Element pageMapsElem, Object loadParameter, String pagemapsLocation, String jpfBasePath) throws FileNotFoundException, DocumentException, ClassNotFoundException {
            this.loadFromElement(pageMapsElem, loadParameter, pagemapsLocation, jpfBasePath);
        }

        protected void loadFromElement(Element pageMapsElem, Object loadParameter, String pagemapsLocation, String jpfBasePath) throws FileNotFoundException, DocumentException, ClassNotFoundException {
            if (pageMapsElem == null || pagemapsLocation == null) {
                throw new IllegalArgumentException("Missing required parameter.");
            }
            if (!pageMapsElem.getName().equalsIgnoreCase(TAG_NAME)) {
                throw new IllegalArgumentException("Expecting an element representing a <pageMaps> tag.");
            }
            try {
                int index = 0;
                Element pageMapElem = null;
                PageMap pageMap = null;
                String pageMapPath = null;
                String name = null;
                List pageMapList = pageMapsElem.elements("pageMap");
                Iterator iter = pageMapList.iterator();
                int pageMapCount = pageMapList.size();
                this._pageMapArray = new PageMap[pageMapCount];
                this._pageMapHashMap = new HashMap(pageMapCount);
                while (iter.hasNext()) {
                    try {
                        Object isJAFLocation = null;
                        String fileLocation = null;
                        pageMapElem = (Element)iter.next();
                        pageMapPath = pageMapElem.attributeValue(ATTR_PAGEMAP_PATH);
                        if (pageMapPath == null || pageMapPath.trim().length() == 0) {
                            throw new IllegalArgumentException("The <pageMaps> tag is missing a valid 'relativePath' attribute.");
                        }
                        fileLocation = pagemapsLocation + SystemUtil.FILE_SEPARATOR + pageMapPath;
                        pageMap = new PageMap(fileLocation, MasterPageMap.this._isOldServletAPI);
                        name = pageMap.name();
                        if (this._pageMapHashMap.containsKey(name)) {
                            throw new CCLRuntimeException("Attempting to load two PageMap's with the same name (" + name + ") occurred at PageMap number " + (index + 1));
                        }
                        this._pageMapHashMap.put(name, pageMap);
                        this._pageMapArray[index++] = pageMap;
                    }
                    catch (Exception ex) {
                        throw new CCLRuntimeException((Throwable)ex, "loading PageMap number " + (index + 1));
                    }
                }
                if (index == 0) {
                    throw new IllegalArgumentException("missing the <pageMap> tags under the <pageMaps> tag.");
                }
                this.load(false);
            }
            catch (Exception ex) {
                throw new CCLRuntimeException((Throwable)ex, "loading PageMaps");
            }
        }

        public HashMap getPageHashMap() {
            if (this._loadException != null) {
                throw new CCLRuntimeException((Throwable)this._loadException, "This MasterPageMap references a pageMap that has errors");
            }
            if (this._allPagesMap == null) {
                throw new IllegalStateException("This MasterPageMap has errors, is corrupt, or else references pageMaps that together define no pages.");
            }
            return this._allPagesMap;
        }

        public String[] getAllPageIDs() {
            if (this._loadException != null) {
                throw new CCLRuntimeException((Throwable)this._loadException, "This MasterPageMap references a pageMap that has errors");
            }
            if (this._allPagesMap == null) {
                throw new IllegalStateException("This MasterPageMap has errors, is corrupt, or else references pageMaps that together define no pages.");
            }
            return Maps.mapKeysToStringArray(this._allPagesMap);
        }

        public String[] getAllViews() {
            if (this._loadException != null) {
                throw new CCLRuntimeException((Throwable)this._loadException, "This MasterPageMap references a pageMap that has errors");
            }
            if (this._allPagesMap == null) {
                throw new IllegalStateException("This MasterPageMap has errors, is corrupt, or else references pageMaps that together define no pages.");
            }
            return Maps.mapKeysToStringArray(this._allViews);
        }

        public PageMeta getPageMeta(String pid) {
            if (this._loadException != null) {
                throw new CCLRuntimeException((Throwable)this._loadException, "This MasterPageMap references a pageMap that has errors");
            }
            if (this._allPagesMap == null) {
                throw new IllegalStateException("This MasterPageMap has errors, is corrupt, or else references pageMaps that together define no pages.");
            }
            return (PageMeta)this._allPagesMap.get(pid);
        }

        protected PageMap getPageMap(String pid) {
            PageMeta pageMeta = null;
            PageMap pageMap2 = null;
            for (PageMap pageMap2 : this._pageMapArray) {
                try {
                    pageMeta = pageMap2.getPageMeta(pid);
                    if (pageMeta == null) continue;
                    break;
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            if (pageMeta == null) {
                return null;
            }
            return pageMap2;
        }

        public boolean exists(String pid) {
            if (pid == null) {
                return false;
            }
            return this.getPageMeta(pid) != null;
        }

        public int getPageCount() {
            int pageCount = 0;
            PageMap pageMap2 = null;
            for (PageMap pageMap2 : this._pageMapArray) {
                pageCount += pageMap2.getPageCount();
            }
            return pageCount;
        }

        public int getViewCount() {
            int viewCount = 0;
            PageMap pageMap2 = null;
            for (PageMap pageMap2 : this._pageMapArray) {
                viewCount += pageMap2.getViewCount();
            }
            return viewCount;
        }

        public boolean reloadIfNecessary() throws FileNotFoundException, DocumentException, ClassNotFoundException {
            boolean oneChanged = false;
            PageMap pageMap = null;
            int len = this._pageMapArray.length;
            for (int i = 0; i < len && !(oneChanged = (pageMap = this._pageMapArray[i]).sourceFileNewerThenPageMap()); ++i) {
            }
            if (oneChanged) {
                this.load(true);
            }
            return oneChanged;
        }

        private void load(boolean reloadFromFile) throws FileNotFoundException, DocumentException, ClassNotFoundException {
            PageMap pageMap = null;
            int pageCount = this._pageMapArray.length;
            String originalPath = null;
            String originalName = null;
            String name = null;
            this._loadException = null;
            if (this._allPagesMap != null) {
                this._allPagesMap.clear();
            }
            try {
                int i;
                for (i = 0; i < pageCount; ++i) {
                    pageMap = this._pageMapArray[i];
                    if (!reloadFromFile) continue;
                    originalName = pageMap.name();
                    originalPath = pageMap.getDocumentPath();
                    pageMap = pageMap.copy();
                    name = pageMap.name();
                    if (originalName == null || name == null || !originalName.equals(name)) {
                        throw new CCLRuntimeException("Attempting to dynamically rename PageMap (" + originalPath + ") from (" + originalName + ") to (" + name + "). You will need to restart the server to do this.");
                    }
                    this._pageMapArray[i] = pageMap;
                }
                for (i = 0; i < pageCount; ++i) {
                    pageMap = this._pageMapArray[i];
                    pageMap.loadPages();
                }
                this.mapPageMaps();
            }
            catch (Exception e) {
                this._loadException = e;
                throw new CCLRuntimeException((Throwable)e, "Attempting to load pageMaps");
            }
        }

        private void mapPageMaps() {
            if (this._allPagesMap != null) {
                this._allPagesMap.clear();
                this._allViews.clear();
            }
            this._allPagesMap = new HashMap(this.getPageCount());
            this._allViews = new HashMap(this.getPageCount());
            Object pageMap = null;
            int len = this._pageMapArray.length;
            for (int i = 0; i < len; ++i) {
                this.mapPageMap(this._pageMapArray[i]);
            }
        }

        private void mapPageMap(PageMap pageMap) {
            HashMap pageHashMap;
            if (this._allPagesMap == null) {
                this._allPagesMap = new HashMap(this.getPageCount());
                this._allViews = new HashMap(this.getViewCount());
            }
            if ((pageHashMap = pageMap.getPageHashMap()) == null) {
                return;
            }
            Set keys = pageHashMap.keySet();
            Iterator iter = keys.iterator();
            String pid = null;
            int i = 0;
            while (iter.hasNext()) {
                pid = (String)iter.next();
                if (pid != null) {
                    if (this._allPagesMap.containsKey(pid)) {
                        PageMap existingPageMap = null;
                        String existingPageMapPath = "Unknown";
                        try {
                            existingPageMap = this.getPageMap(pid);
                            existingPageMapPath = existingPageMap.getDocumentPath();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw new CCLRuntimeException("Attempting to define page (" + pid + ") in pageMap (" + pageMap.getDocumentPath() + ") when that page is already defined in PageMap (" + existingPageMapPath + ")");
                    }
                    if (pageMap.getPageMeta(pid).getViewMeta() != null && pageMap.getPageMeta(pid).getViewMeta().getClassName() != null) {
                        this._allViews.put(pageMap.getPageMeta(pid).getViewMeta().getClassName(), String.valueOf(i));
                    }
                    this._allPagesMap.put(pid, pageMap.getPageMeta(pid));
                }
                ++i;
            }
        }
    }
}

