/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.pagemap.manager;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.dispatcherJSP.pagemap.meta.tags.PageMeta;
import com.cognos.dispatcherJSP.pagemap.meta.tags.PagesMeta;
import com.cognos.dispatcherJSP.util.BaseXMLDocument;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class PageMap
extends BaseXMLDocument {
    public static final String TAG_NAME = "pageMap";
    public static final String ATTR_PAGEMAP_NAME = "name";
    public static final String LOCAL_PARAMETER_LIST_META = "__LocalParameterListMeta__";
    public static final String PARAM_VALUE_Y = "y";
    public static final String PARAM_VALUE_YES = "yes";
    public static final String PARAM_VALUE_N = "n";
    public static final String PARAM_VALUE_NO = "no";
    public static final int VALUE_NOT_SET = -1;
    public static final int VALUE_NO = 0;
    public static final int VALUE_YES = 1;
    protected boolean _triedToLoadParmLists = false;
    protected PagesMeta _pagesMeta = null;
    protected int _viewCount = 0;
    protected int _pageCount = 0;
    private File _pageMapFile = null;
    private String _name = null;
    private long _pagesLoadedTime = 0L;

    public PageMap(String documentPath, boolean isOldServletAPI) throws FileNotFoundException, DocumentException, IOException {
        super(documentPath);
        this._pageMapFile = new File(documentPath);
        Element rootElem = this.getDocumentRoot();
        if (rootElem == null) {
            throw new CCLRuntimeException("The <pageMap> tag is missing in PageMap (" + documentPath + ")");
        }
        String name = rootElem.getName();
        if (name == null || !name.equalsIgnoreCase(TAG_NAME)) {
            throw new CCLRuntimeException("The <pageMap> tag is missing in PageMap (" + documentPath + ")");
        }
        this._name = rootElem.attributeValue(ATTR_PAGEMAP_NAME);
        if (this._name == null || this._name.trim().length() == 0) {
            throw new CCLRuntimeException("The <pageMap> tag has a missing or invalid (name) attribute in PageMap (" + documentPath + ")");
        }
    }

    public PagesMeta loadPages() throws DocumentException, ClassNotFoundException {
        try {
            if (this._pagesMeta != null) {
                throw new CCLRuntimeException("Attempting to re-load pages for PageMap (" + this.getDocumentPath() + ").");
            }
            Element pagesElem = this.getChild("pages");
            if (pagesElem != null) {
                this._pagesMeta = new PagesMeta(pagesElem, this);
                this._viewCount = this._pagesMeta.getViewCount();
                this._pageCount = this._pagesMeta.getPageCount();
            }
        }
        catch (RuntimeException ex) {
            this._pagesMeta = null;
            throw ex;
        }
        catch (Exception ex) {
            this._pagesMeta = null;
            throw new CCLRuntimeException((Throwable)ex, "loading pagemap file '" + this.getDocumentPath() + "'");
        }
        this._pagesLoadedTime = this._pageMapFile.lastModified();
        return this._pagesMeta;
    }

    public String name() {
        if (this._name != null) {
            return this._name;
        }
        return this.getDocumentPath();
    }

    public long loadedTime() {
        return this._pagesLoadedTime;
    }

    public PageMap copy() throws FileNotFoundException, DocumentException, IOException {
        String documentPath = this.getDocumentPath();
        return new PageMap(documentPath, false);
    }

    public boolean sourceFileNewerThenPageMap() {
        File sourceFile = null;
        try {
            sourceFile = new File(this.getDocumentPath());
        }
        catch (Exception e) {
            return true;
        }
        return sourceFile.lastModified() > this.loadedTime();
    }

    public PageMap getNewCopyIfNecessary() throws FileNotFoundException, DocumentException, ClassNotFoundException, IOException {
        if (this.sourceFileNewerThenPageMap()) {
            return this.copy();
        }
        return null;
    }

    public PageMeta getPageMeta(String pageID) {
        if (pageID == null) {
            throw new IllegalArgumentException("No 'PageMetaData' can be retrieved for a null pageID");
        }
        if (this._pagesMeta == null) {
            throw new CCLRuntimeException("This PageMap has no pages or else the pages were no loaded (" + this.getDocumentPath() + ")");
        }
        PageMeta pageMeta = null;
        pageMeta = this._pagesMeta.getPageMeta(pageID);
        return pageMeta;
    }

    public boolean exists(String pageID) {
        if (pageID == null) {
            return false;
        }
        if (this._pagesMeta == null) {
            return false;
        }
        try {
            this._pagesMeta.getPageMeta(pageID);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public int getPageCount() {
        return this._pageCount;
    }

    public int getViewCount() {
        return this._viewCount;
    }

    public HashMap getPageHashMap() {
        if (this._pagesMeta == null) {
            return null;
        }
        return this._pagesMeta.getPageHashMap();
    }

    public static int parseBooleanString(String booleanString, boolean defaultInvalidStringToNo) {
        if (booleanString == null) {
            return -1;
        }
        if (PageMap.isYesString(booleanString)) {
            return 1;
        }
        if (!defaultInvalidStringToNo && !PageMap.isNoString(booleanString)) {
            throw new CCLRuntimeException("The given value of '" + booleanString + "' must be one of: 'y', 'yes', 'n' or 'no' (in any case)");
        }
        return 0;
    }

    public static boolean isYesString(String booleanString) {
        if (booleanString == null) {
            return false;
        }
        return booleanString.equalsIgnoreCase(PARAM_VALUE_Y) || booleanString.equalsIgnoreCase(PARAM_VALUE_YES);
    }

    public static boolean isNoString(String booleanString) {
        if (booleanString == null) {
            return false;
        }
        return booleanString.equalsIgnoreCase(PARAM_VALUE_N) || booleanString.equalsIgnoreCase(PARAM_VALUE_NO);
    }

    public static void main(String[] args) throws Exception {
        PageMap baseDoc = new PageMap(args[0], false);
        baseDoc.getDocument();
        baseDoc.getChild("pages");
    }
}

