/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.pagemap.manager;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.dispatcherJSP.api.IPageInfo;
import com.cognos.dispatcherJSP.api.IPageManager;
import com.cognos.dispatcherJSP.pagemap.manager.MasterPageMap;
import com.cognos.dispatcherJSP.pagemap.manager.ViewManager;
import com.cognos.dispatcherJSP.view.views.JSPView;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class PageMapObjectManager
implements IPageManager {
    private MasterPageMap m_masterPageMap = null;
    private boolean m_dynamicPageMapReload = false;
    private ViewManager m_viewManager = null;

    public void initialize(String pageMapPath, boolean dynamicPageMapReload, ServletConfig servletConfig, ServletContext servletContext, String basePath) {
        if (pageMapPath == null || servletConfig == null || servletContext == null) {
            throw new CCLRuntimeException("Null parameter passed to PageMapObjectManager initialize");
        }
        this.m_dynamicPageMapReload = dynamicPageMapReload;
        try {
            if (this.m_masterPageMap == null) {
                this.m_masterPageMap = new MasterPageMap(pageMapPath, false, basePath);
            }
        }
        catch (Exception e) {
            throw new CCLRuntimeException((Throwable)e, "loading MasterPageMap file (" + pageMapPath + ")");
        }
        if (this.m_viewManager == null) {
            this.m_viewManager = new ViewManager(this.m_masterPageMap, dynamicPageMapReload, servletConfig, servletContext);
            this.m_viewManager.load();
        }
    }

    public final JSPView getView(HttpServletRequest request, String pid) {
        if (this.m_viewManager == null) {
            throw new CCLRuntimeException("Attempting to use ViewManager when it has not yet been set");
        }
        return this.m_viewManager.getView(request, pid);
    }

    public final boolean exists(String pid) {
        if (this.m_masterPageMap == null) {
            return false;
        }
        return this.m_masterPageMap.exists(pid);
    }

    public void reloadIfNecessary() {
        if (!this.m_dynamicPageMapReload) {
            return;
        }
        try {
            if (this.m_masterPageMap.reloadIfNecessary()) {
                this.m_viewManager.reloadIfNecessary();
            }
        }
        catch (Exception e) {
            System.out.println("Failed to reload page map");
            e.printStackTrace();
        }
    }

    public void close() {
        this.m_masterPageMap = null;
        this.m_viewManager = null;
    }

    @Override
    public IPageInfo getPageInfo(String pid) {
        return this.m_masterPageMap.getPageMeta(pid);
    }
}

