/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.pagemap.meta.tags;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.dispatcherJSP.api.IPageInfo;
import com.cognos.dispatcherJSP.pagemap.manager.PageMap;
import com.cognos.dispatcherJSP.pagemap.meta.tags.ViewMeta;
import java.util.ArrayList;
import org.dom4j.Element;

public class PageMeta
implements IPageInfo {
    public static final String tagName = "page";
    public static final String ATTR_PAGE_ID = "id";
    public static final String ATTR_ALIAS_ROOT_ID = "alias";
    public static final String ATTR_PAGE_URL = "url";
    public static final String ATTR_PAGE_VIEW = "view";
    private String m_pid = "no_id";
    private ViewMeta m_viewMeta = null;
    protected int m_viewCount = 0;
    private ArrayList m_allPageIDs = null;
    private PageMap m_pageMap = null;
    private Element m_customData;

    public PageMeta(Element elem, PageMap pageMap) {
        if (pageMap == null) {
            throw new IllegalArgumentException("Missing required parameter.");
        }
        this.m_pageMap = pageMap;
        this.loadFromElement(elem);
    }

    public void initialize(String pid, ViewMeta viewMeta, Element customData) {
        if (pid != null) {
            this.m_pid = pid;
        }
        this.m_allPageIDs = new ArrayList();
        this.m_allPageIDs.add(this.m_pid);
        this.m_viewMeta = viewMeta;
        if (customData != null) {
            this.m_customData = (Element)customData.clone();
            this.m_customData.detach();
        }
    }

    public void loadFromElement(Element elem) {
        if (elem == null) {
            throw new IllegalArgumentException("Missing required parameter.");
        }
        if (!elem.getName().equalsIgnoreCase(tagName)) {
            throw new IllegalArgumentException("Expecting an element representing a <page> tag.");
        }
        String pid = null;
        String url = null;
        try {
            pid = elem.attributeValue(ATTR_PAGE_ID);
            if (pid == null) {
                throw new IllegalArgumentException("The <page> tag is missing the 'id' attribute.");
            }
            ViewMeta viewMeta = this.loadViewMetaFromElement(elem, pid);
            if (viewMeta != null) {
                ++this.m_viewCount;
            }
            Element customData = this.loadCustomDataFromElement(elem);
            this.initialize(pid, viewMeta, customData);
        }
        catch (Exception ex) {
            throw new CCLRuntimeException((Throwable)ex, "loading PageMeta for pid='" + pid + "' url='" + url + "'");
        }
    }

    private ViewMeta loadViewMetaFromElement(Element elem, String pid) {
        String viewAttr = elem.attributeValue(ATTR_PAGE_VIEW);
        Element viewElem = elem.element(ATTR_PAGE_VIEW);
        if (viewElem != null) {
            if (viewAttr != null) {
                throw new CCLRuntimeException("The 'view' attribute cannot be specified if a 'view' tag is also specified.");
            }
            return new ViewMeta(viewElem, pid, this.m_pageMap);
        }
        if (viewAttr != null) {
            return new ViewMeta(viewAttr, pid, this.m_pageMap);
        }
        throw new CCLRuntimeException("View must be specified");
    }

    private Element loadCustomDataFromElement(Element elem) {
        Element viewElem = elem.element("custom");
        return viewElem;
    }

    public ViewMeta getViewMeta() {
        return this.m_viewMeta;
    }

    public int getViewCount() {
        return this.m_viewCount;
    }

    public ArrayList getAllPageIDs() {
        return this.m_allPageIDs;
    }

    public String pageMapName() {
        return this.m_pageMap.name();
    }

    public String pageMapDocumentPath() {
        return this.m_pageMap.getDocumentPath();
    }

    public String toString() {
        return "Page [" + this.m_pid + "]";
    }

    @Override
    public String getPID() {
        return this.m_pid;
    }

    @Override
    public Element getCustomData() {
        return this.m_customData;
    }
}

