/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.pagemap.meta.tags;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.dispatcherJSP.pagemap.manager.PageMap;
import com.cognos.dispatcherJSP.pagemap.meta.tags.PageMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class PagesMeta {
    public static final String tagName = "pages";
    protected HashMap m_pageHashMap = null;
    private PageMap m_pageMap = null;
    protected int m_viewCount = 0;
    protected int m_pageCount = 0;

    public PagesMeta(Element elem, PageMap pageMap) {
        if (pageMap == null) {
            throw new IllegalArgumentException("Missing required parameter.");
        }
        this.m_pageMap = pageMap;
        this.m_pageHashMap = new HashMap();
        this.loadFromElement(elem);
    }

    private void loadFromElement(Element elem) {
        if (elem == null) {
            throw new IllegalArgumentException("Missing required parameter.");
        }
        if (!elem.getName().equalsIgnoreCase(tagName)) {
            throw new IllegalArgumentException("Expecting an element representing a <pages> tag.");
        }
        try {
            HashMap<String, PageMeta> pageHashMap = new HashMap<String, PageMeta>();
            Element pageElem = null;
            PageMeta pageMeta = null;
            int count = 1;
            List pageList = elem.elements("page");
            Iterator iter = pageList.iterator();
            while (iter.hasNext()) {
                try {
                    pageElem = (Element)iter.next();
                    pageMeta = new PageMeta(pageElem, this.m_pageMap);
                    ++this.m_pageCount;
                    this.m_viewCount += pageMeta.getViewCount();
                    ArrayList allPageIDs = pageMeta.getAllPageIDs();
                    int numIDs = allPageIDs.size();
                    String id = null;
                    for (int i = 0; i < numIDs; ++i) {
                        id = (String)allPageIDs.get(i);
                        if (pageHashMap.get(id) != null) {
                            throw new IllegalArgumentException("Duplicate <page> tag with 'id' attribute of '" + pageMeta.getPID());
                        }
                        pageHashMap.put(id, pageMeta);
                    }
                    ++count;
                }
                catch (Exception ex) {
                    throw new CCLRuntimeException((Throwable)ex, "loading PageMeta for page number " + count);
                }
            }
            this.m_pageHashMap = pageHashMap;
        }
        catch (Exception ex) {
            throw new CCLRuntimeException((Throwable)ex, "loading PagesMeta");
        }
    }

    public PageMeta getPageMeta(String pageID) {
        if (pageID == null) {
            throw new IllegalArgumentException("No page definition can be found for a null pageID");
        }
        PageMeta pageMeta = (PageMeta)this.m_pageHashMap.get(pageID);
        if (pageMeta == null) {
            throw new IllegalArgumentException("No page definition found: no <page>, tag was found for page ID '" + pageID + "'");
        }
        return pageMeta;
    }

    public HashMap getPageHashMap() {
        return this.m_pageHashMap;
    }

    public int getViewCount() {
        return this.m_viewCount;
    }

    public int getPageCount() {
        return this.m_pageCount;
    }
}

