/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.pagemap.meta.tags;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.dispatcherJSP.pagemap.manager.PageMap;
import org.dom4j.Element;

public class ViewMeta {
    public static final String VIEW_TAG_NAME = "view";
    public static final String ATTR_VIEW_CLASS = "class";
    protected String m_className = "not_specified";
    protected String m_pageID = "not_specified";

    public ViewMeta(String className, String pageID, PageMap pageMap) {
        if (pageMap == null) {
            throw new IllegalArgumentException("Missing required parameter.");
        }
        this.initialize(className, pageID);
    }

    public ViewMeta(Element elem, String pageID, PageMap pageMap) {
        if (pageMap == null) {
            throw new IllegalArgumentException("Missing required parameter.");
        }
        this.loadFromElement(elem, pageID);
    }

    public void initialize(String className, String pageID) {
        if (className == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        this.m_className = className;
        if (pageID != null) {
            this.m_pageID = pageID;
        }
    }

    public void loadFromElement(Element elem, String pageID) {
        String className = null;
        try {
            if (elem == null) {
                throw new IllegalArgumentException("Missing required parameter.");
            }
            if (!elem.getName().equalsIgnoreCase(VIEW_TAG_NAME)) {
                throw new IllegalArgumentException("Expecting an element representing a <view> tag.");
            }
            className = elem.attributeValue(ATTR_VIEW_CLASS);
            if (className == null) {
                throw new IllegalArgumentException("The <view> tag is missing the 'class' attribute.");
            }
            this.initialize(className, pageID);
        }
        catch (Exception ex) {
            throw new CCLRuntimeException((Throwable)ex, "loading ViewMeta for classname='" + className + "' pageID='" + pageID + "'");
        }
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getPageID() {
        return this.m_pageID;
    }

    public String toString() {
        return "View(" + this.m_className + ")";
    }
}

