/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.servlet;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.dispatcherJSP.logging.LogControl;
import com.cognos.dispatcherJSP.servlet.Buffer;
import com.cognos.dispatcherJSP.servlet.BufferedReceiverStream;
import com.cognos.dispatcherJSP.servlet.StandaloneHttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

public final class BufferedIOResponseStream
extends InputStream {
    static int DEFAULT_BUFFER_SIZE = 65536;
    private static long DEFAULT_READ_WAIT_MS = 10000L;
    private static int MAX_BUFFER_POOL_SIZE = 200;
    static int _nNextBufferId = 0;
    private static LinkedList _vEmptyBuffers = new LinkedList();
    LinkedList _vFilledBuffers = new LinkedList();
    Buffer _currentReadBuffer = null;
    private long _timeoutMillis = DEFAULT_READ_WAIT_MS;
    private BufferedReceiverStream _receiverStream = null;
    boolean m_entireStreamRead = false;
    private int m_responseBufferSize = 8192;
    private boolean m_headersSent = false;
    StandaloneHttpServletResponse m_response;

    public BufferedIOResponseStream(long blockMS, StandaloneHttpServletResponse response) {
        this.m_response = response;
        this._timeoutMillis = blockMS;
        this._receiverStream = new BufferedReceiverStream(this);
    }

    protected void setResponseBufferSize(int responseBufferSize) {
        this.m_responseBufferSize = responseBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Buffer acquireFilledBuffer() {
        Buffer buff = null;
        LinkedList linkedList = this._vFilledBuffers;
        synchronized (linkedList) {
            buff = this._vFilledBuffers.isEmpty() && this.m_entireStreamRead ? null : this.acquireBufferFromList_WithWait();
        }
        if (buff != null) {
            buff._nIdxLastRead = -1;
        }
        return buff;
    }

    public synchronized int getNextBufferId() {
        int n = _nNextBufferId++;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseFilledBuffer(Buffer buff) {
        if (buff != null) {
            LinkedList linkedList = this._vFilledBuffers;
            synchronized (linkedList) {
                this._vFilledBuffers.addLast(buff);
                this._vFilledBuffers.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Buffer acquireEmptyBuffer() {
        Buffer buffRet = null;
        LinkedList linkedList = _vEmptyBuffers;
        synchronized (linkedList) {
            if (!_vEmptyBuffers.isEmpty()) {
                buffRet = (Buffer)_vEmptyBuffers.removeFirst();
                buffRet.reset();
            }
        }
        if (buffRet == null) {
            buffRet = new Buffer(this);
        }
        return buffRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseEmptyBuffer(Buffer buff) {
        if (buff != null && _vEmptyBuffers.size() < MAX_BUFFER_POOL_SIZE) {
            LinkedList linkedList = _vEmptyBuffers;
            synchronized (linkedList) {
                _vEmptyBuffers.add(buff);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Buffer acquireBufferFromList_WithWait() {
        Buffer buffRet = null;
        LinkedList linkedList = this._vFilledBuffers;
        synchronized (linkedList) {
            while (this._vFilledBuffers.isEmpty() && !this.m_entireStreamRead) {
                try {
                    this._vFilledBuffers.wait(this._timeoutMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this._vFilledBuffers.isEmpty()) {
                buffRet = (Buffer)this._vFilledBuffers.removeFirst();
            }
        }
        return buffRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitIfAble() {
        if (!this.m_response.isCommitted()) {
            LinkedList linkedList = this._vFilledBuffers;
            synchronized (linkedList) {
                if (this.isSufficientDataAvailable()) {
                    this.forceCommit();
                }
            }
        }
    }

    private void forceCommit() {
        this.insertHeadersBuffer();
        this.releaseFilledBuffer(this._receiverStream._currentWriteBuffer);
        this._receiverStream._currentWriteBuffer = null;
        this.m_response.setCommitted();
        this.m_headersSent = true;
    }

    private void insertHeadersBuffer() {
        Buffer b = this.acquireEmptyBuffer();
        ByteArrayOutputStream bArray = new ByteArrayOutputStream();
        this.m_response.writeHeaders(bArray);
        byte[] header = bArray.toByteArray();
        System.arraycopy(header, 0, b._bytes, 0, header.length);
        b._nIdxNextFree = header.length;
        this._vFilledBuffers.add(0, b);
        this.m_headersSent = true;
    }

    private boolean isSufficientDataAvailable() {
        int totSize = 0;
        if (this._receiverStream._currentWriteBuffer != null) {
            totSize += this._receiverStream._currentWriteBuffer._nIdxNextFree;
        }
        for (int i = 0; i < this._vFilledBuffers.size(); ++i) {
            Buffer b = (Buffer)this._vFilledBuffers.get(i);
            totSize += b._nIdxNextFree;
        }
        return totSize >= this.m_responseBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Buffer acquireBufferFromList_NoWait(LinkedList list) {
        Buffer buffRet = null;
        LinkedList linkedList = list;
        synchronized (linkedList) {
            if (!list.isEmpty()) {
                buffRet = (Buffer)list.removeFirst();
            }
        }
        return buffRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markEndOfReceiverStream() {
        if (!this.m_response.isCommitted()) {
            this.forceCommit();
        }
        this.m_entireStreamRead = true;
        LinkedList linkedList = this._vFilledBuffers;
        synchronized (linkedList) {
            this._vFilledBuffers.notifyAll();
        }
    }

    public BufferedReceiverStream getOutputStream() {
        return this._receiverStream;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b, 0, 1);
        if (read == -1) {
            return read;
        }
        return b[0];
    }

    @Override
    public int read(byte[] outBytes, int outOffset, int len) throws IOException {
        Buffer buff = null;
        int retBytesReturned = 0;
        try {
            if (this._currentReadBuffer == null) {
                this._currentReadBuffer = this.acquireFilledBuffer();
            }
            if ((buff = this._currentReadBuffer) == null) {
                this.perfLastRead();
                return -1;
            }
            int nMaxToRead = len - outOffset;
            int nAmountToMove = nMaxToRead;
            int nIdxNextUnread = buff._nIdxLastRead + 1;
            int nRemainingInBuffer = buff._nIdxNextFree - nIdxNextUnread;
            if (nAmountToMove > nRemainingInBuffer) {
                nAmountToMove = nRemainingInBuffer;
            }
            System.arraycopy(buff._bytes, nIdxNextUnread, outBytes, outOffset, nAmountToMove);
            retBytesReturned = nAmountToMove;
            buff._nIdxLastRead += nAmountToMove;
            if (buff._nIdxLastRead + 1 >= buff._nIdxNextFree) {
                this.releaseEmptyBuffer(buff);
                this._currentReadBuffer = null;
            }
        }
        catch (Exception ex) {
            throw new CCLRuntimeException((Throwable)ex, "reading multiple chars");
        }
        if (retBytesReturned == 0) {
            this.perfLastRead();
        }
        LogControl.getInstance().logResponseBufferRead(outBytes, outOffset, retBytesReturned);
        return retBytesReturned;
    }

    private void perfLastRead() {
    }

    @Override
    public long skip(long n) {
        throw new CCLRuntimeException("This method not yet supported for a BufferedInputOutputStream");
    }

    @Override
    public int available() {
        return 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) {
        throw new CCLRuntimeException("This method not supported for this type of InputStream");
    }

    @Override
    public void reset() {
        throw new CCLRuntimeException("This method not supported for this type of InputStream");
    }

    @Override
    public void close() throws IOException {
        if (this._currentReadBuffer != null) {
            this.releaseEmptyBuffer(this._currentReadBuffer);
            this._currentReadBuffer = null;
        }
        this._receiverStream.close();
    }
}

