/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.servlet;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.dispatcherJSP.servlet.Buffer;
import com.cognos.dispatcherJSP.servlet.BufferedIOResponseStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;

public final class BufferedReceiverStream
extends OutputStream {
    private final BufferedIOResponseStream m_bufferedIOResponseStream;
    Buffer _currentWriteBuffer = null;
    public boolean _bAllowFlushing = true;

    BufferedReceiverStream(BufferedIOResponseStream bufferedIOResponseStream) {
        this.m_bufferedIOResponseStream = bufferedIOResponseStream;
    }

    public void setResponseBufferSize(int responseBufferSize) {
        this.m_bufferedIOResponseStream.setResponseBufferSize(responseBufferSize);
    }

    public void setAutoCommit(boolean autoComit) {
    }

    @Override
    public void write(byte[] inBytes) throws IOException {
        this.write(inBytes, 0, inBytes.length);
    }

    @Override
    public void write(byte[] baInput, int nInputOffset, int nToBeWrittenCount) throws IOException {
        int nWrittenCount = 0;
        while (nWrittenCount < nToBeWrittenCount) {
            int nBytesLeftInBuffer;
            int nBytesToWrite;
            Buffer buff = this._currentWriteBuffer;
            if (buff == null) {
                buff = this._currentWriteBuffer = this.m_bufferedIOResponseStream.acquireEmptyBuffer();
            }
            if ((nBytesToWrite = nToBeWrittenCount - nWrittenCount) > (nBytesLeftInBuffer = BufferedIOResponseStream.DEFAULT_BUFFER_SIZE - buff._nIdxNextFree)) {
                nBytesToWrite = nBytesLeftInBuffer;
            }
            System.arraycopy(baInput, nInputOffset, buff._bytes, buff._nIdxNextFree, nBytesToWrite);
            nWrittenCount += nBytesToWrite;
            nInputOffset += nBytesToWrite;
            buff._nIdxNextFree += nBytesToWrite;
            if (buff._nIdxNextFree != BufferedIOResponseStream.DEFAULT_BUFFER_SIZE) continue;
            this.m_bufferedIOResponseStream.releaseFilledBuffer(buff);
            this._currentWriteBuffer = null;
        }
        this.m_bufferedIOResponseStream.commitIfAble();
    }

    @Override
    public void write(int b) throws IOException {
        throw new CCLRuntimeException("Method not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Buffer buffRead = this.m_bufferedIOResponseStream._currentReadBuffer;
        this.m_bufferedIOResponseStream._currentReadBuffer = null;
        if (buffRead != null) {
            this.m_bufferedIOResponseStream.releaseEmptyBuffer(buffRead);
        }
        LinkedList linkedList = this.m_bufferedIOResponseStream._vFilledBuffers;
        synchronized (linkedList) {
            if (this._currentWriteBuffer != null) {
                this.m_bufferedIOResponseStream.releaseEmptyBuffer(this._currentWriteBuffer);
                this._currentWriteBuffer = null;
            }
            Buffer buffFilled = null;
            while (!this.m_bufferedIOResponseStream._vFilledBuffers.isEmpty()) {
                buffFilled = (Buffer)this.m_bufferedIOResponseStream._vFilledBuffers.removeFirst();
                this.m_bufferedIOResponseStream.releaseEmptyBuffer(buffFilled);
            }
        }
    }

    @Override
    public void flush() {
        if (this._bAllowFlushing && this._currentWriteBuffer != null) {
            this.m_bufferedIOResponseStream.releaseFilledBuffer(this._currentWriteBuffer);
            this._currentWriteBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.m_bufferedIOResponseStream.m_entireStreamRead) {
            this.flush();
            LinkedList linkedList = this.m_bufferedIOResponseStream._vFilledBuffers;
            synchronized (linkedList) {
                this.m_bufferedIOResponseStream.m_entireStreamRead = true;
                this.m_bufferedIOResponseStream._vFilledBuffers.notify();
            }
        }
    }

    public String toString() {
        return this.m_bufferedIOResponseStream.toString();
    }
}

