/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.servlet;

import com.cognos.dispatcherJSP.servlet.BufferedReceiverStream;
import com.cognos.dispatcherJSP.servlet.StandaloneHttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;

public final class ResponseStream
extends ServletOutputStream {
    protected boolean _closed = false;
    protected boolean _commit = false;
    protected int _count = 0;
    protected int _length = -1;
    protected StandaloneHttpServletResponse _response = null;
    protected OutputStream _stream = null;

    public ResponseStream(StandaloneHttpServletResponse response) {
        this._response = response;
        this._stream = this._response.getStream();
    }

    boolean getCommit() {
        return this._commit;
    }

    void setCommit(boolean commit) {
        this._commit = commit;
    }

    public void close() throws IOException {
        if (this._closed) {
            throw new IOException("This output stream has already been closed");
        }
        this._response.flushBuffer();
        this._stream.close();
        this._closed = true;
    }

    public void flush() throws IOException {
        if (this._closed) {
            throw new IOException("Cannot flush a closed output stream");
        }
        this._response.flushBuffer();
    }

    public void write(int b) throws IOException {
        if (this._closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (this._length > 0 && this._count >= this._length) {
            throw new IOException("Cannot write more bytes than content length to this output stream");
        }
        this._response.write(b);
        ++this._count;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this._response.write(b, off, len);
    }

    boolean closed() {
        return this._closed;
    }

    void reset() {
        this._count = 0;
        if (this._stream instanceof BufferedReceiverStream) {
            BufferedReceiverStream bios = (BufferedReceiverStream)this._stream;
            bios.reset();
        }
    }
}

