/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.servlet;

import com.cognos.dispatcherJSP.servlet.BufferedReceiverStream;
import com.cognos.dispatcherJSP.servlet.ResponseStream;
import com.cognos.dispatcherJSP.util.CookieUtils;
import com.cognos.dispatcherJSP.util.Maps;
import com.cognos.dispatcherJSP.util.SystemUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class StandaloneHttpServletResponse
implements HttpServletResponse {
    protected boolean m_committed = false;
    protected int m_contentCount = 0;
    protected int m_contentLength = -1;
    protected String m_contentType = null;
    protected String m_encoding = null;
    protected boolean m_included = false;
    protected Locale m_locale = Locale.getDefault();
    protected HttpServletRequest m_request = null;
    public BufferedReceiverStream m_outputStream = null;
    protected ResponseStream m_servletOutputStream = null;
    protected PrintWriter m_writer = null;
    protected boolean m_error = false;
    protected ArrayList m_cookies = new ArrayList();
    protected final SimpleDateFormat m_format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    protected HashMap m_headers = new HashMap();
    protected String m_message = this.getStatusMessage(200);
    protected int m_status = 200;
    protected String m_contextPath = null;
    protected Object m_commitSync = null;
    protected static final String _info = "com.cognos.dispatcherJSP.servlet.StandaloneHttpServletResponse/1.0";

    public StandaloneHttpServletResponse(HttpServletRequest request, String contextPath) {
        this.m_request = request;
        this.m_contextPath = contextPath;
        this.m_commitSync = new Object();
    }

    private void cleanUp() {
        this.m_request = null;
        this.m_outputStream = null;
        this.m_servletOutputStream = null;
        this.m_writer = null;
        this.m_cookies.clear();
        this.m_headers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForCommit(long waitMS) throws InterruptedException {
        if (waitMS < 0L) {
            waitMS = 0L;
        }
        Object object = this.m_commitSync;
        synchronized (object) {
            if (!this.m_committed) {
                this.m_commitSync.wait(waitMS);
            }
        }
        return this.m_committed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCommitted() {
        if (!this.m_committed) {
            Object object = this.m_commitSync;
            synchronized (object) {
                this.m_committed = true;
                this.m_commitSync.notifyAll();
            }
        }
    }

    public int getBufferSize() {
        return 0;
    }

    public String getCharacterEncoding() {
        if (this.m_encoding == null) {
            return "utf-8";
        }
        return this.m_encoding;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.m_writer != null) {
            throw new IllegalStateException("getWriter() has already been called for this response");
        }
        if (this.m_servletOutputStream == null) {
            this.m_servletOutputStream = (ResponseStream)this.createOutputStream();
        }
        this.m_servletOutputStream.setCommit(true);
        return this.m_servletOutputStream;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.m_writer != null) {
            return this.m_writer;
        }
        if (this.m_servletOutputStream != null) {
            throw new IllegalStateException("getOutputStream() has already been called for this response");
        }
        this.m_servletOutputStream = (ResponseStream)this.createOutputStream();
        this.m_servletOutputStream.setCommit(false);
        String encoding = this.getCharacterEncoding();
        OutputStreamWriter osr = new OutputStreamWriter((OutputStream)((Object)this.m_servletOutputStream), encoding);
        this.m_writer = new PrintWriter(osr);
        return this.m_writer;
    }

    public boolean isCommitted() {
        return this.m_committed;
    }

    public void resetBuffer() {
        if (this.m_outputStream instanceof BufferedReceiverStream) {
            BufferedReceiverStream bios = this.m_outputStream;
            bios._bAllowFlushing = false;
            if (this.m_writer != null) {
                this.m_writer.flush();
            }
            bios._bAllowFlushing = true;
            bios.reset();
        }
    }

    public void setBufferSize(int size) {
        this.m_outputStream.setResponseBufferSize(size);
    }

    public boolean isAppCommitted() {
        return this.m_committed;
    }

    public int getContentCount() {
        return this.m_contentCount;
    }

    public boolean getIncluded() {
        return this.m_included;
    }

    public void setIncluded(boolean included) {
        this.m_included = included;
    }

    public String getInfo() {
        return _info;
    }

    public OutputStream getStream() {
        return this.m_outputStream;
    }

    public void setStream(BufferedReceiverStream stream) {
        this.m_outputStream = stream;
    }

    public void setError() {
        this.m_error = true;
    }

    public ServletOutputStream createOutputStream() throws IOException {
        return new ResponseStream(this);
    }

    public int getContentLength() {
        return this.m_contentLength;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public void write(int b) throws IOException {
        this.m_outputStream.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.m_outputStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.m_outputStream.write(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCookie(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        if (this.m_included) {
            return;
        }
        ArrayList arrayList = this.m_cookies;
        synchronized (arrayList) {
            this.m_cookies.add(cookie);
        }
    }

    public void addDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.m_included) {
            return;
        }
        this.addHeader(name, this.m_format.format(new Date(value)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.m_included) {
            return;
        }
        HashMap hashMap = this.m_headers;
        synchronized (hashMap) {
            ArrayList<String> values = (ArrayList<String>)this.m_headers.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.m_headers.put(name, values);
            }
            values.add(value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.m_included) {
            return;
        }
        this.addHeader(name, "" + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsHeader(String name) {
        HashMap hashMap = this.m_headers;
        synchronized (hashMap) {
            return this.m_headers.get(name) != null;
        }
    }

    public String encodeRedirectURL(String url) {
        if (this.isEncodeable(this.toAbsolute(url))) {
            return this.toEncoded(url, this.m_request.getSession().getId());
        }
        return url;
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeURL(String url) {
        if (this.isEncodeable(this.toAbsolute(url))) {
            return this.toEncoded(url, this.m_request.getSession().getId());
        }
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public void sendAcknowledgement() throws IOException {
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, this.getStatusMessage(status));
    }

    public void sendError(int status, String message) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot call sendError() after the response has been committed");
        }
        if (this.m_included) {
            return;
        }
        this.m_status = status;
        this.m_message = message;
        this.resetBuffer();
    }

    public void sendRedirect(String location) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot call sendRedirect() after the response has been committed");
        }
        if (this.m_included) {
            return;
        }
        this.resetBuffer();
        try {
            String absolute = this.toAbsolute(location);
            this.setStatus(302);
            this.setHeader("Location", absolute);
        }
        catch (IllegalArgumentException e) {
            this.setStatus(404);
        }
    }

    public void setDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.m_included) {
            return;
        }
        this.setHeader(name, this.m_format.format(new Date(value)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.m_included) {
            return;
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        HashMap hashMap = this.m_headers;
        synchronized (hashMap) {
            this.m_headers.put(name, values);
        }
        String match = name.toLowerCase();
        if (match.equals("content-length")) {
            int _contentLength = -1;
            try {
                _contentLength = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (_contentLength >= 0) {
                this.setContentLength(_contentLength);
            }
        } else if (match.equals("content-type")) {
            this.setContentType(value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.m_included) {
            return;
        }
        this.setHeader(name, "" + value);
    }

    public void setStatus(int status) {
        this.setStatus(status, this.getStatusMessage(status));
    }

    public void setStatus(int status, String message) {
        if (this.m_included) {
            return;
        }
        this.m_status = status;
        this.m_message = message;
    }

    public void finishResponse() throws IOException {
        if (!this.isCommitted() && this.m_servletOutputStream == null && this.m_writer == null && this.m_status >= 400 && this.m_contentType == null && this.m_contentCount == 0) {
            try {
                this.setContentType("text/html");
                PrintWriter writer = this.getWriter();
                writer.println("<html>");
                writer.println("<head>");
                writer.println("<title>Error Report</title>");
                writer.println("<br><br>");
                writer.println("<h1>HTTP Status ");
                writer.print(this.m_status);
                writer.print(" - ");
                if (this.m_message != null) {
                    writer.print(this.m_message);
                } else {
                    writer.print(this.getStatusMessage(this.m_status));
                }
                writer.println("</h1>");
                writer.println("</body>");
                writer.println("</html>");
            }
            catch (IOException e) {
                this.cleanUp();
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (this.m_servletOutputStream == null) {
            ServletOutputStream sos = this.getOutputStream();
            sos.flush();
            sos.close();
            this.cleanUp();
            return;
        }
        if (this.m_servletOutputStream.closed()) {
            this.cleanUp();
            return;
        }
        if (this.m_writer != null) {
            this.m_writer.flush();
            this.m_writer.close();
        } else {
            this.m_servletOutputStream.flush();
            this.m_servletOutputStream.close();
        }
        this.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cookie[] getCookies() {
        ArrayList arrayList = this.m_cookies;
        synchronized (arrayList) {
            return this.m_cookies.toArray(new Cookie[this.m_cookies.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeader(String name) {
        ArrayList values = null;
        HashMap hashMap = this.m_headers;
        synchronized (hashMap) {
            values = (ArrayList)this.m_headers.get(name);
        }
        if (values != null) {
            return (String)values.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHeaderNames() {
        HashMap hashMap = this.m_headers;
        synchronized (hashMap) {
            String[] results = new String[this.m_headers.size()];
            return this.m_headers.keySet().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHeaderValues(String name) {
        ArrayList values = null;
        HashMap hashMap = this.m_headers;
        synchronized (hashMap) {
            values = (ArrayList)this.m_headers.get(name);
        }
        if (values == null) {
            return new String[0];
        }
        String[] results = new String[values.size()];
        return values.toArray(results);
    }

    public String getMessage() {
        return this.m_message;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void recycle() {
        this.m_committed = false;
        this.m_contentCount = 0;
        this.m_contentLength = -1;
        this.m_contentType = null;
        this.m_encoding = null;
        this.m_included = false;
        this.m_locale = Locale.getDefault();
        this.m_request = null;
        this.m_outputStream = null;
        this.m_servletOutputStream = null;
        this.m_writer = null;
        this.m_error = false;
        this.m_cookies.clear();
        this.m_headers.clear();
        this.m_message = this.getStatusMessage(200);
        this.m_status = 200;
    }

    public void reset(int status, String message) {
        this.reset();
        this.setStatus(status, message);
    }

    protected String getStatusMessage(int status) {
        switch (status) {
            case 200: {
                return "OK";
            }
            case 202: {
                return "Accepted";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 400: {
                return "Bad Request";
            }
            case 409: {
                return "Conflict";
            }
            case 100: {
                return "Continue";
            }
            case 201: {
                return "Created";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 403: {
                return "Forbidden";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 410: {
                return "Gone";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 411: {
                return "Length Required";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Moved Temporarily";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 204: {
                return "No Content";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 404: {
                return "Not Found";
            }
            case 501: {
                return "Not Implemented";
            }
            case 304: {
                return "Not Modified";
            }
            case 206: {
                return "Partial Content";
            }
            case 402: {
                return "Payment Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 408: {
                return "Request Timeout";
            }
            case 414: {
                return "Request URI Too Long";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 205: {
                return "Reset Content";
            }
            case 303: {
                return "See Other";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 401: {
                return "Unauthorized";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 305: {
                return "Use Proxy";
            }
            case 207: {
                return "Multi-Status";
            }
            case 422: {
                return "Unprocessable Entity";
            }
            case 423: {
                return "Locked";
            }
            case 507: {
                return "Insufficient Storage";
            }
        }
        return "HTTP Response Status " + status;
    }

    private boolean isEncodeable(String location) {
        int urlPort;
        if (location == null) {
            return false;
        }
        if (location.startsWith("#")) {
            return false;
        }
        HttpSession session = this.m_request.getSession(false);
        if (session == null) {
            return false;
        }
        if (this.m_request.isRequestedSessionIdFromCookie()) {
            return false;
        }
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!this.m_request.getScheme().equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        if (!this.m_request.getServerName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        int serverPort = this.m_request.getServerPort();
        if (serverPort == -1) {
            serverPort = "https".equals(this.m_request.getScheme()) ? 443 : 80;
        }
        if ((urlPort = url.getPort()) == -1) {
            urlPort = "https".equals(url.getProtocol()) ? 443 : 80;
        }
        if (serverPort != urlPort) {
            return false;
        }
        if (this.m_contextPath != null && this.m_contextPath.length() > 0) {
            String file = url.getFile();
            if (file == null || !file.startsWith(this.m_contextPath)) {
                return false;
            }
            if (file.indexOf(";jsessionid=" + session.getId()) >= 0) {
                return false;
            }
        }
        return true;
    }

    protected String getProtocol() {
        return this.m_request.getProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHeaders(OutputStream outStream) {
        OutputStreamWriter osr = null;
        try {
            osr = new OutputStreamWriter(outStream, this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            osr = new OutputStreamWriter(outStream);
        }
        PrintWriter outputWriter = new PrintWriter(osr);
        if (this.getContentType() != null) {
            outputWriter.println("Content-Type: " + this.getContentType());
        } else {
            outputWriter.println("Content-Type: text/html;charset=UTF-8");
        }
        if (this.getContentLength() >= 0) {
            outputWriter.println("Content-Length: " + this.getContentLength());
        }
        Cloneable cloneable = this.m_headers;
        synchronized (cloneable) {
            for (String name : this.m_headers.keySet()) {
                ArrayList values = (ArrayList)this.m_headers.get(name);
                for (String value : values) {
                    outputWriter.print(name);
                    outputWriter.print(": ");
                    outputWriter.println(value);
                }
            }
        }
        cloneable = this.m_cookies;
        synchronized (cloneable) {
            for (Cookie cookie : this.m_cookies) {
                outputWriter.print(CookieUtils.getCookieHeaderName(cookie));
                outputWriter.print(": ");
                outputWriter.println(CookieUtils.getCookieHeaderValue(cookie));
            }
        }
        outputWriter.println();
        outputWriter.flush();
    }

    private String toAbsolute(String location) {
        if (location == null) {
            return location;
        }
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e1) {
            StringBuffer reqSB = this.m_request.getRequestURL();
            String requrl = reqSB.toString();
            try {
                url = new URL(new URL(requrl), location);
            }
            catch (MalformedURLException e2) {
                throw new IllegalArgumentException(location);
            }
        }
        return url.toExternalForm();
    }

    private String toEncoded(String url, String sessionId) {
        StringBuffer sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((sb = new StringBuffer(path)).length() > 0) {
            sb.append(";jsessionid=");
            sb.append(sessionId);
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }

    public void flushBuffer() throws IOException {
        this.m_outputStream.flush();
    }

    private void doFlushBuffer() throws IOException {
        this.m_outputStream.flush();
    }

    public void commitResponse() throws IOException {
        this.setCommitted();
    }

    public void reseatWriter() {
        this.m_writer = null;
        this.m_servletOutputStream = null;
    }

    public void reset() {
        if (this.m_included) {
            return;
        }
        if (this.m_committed) {
            throw new IllegalStateException("Cannot reset after response has been committed");
        }
        BufferedReceiverStream bios = this.m_outputStream;
        bios._bAllowFlushing = false;
        if (this.m_writer != null) {
            this.m_writer.flush();
        }
        bios._bAllowFlushing = true;
        if (this.m_servletOutputStream != null) {
            this.m_servletOutputStream.reset();
        }
        this.m_contentLength = -1;
        this.m_contentType = null;
        this.m_cookies.clear();
        this.m_headers.clear();
        this.m_message = null;
        this.m_status = 200;
    }

    public void setContentLength(int length) {
        if (this.isCommitted()) {
            return;
        }
        if (this.m_included) {
            return;
        }
        this.m_contentLength = length;
    }

    public void setContentType(String type) {
        if (this.isCommitted()) {
            return;
        }
        if (this.m_included) {
            return;
        }
        this.m_contentType = type;
        if (type.indexOf(59) >= 0) {
            this.m_encoding = StandaloneHttpServletResponse.parseCharacterEncoding(type);
            if (this.m_encoding == null) {
                this.m_encoding = "UTF-8";
            }
        } else if (this.m_encoding != null) {
            this.m_contentType = type + ";charset=" + this.m_encoding;
        }
    }

    public void setLocale(Locale locale) {
        throw new UnsupportedOperationException("This method is not supported by the ALP StandaloneHttpServletResponse");
    }

    public String cookiesToString(Cookie cookie) {
        StringBuffer buf = new StringBuffer(1200);
        this.cookiesToSB(buf, 0, false);
        return buf.toString();
    }

    public String cookiesToString(int indent, boolean newLine) {
        StringBuffer buf = new StringBuffer(1200);
        this.cookiesToSB(buf, indent, newLine);
        return buf.toString();
    }

    public synchronized void cookiesToSB(StringBuffer buf, int indent, boolean newline) {
        if (buf == null) {
            return;
        }
        for (Cookie cookie : this.m_cookies) {
            CookieUtils.cookieToSB(cookie, buf, indent, newline);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(3000);
        sb.append(SystemUtil.lineSeparator);
        sb.append("StandaloneHttpServletResponse:");
        sb.append(SystemUtil.lineSeparator);
        sb.append("  contentType: " + this.m_contentType);
        sb.append(SystemUtil.lineSeparator);
        sb.append("  contentLength: " + this.m_contentLength);
        sb.append(SystemUtil.lineSeparator);
        sb.append("  encoding: " + this.m_encoding);
        sb.append(SystemUtil.lineSeparator);
        sb.append("  contextPath: " + this.m_contextPath);
        sb.append(SystemUtil.lineSeparator);
        sb.append("  committed: " + this.m_committed);
        sb.append(SystemUtil.lineSeparator);
        sb.append("  error: " + this.m_error);
        sb.append(SystemUtil.lineSeparator);
        sb.append("  message: " + this.m_message);
        sb.append(SystemUtil.lineSeparator);
        sb.append("  status: " + this.m_status);
        sb.append(SystemUtil.lineSeparator);
        sb.append("  included: " + this.m_included);
        sb.append(SystemUtil.lineSeparator);
        sb.append("  info: com.cognos.dispatcherJSP.servlet.StandaloneHttpServletResponse/1.0");
        sb.append(SystemUtil.lineSeparator);
        sb.append("  HEADERS:");
        sb.append(SystemUtil.lineSeparator);
        Maps.mapToSB(sb, 2, false, this.m_headers);
        sb.append(SystemUtil.lineSeparator);
        sb.append(SystemUtil.lineSeparator);
        sb.append("  COOKIES:");
        sb.append(SystemUtil.lineSeparator);
        this.cookiesToSB(sb, 2, false);
        sb.append(SystemUtil.lineSeparator);
        sb.append("  locale: " + this.m_locale);
        sb.append(SystemUtil.lineSeparator);
        sb.append("  OUTPUT STREAM: ");
        sb.append(SystemUtil.lineSeparator);
        sb.append(this.m_outputStream);
        sb.append(SystemUtil.lineSeparator);
        sb.append("  ORIGINAL REQUEST: ");
        sb.append(SystemUtil.lineSeparator);
        sb.append(this.m_request);
        sb.append(SystemUtil.lineSeparator);
        return sb.toString();
    }

    public static String parseCharacterEncoding(String contentType) {
        if (contentType == null) {
            return null;
        }
        int start = contentType.indexOf("charset=");
        if (start < 0) {
            return null;
        }
        String encoding = contentType.substring(start + 8);
        int end = encoding.indexOf(59);
        if (end >= 0) {
            encoding = encoding.substring(0, end);
        }
        if ((encoding = encoding.trim()).length() > 2 && encoding.startsWith("\"") && encoding.endsWith("\"")) {
            encoding = encoding.substring(1, encoding.length() - 1);
        }
        return encoding.trim();
    }

    public void setCharacterEncoding(String arg0) {
    }
}

