/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.util;

import com.cognos.dispatcherJSP.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class Arrays {
    public static String[] arrayListToStringArray(ArrayList arrayList) {
        if (arrayList == null) {
            return null;
        }
        int size = arrayList.size();
        if (size <= 0) {
            return new String[0];
        }
        String[] returnArray = new String[size];
        arrayList.toArray(returnArray);
        return returnArray;
    }

    public static String[] objectArrayToStringArray(Object[] objArr) {
        if (objArr == null) {
            return new String[0];
        }
        int len = objArr.length;
        if (len == 0) {
            return new String[0];
        }
        String[] array = new String[len];
        for (int i = 0; i < len; ++i) {
            array[i] = (String)objArr[i];
        }
        return array;
    }

    public static int[] integerArrayToIntArray(Object[] integers) {
        if (integers == null) {
            return new int[0];
        }
        int len = integers.length;
        if (len == 0) {
            return new int[0];
        }
        int[] array = new int[len];
        for (int i = 0; i < len; ++i) {
            array[i] = (Integer)integers[i];
        }
        return array;
    }

    public static void arrayToSB(StringBuffer sb, int nIndent, boolean bNewLine, Object[] values) {
        Arrays.nameValueArraysToSB(sb, null, values, true, bNewLine, nIndent);
    }

    public static String booleanArrayToString(boolean[] values) {
        if (values == null) {
            return "<null_array>";
        }
        int len = values.length;
        if (len == 0) {
            return "[]";
        }
        String string = "[ ";
        for (int i = 0; i < len; ++i) {
            string = string + values[i] + " ";
        }
        return string + "]";
    }

    public static String arrayToString(Object[] values) {
        return Arrays.nameValueArraysToString(null, values, true, true);
    }

    public static String byteArrayToString(byte[] values) {
        return Arrays.byteArrayToString(values, -1);
    }

    public static String byteArrayToString(byte[] values, int showLen) {
        return Arrays.byteArrayToString(values, 0, -1);
    }

    public static String byteArrayToString(byte[] values, int startIndex, int showLen) {
        int maxLen;
        if (values == null) {
            return "<null_array>";
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        int len = maxLen = values.length;
        if (showLen >= 0) {
            len = showLen;
        }
        if ((len += startIndex) > maxLen) {
            len = maxLen;
        }
        if (startIndex >= len) {
            return "[error startindex(" + startIndex + ") exceeds maximum valid index (" + (len - 1) + ")]";
        }
        if (len == 0) {
            return "[]";
        }
        String string = "[ ";
        for (int i = startIndex; i < len; ++i) {
            string = string + (char)values[i];
        }
        return string + "]" + (showLen > 0 ? " - limited to (" + showLen + ") bytes" : "");
    }

    public static String stringArrayToSqlList(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int len = stringArray.length;
        if (len == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer(len * 5 + 5);
        String string = null;
        sb.append("(");
        for (int i = 0; i < len; ++i) {
            string = stringArray[i];
            if (string == null) continue;
            sb.append("'");
            sb.append(string);
            sb.append("'");
            if (i >= len - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public static void debugArray(Object[] values) {
        String string = Arrays.nameValueArraysToString(null, values, true, true);
        System.out.println("Array: " + string);
    }

    public static String nameValueArraysToString(Object[] names, Object[] values, boolean showNulls, boolean breakLines) {
        StringBuffer sb = new StringBuffer(800);
        Arrays.nameValueArraysToSB(sb, names, values, showNulls, breakLines, 0);
        String sRet = sb.toString();
        return sRet;
    }

    public static void nameValueArraysToSB(StringBuffer sb, Object[] names, Object[] values, boolean showNulls, boolean breakLines, int nIndent) {
        int nNextIndent = nIndent + 1;
        boolean bShowNames = false;
        boolean array = true;
        String prefix = "[";
        String suffix = "]";
        if (names != null) {
            prefix = "{";
            suffix = "}";
            array = false;
            bShowNames = true;
        }
        sb.append(prefix);
        if (values == null) {
            sb.append(array ? "<null_array>" : "<null_values_array>");
            sb.append(suffix);
            return;
        }
        int numValues = values.length;
        if (names != null) {
            int numNames = names.length;
            if (numNames != 0) {
                if (numNames != numValues) {
                    sb.append("<Mismatched sizes on names and values arrays>");
                    sb.append(suffix);
                    return;
                }
            } else {
                names = null;
            }
        }
        int count = 0;
        for (int i = 0; i < numValues; ++i) {
            if (numValues > 1) {
                StringUtils.indentToSB(sb, nIndent, breakLines);
            }
            Object name = null;
            Object value = null;
            if (names != null) {
                name = names[i];
            }
            if ((value = values[i]) == null) {
                if (name != null) {
                    sb.append(name);
                    sb.append("=<null>");
                } else {
                    sb.append("<null>");
                }
                if (i >= numValues - 1 || breakLines) continue;
                sb.append(", ");
                continue;
            }
            if (value instanceof Object[]) {
                if (name != null) {
                    sb.append(name);
                    sb.append("=");
                }
                Arrays.nameValueArraysToSB(sb, null, (Object[])value, showNulls, breakLines, nNextIndent);
            } else {
                String sName = null;
                if (name != null) {
                    sName = name.toString();
                }
                String sValue = null;
                if (value != null) {
                    sValue = value.toString();
                }
                StringUtils.valueToSB(sb, sName, sValue);
            }
            ++count;
        }
        if (numValues > 1) {
            StringUtils.indentToSB(sb, nIndent - 1, breakLines);
        }
        sb.append(suffix);
    }

    public static String[] vectorToStringArray(Vector vector) {
        if (vector == null) {
            return new String[0];
        }
        Object element = null;
        int count = vector.size();
        String[] stringValues = new String[count];
        String stringValue = null;
        for (int i = 0; i < count; ++i) {
            element = vector.get(0);
            stringValue = element == null ? null : String.valueOf(element);
            stringValues[i] = stringValue;
        }
        return stringValues;
    }

    public static int[] makeIntArray(String commaSeparatedNumbers) {
        StringTokenizer tokens = new StringTokenizer(commaSeparatedNumbers, ",");
        int[] numbers = new int[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            numbers[i] = Integer.parseInt(tokens.nextToken());
            ++i;
        }
        return numbers;
    }

    public static String[] stringToStringArray(String listString, String separator) throws Exception {
        ArrayList<String> al = new ArrayList<String>();
        int next = 0;
        int first = listString.indexOf(separator);
        try {
            if (first == -1) {
                al.add(listString);
            } else {
                if (first > 0) {
                    al.add(listString.substring(0, first));
                }
                while (first >= 0) {
                    String s = null;
                    next = listString.indexOf(separator, first + 1);
                    s = next > -1 ? listString.substring(first + 1, next) : listString.substring(first + 1);
                    first = next;
                    al.add(s.trim());
                }
            }
        }
        catch (Exception s) {
            // empty catch block
        }
        String[] strArray = new String[al.size()];
        Iterator it = al.iterator();
        int i = 0;
        while (it.hasNext()) {
            strArray[i++] = ((String)it.next()).trim();
        }
        return strArray;
    }
}

