/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class BaseXMLDocument {
    protected Document _document = null;
    protected Element _root = null;
    protected String _documentPath = null;

    public BaseXMLDocument(String documentPath) throws FileNotFoundException, DocumentException, IOException {
        if (documentPath == null) {
            throw new FileNotFoundException("Document path cannot be null");
        }
        this._documentPath = documentPath;
        if (this._document == null) {
            this._document = BaseXMLDocument.loadDocument(this._documentPath);
        }
        if (this._document == null) {
            throw new DocumentException("Couldn't create the Document");
        }
        this._root = this._document.getRootElement();
    }

    protected Document getDocument() {
        return this._document;
    }

    protected Element getDocumentRoot() {
        return this._root;
    }

    public String getDocumentPath() {
        return this._documentPath;
    }

    protected Element getChild(String name) {
        if (name == null) {
            return null;
        }
        return this._root.element(name);
    }

    protected static Document loadDocument(String documentPath) throws FileNotFoundException, DocumentException, IOException {
        if (documentPath == null) {
            throw new FileNotFoundException("Null document path specification");
        }
        File file = new File(documentPath);
        if (!file.exists()) {
            throw new FileNotFoundException("Cannot find file: " + documentPath);
        }
        SAXReader builder = new SAXReader();
        try {
            builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            return builder.read(file);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected String getElementString(Element element, String tag, String childTag) throws DocumentException {
        Element childElement = element.element(childTag);
        if (childElement == null) {
            throw new DocumentException("The <" + tag + "> tag is missing the <" + childTag + "> child tag.");
        }
        String childElementValue = childElement.getText();
        if (childElementValue == null || childElementValue.trim().length() <= 0) {
            throw new DocumentException("The <" + tag + "> tag has a <" + childTag + "> tag with a missing or empty value.");
        }
        return childElementValue;
    }

    protected boolean getElementBoolean(Element element, String tag, String childTag) throws DocumentException {
        String childElementValue = this.getElementString(element, tag, childTag);
        return childElementValue.equalsIgnoreCase("true");
    }

    protected int getElementInt(Element element, String tag, String childTag) throws DocumentException {
        int i = 0;
        try {
            i = Integer.parseInt(this.getElementString(element, tag, childTag));
        }
        catch (NumberFormatException n) {
            throw new DocumentException("The <" + tag + "> tag has a <" + childTag + "> tag that is not a valid integer.");
        }
        return i;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Parameter, <filename>, is required.");
            return;
        }
        BaseXMLDocument baseDoc = new BaseXMLDocument(args[0]);
        Element pages = baseDoc.getChild("pages");
        System.out.println("pages  is " + pages);
    }
}

