/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.util;

import com.cognos.dispatcherJSP.util.DateUtils;
import com.cognos.dispatcherJSP.util.StringUtils;
import com.cognos.dispatcherJSP.util.SystemUtil;
import java.text.FieldPosition;
import java.util.Date;
import javax.servlet.http.Cookie;

public class CookieUtils {
    private static final String SPECIAL_CHARS = "()<>@,;:\\\"/[]?={} \t";

    public static String getCookieHeaderName(Cookie cookie) {
        int version = cookie.getVersion();
        if (version == 1) {
            return "Set-Cookie2";
        }
        return "Set-Cookie";
    }

    public static String getCookieHeaderValue(Cookie cookie) {
        StringBuffer buf = new StringBuffer();
        CookieUtils.getCookieHeaderValue(cookie, buf);
        return buf.toString();
    }

    public static void getCookieHeaderValue(Cookie cookie, StringBuffer buf) {
        String value;
        int version = cookie.getVersion();
        String name = cookie.getName();
        if (name == null) {
            name = "";
        }
        if ((value = cookie.getValue()) == null) {
            value = "";
        }
        buf.append(name);
        buf.append("=");
        CookieUtils.appendAndQuote(version, buf, value);
        if (version == 1) {
            buf.append("; Version=1");
            if (cookie.getComment() != null) {
                buf.append("; Comment=");
                CookieUtils.appendAndQuote(version, buf, cookie.getComment());
            }
        }
        if (cookie.getDomain() != null) {
            buf.append("; Domain=");
            CookieUtils.appendAndQuote(version, buf, cookie.getDomain());
        }
        if (cookie.getMaxAge() >= 0) {
            if (version == 0) {
                buf.append("; Expires=");
                if (cookie.getMaxAge() == 0) {
                    DateUtils.oldCookieFormat.format(new Date(10000L), buf, new FieldPosition(0));
                } else {
                    DateUtils.oldCookieFormat.format(new Date(System.currentTimeMillis() + (long)cookie.getMaxAge() * 1000L), buf, new FieldPosition(0));
                }
            } else {
                buf.append("; Max-Age=");
                buf.append(cookie.getMaxAge());
            }
        } else if (version == 1) {
            buf.append("; Discard");
        }
        if (cookie.getPath() != null) {
            buf.append("; Path=");
            CookieUtils.appendAndQuote(version, buf, cookie.getPath());
        }
        if (cookie.getSecure()) {
            buf.append("; Secure");
        }
    }

    private static boolean isToken(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && SPECIAL_CHARS.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    protected static void appendAndQuote(int version, StringBuffer buf, String value) {
        if (version == 0 || CookieUtils.isToken(value)) {
            buf.append(value);
        } else {
            buf.append('\"');
            buf.append(value);
            buf.append('\"');
        }
    }

    public static String cookieToString(Cookie cookie) {
        StringBuffer buf = new StringBuffer(120);
        CookieUtils.cookieToSB(cookie, buf, 0, false);
        return buf.toString();
    }

    public static String cookieToString(Cookie cookie, int indent, boolean newLine) {
        StringBuffer buf = new StringBuffer(120);
        CookieUtils.cookieToSB(cookie, buf, indent, newLine);
        return buf.toString();
    }

    public static void cookieToSB(Cookie cookie, StringBuffer buf, int indent, boolean newLine) {
        if (buf == null) {
            return;
        }
        StringUtils.indentToSB(buf, indent, newLine);
        if (cookie == null) {
            buf.append("<null Cookie>");
            return;
        }
        buf.append("NAME: ");
        buf.append(cookie.getName());
        buf.append(SystemUtil.lineSeparator);
        StringUtils.indentToSB(buf, indent, false);
        buf.append("Value: ");
        buf.append(cookie.getValue());
        buf.append(SystemUtil.lineSeparator);
        StringUtils.indentToSB(buf, indent, false);
        buf.append("Comment: ");
        buf.append(cookie.getComment());
        buf.append(SystemUtil.lineSeparator);
        StringUtils.indentToSB(buf, indent, false);
        buf.append("Domain: ");
        buf.append(cookie.getDomain());
        buf.append(SystemUtil.lineSeparator);
        StringUtils.indentToSB(buf, indent, false);
        buf.append("MaxAge: ");
        buf.append(cookie.getMaxAge());
        buf.append(SystemUtil.lineSeparator);
        StringUtils.indentToSB(buf, indent, false);
        buf.append("Path: ");
        buf.append(cookie.getPath());
        buf.append(SystemUtil.lineSeparator);
        StringUtils.indentToSB(buf, indent, false);
        buf.append("Secure: ");
        buf.append(cookie.getSecure());
        buf.append(SystemUtil.lineSeparator);
        StringUtils.indentToSB(buf, indent, false);
        buf.append("Version: ");
        buf.append(cookie.getVersion());
        buf.append(SystemUtil.lineSeparator);
        StringUtils.indentToSB(buf, indent, false);
        buf.append("Reconstructed cookie header: ");
        CookieUtils.getCookieHeaderValue(cookie, buf);
        buf.append(SystemUtil.lineSeparator);
    }
}

