/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    public static final Locale LOCALE_US = Locale.US;
    public static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    public static final String RFC1123_PATTERN = "EEE, dd MMM yyyyy HH:mm:ss z";
    private static final String rfc1036Pattern = "EEEEEEEEE, dd-MMM-yy HH:mm:ss z";
    private static final String asctimePattern = "EEE MMM d HH:mm:ss yyyyy";
    public static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    public static final DateFormat rfc1123Format = new SimpleDateFormat("EEE, dd MMM yyyyy HH:mm:ss z", LOCALE_US);
    public static final DateFormat oldCookieFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", LOCALE_US);
    public static final DateFormat rfc1036Format = new SimpleDateFormat("EEEEEEEEE, dd-MMM-yy HH:mm:ss z", LOCALE_US);
    public static final DateFormat asctimeFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyyy", LOCALE_US);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateUtils() {
        DateFormat dateFormat = rfc1123Format;
        synchronized (dateFormat) {
            rfc1123Format.setTimeZone(GMT_ZONE);
        }
        dateFormat = oldCookieFormat;
        synchronized (dateFormat) {
            oldCookieFormat.setTimeZone(GMT_ZONE);
        }
        dateFormat = rfc1036Format;
        synchronized (dateFormat) {
            rfc1036Format.setTimeZone(GMT_ZONE);
        }
        dateFormat = asctimeFormat;
        synchronized (dateFormat) {
            asctimeFormat.setTimeZone(GMT_ZONE);
        }
    }

    public static Date jdbcDateStringToDate(Calendar calendar, String jdbcDateString) {
        if (calendar == null) {
            throw new IllegalArgumentException("Null parameter.");
        }
        if (jdbcDateString == null) {
            return null;
        }
        int firstDash = -1;
        int secondDash = -1;
        int space = -1;
        int firstColon = -1;
        firstDash = jdbcDateString.indexOf(45);
        if (firstDash > 0) {
            secondDash = jdbcDateString.indexOf(45, firstDash + 1);
        }
        if (secondDash > 0) {
            space = jdbcDateString.indexOf(32, secondDash + 1);
        }
        if (space > 0) {
            firstColon = jdbcDateString.indexOf(58, space + 1);
        }
        int length = jdbcDateString.length();
        if (firstDash <= 0 || secondDash <= 0 || secondDash >= length - 1) {
            throw new IllegalArgumentException("input jdbcDateString (" + jdbcDateString + ") must be of format (yyyy-mm-dd hh:mm:ss.milliseconds)");
        }
        int year = Integer.parseInt(jdbcDateString.substring(0, firstDash));
        int month = Integer.parseInt(jdbcDateString.substring(firstDash + 1, secondDash)) - 1;
        int day = space > 0 ? Integer.parseInt(jdbcDateString.substring(secondDash + 1, space)) : Integer.parseInt(jdbcDateString.substring(secondDash + 1));
        if (firstColon > 0) {
            int secondColon = jdbcDateString.indexOf(58, firstColon + 1);
            int dot = -1;
            if (secondColon > 0) {
                dot = jdbcDateString.indexOf(46, secondColon + 1);
            }
            if (secondColon <= 0 || secondColon >= length - 1) {
                throw new IllegalArgumentException("input jdbcDateString (" + jdbcDateString + ") must be of format (yyyy-mm-dd hh:mm:ss.milliseconds)");
            }
            int hours = Integer.parseInt(jdbcDateString.substring(space + 1, firstColon));
            int minutes = Integer.parseInt(jdbcDateString.substring(firstColon + 1, secondColon));
            int seconds = dot > 0 ? Integer.parseInt(jdbcDateString.substring(secondColon + 1, dot)) : Integer.parseInt(jdbcDateString.substring(secondColon + 1));
            calendar.set(year, month, day, hours, minutes, seconds);
        } else {
            calendar.set(year, month, day);
        }
        return calendar.getTime();
    }

    public class ConvertFormat {
        private SimpleDateFormat sourceForm;
        private SimpleDateFormat targetForm;
        public Date date = new Date();

        public ConvertFormat(String sourceFormat, String targetFormat) {
            this.sourceForm = new SimpleDateFormat(sourceFormat);
            this.sourceForm.setTimeZone(TimeZone.getDefault());
            this.targetForm = new SimpleDateFormat(targetFormat);
            this.targetForm.setTimeZone(TimeZone.getDefault());
        }

        Date getDate() {
            return this.date;
        }

        public String toTarget() {
            return this.targetForm.format(this.date);
        }

        public String toSource() {
            return this.sourceForm.format(this.date);
        }

        public String sourceToTarget(Date date) throws Exception {
            if (date == null) {
                return "";
            }
            return this.targetForm.format(date);
        }

        public String targetToSource(java.sql.Date date) throws Exception {
            return this.sourceForm.format(date);
        }
    }
}

