/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.util;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.dispatcherJSP.util.Arrays;
import com.cognos.dispatcherJSP.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Maps {
    public static String mapToString(Map map) {
        return Maps.mapToString(map, true);
    }

    public static void mapToSB(StringBuffer sb, int nIndent, boolean bNewLine, Map map) {
        if (map == null) {
            sb.append("<null map>");
            return;
        }
        int size = map.size();
        if (size == 0) {
            sb.append("{ <empty map> }");
            return;
        }
        Set keySet = map.keySet();
        Iterator<Object> iter = keySet.iterator();
        Object[] names = new String[size];
        Object key = null;
        Integer integer = null;
        int i = 0;
        while (iter.hasNext()) {
            key = iter.next();
            try {
                names[i] = key;
            }
            catch (ClassCastException e) {
                integer = key;
                names[i] = String.valueOf(integer);
            }
            ++i;
        }
        Collection collect = map.values();
        iter = collect.iterator();
        Object[] values = new Object[size];
        int i2 = 0;
        while (iter.hasNext()) {
            values[i2] = iter.next();
            ++i2;
        }
        Arrays.nameValueArraysToSB(sb, names, values, true, bNewLine, nIndent);
    }

    public static String mapToString(Map map, boolean breakLines) {
        StringBuffer sb = new StringBuffer(500);
        Maps.mapToSB(sb, 0, breakLines, map);
        String s = sb.toString();
        return s;
    }

    public static String mapKeysToString(Map map) {
        StringBuffer sb = new StringBuffer(500);
        Maps.mapKeysToSB(sb, 0, true, map);
        String s = sb.toString();
        return s;
    }

    public static void mapKeysToSB(StringBuffer sb, int nIndent, boolean bNewLine, Map map) {
        if (map == null) {
            sb.append("<null map>");
            return;
        }
        int size = map.size();
        if (size == 0) {
            sb.append("{ <empty map> }");
            return;
        }
        Set keySet = map.keySet();
        Iterator iter = keySet.iterator();
        Object[] names = new String[size];
        int i = 0;
        while (iter.hasNext()) {
            names[i] = (String)iter.next();
            ++i;
        }
        sb.append("{");
        StringUtils.indentToSB(sb, nIndent, bNewLine);
        Arrays.arrayToSB(sb, nIndent, bNewLine, names);
        sb.append("}");
    }

    public static Object[] mapKeysToArray(Map map) {
        if (map == null) {
            return new Object[0];
        }
        int size = map.size();
        if (size == 0) {
            return new Object[0];
        }
        Object[] array = new Object[size];
        Set keys = map.keySet();
        Iterator iter = keys.iterator();
        int i = 0;
        while (iter.hasNext()) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }

    public static String[] mapKeysToStringArray(Map map) {
        if (map == null) {
            return new String[0];
        }
        int size = map.size();
        if (size == 0) {
            return new String[0];
        }
        String[] array = new String[size];
        Set keys = map.keySet();
        Iterator iter = keys.iterator();
        int index = 0;
        try {
            while (iter.hasNext()) {
                array[index] = (String)iter.next();
                ++index;
            }
        }
        catch (ClassCastException e) {
            throw new CCLRuntimeException("Map key at index '" + index + "' is not of type String. Use mapKeysToArray()");
        }
        return array;
    }

    public static Object[] mapValuesToArray(Map map) {
        if (map == null) {
            return new Object[0];
        }
        int size = map.size();
        if (size == 0) {
            return new Object[0];
        }
        Object[] array = new Object[size];
        Collection values = map.values();
        Iterator iter = values.iterator();
        int i = 0;
        while (iter.hasNext()) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }

    public static String mapValuesToString(Map map) {
        if (map == null) {
            return "Null map.";
        }
        int size = map.size();
        if (size == 0) {
            return "Empty map.";
        }
        Collection collect = map.values();
        Iterator iter = collect.iterator();
        Object[] values = new Object[size];
        int i = 0;
        while (iter.hasNext()) {
            values[i] = iter.next();
            ++i;
        }
        return Arrays.arrayToString(values) + " - (Not in order!)";
    }

    public static Object findKeyWhoseValueMatchesIntValue(Map map, int intValue) {
        if (map == null) {
            return null;
        }
        int size = map.size();
        if (size == 0) {
            return null;
        }
        Object[] valuesArr = Maps.mapValuesToArray(map);
        int[] intArr = Arrays.integerArrayToIntArray(valuesArr);
        Object[] keyArr = Maps.mapKeysToArray(map);
        for (int i = 0; i < size; ++i) {
            if (intArr[i] != intValue) continue;
            return keyArr[i];
        }
        return null;
    }

    public static void addMapToMap(HashMap targetMap, HashMap addMap, boolean replaceDuplicates) throws Exception {
        if (targetMap == null || addMap == null) {
            return;
        }
        Set keySet = addMap.keySet();
        Iterator iter = keySet.iterator();
        Object key = null;
        Object prevValue = null;
        int i = 0;
        while (iter.hasNext()) {
            key = iter.next();
            prevValue = targetMap.put(key, addMap.get(key));
            if (!replaceDuplicates && prevValue != null) {
                throw new Exception("addMapToMap: Cannot override an existing non-null value for key (" + key + "), unless the replaceDuplicates parameter is set to true.");
            }
            ++i;
        }
    }

    public static void verifyStringMap(HashMap map, String[] allowedKeysArray, String[][] allowedValuesArrays, String keyErrorMessage, String keyAlias, String valueErrorMessage) {
        if (map == null) {
            return;
        }
        if (keyErrorMessage == null || keyErrorMessage.trim().length() <= 0) {
            keyErrorMessage = "Invalid key of";
        }
        if (keyAlias == null) {
            keyAlias = "key";
        }
        if (valueErrorMessage == null || valueErrorMessage.trim().length() <= 0) {
            valueErrorMessage = "Invalid value of";
        }
        Set keys = map.keySet();
        Iterator iter = keys.iterator();
        String key = null;
        String allowedKey = null;
        String value = null;
        String allowedValue = null;
        Object[] allowedValuesArray = null;
        int allowedValuesArrayLen = 0;
        boolean allowed = false;
        int allowedKeysLen = 0;
        int allowedValuesArraysLen = 0;
        if (allowedKeysArray != null) {
            allowedKeysLen = allowedKeysArray.length;
        }
        if (allowedValuesArrays != null && (allowedValuesArraysLen = allowedValuesArrays.length) != allowedKeysLen) {
            throw new CCLRuntimeException("The 'allowedKeysArray' array contains '" + allowedKeysLen + "' elements but the 'allowValues' array contains '" + allowedValuesArraysLen + "' elements - they must match if they are both specified.");
        }
        int i = 0;
        while (iter.hasNext()) {
            key = (String)iter.next();
            if (key != null) {
                if (allowedKeysLen <= 0) {
                    throw new CCLRuntimeException(keyErrorMessage + " '" + key + "'. No values are allowed.");
                }
                allowed = false;
                for (int j = 0; j < allowedKeysLen; ++j) {
                    allowedKey = allowedKeysArray[j];
                    if (allowedKey == null || !key.equalsIgnoreCase(allowedKey)) continue;
                    allowed = true;
                    allowedValuesArray = allowedValuesArrays[j];
                    if (allowedValuesArray == null) break;
                    allowedValuesArrayLen = allowedValuesArray.length;
                    value = (String)map.get(key);
                    if (value == null) {
                        throw new CCLRuntimeException(valueErrorMessage + " null for " + keyAlias + " '" + key + "'. Must be one of: " + Arrays.arrayToString(allowedValuesArray));
                    }
                    allowed = false;
                    for (int k = 0; k < allowedValuesArrayLen; ++k) {
                        if (allowedValuesArrayLen <= 0) {
                            throw new CCLRuntimeException(valueErrorMessage + " '" + value + "'. No values are allowed for " + keyAlias + " '" + key + "'");
                        }
                        allowedValue = allowedValuesArray[k];
                        if (allowedValue == null || !value.equalsIgnoreCase(allowedValue)) continue;
                        allowed = true;
                        break;
                    }
                    if (allowed) break;
                    throw new CCLRuntimeException(valueErrorMessage + " '" + value + "' for " + keyAlias + " '" + key + "'. Must be one of: " + Arrays.arrayToString(allowedValuesArray));
                }
                if (!allowed) {
                    throw new CCLRuntimeException(keyErrorMessage + " '" + key + "'. Must be one of: " + Arrays.arrayToString(allowedKeysArray));
                }
            }
            ++i;
        }
    }
}

