/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.util;

import com.cognos.ccl4j.diagnostics.CCLCheck;
import com.cognos.ccl4j.exceptions.CCLException;
import com.cognos.ccl4j.util.CCLStringUtils;
import com.cognos.dispatcherJSP.util.SystemUtil;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtils {
    public static boolean isAscii(String string) {
        char[] chars = new char[string.length()];
        boolean isAscii = true;
        string.getChars(0, string.length(), chars, 0);
        for (int i = 0; isAscii && i < chars.length; ++i) {
            if (chars[i] <= '\u007f' && chars[i] >= '\u0000') continue;
            isAscii = false;
        }
        return isAscii;
    }

    public static String getSafeCRNParamVal(Object objValue, String name) {
        String retVal = null;
        String value = null;
        String[] sUnaccepted = new String[]{"ticket", "passport", "password", "pwd"};
        try {
            value = objValue instanceof String ? (String)objValue : objValue.toString();
            if (name != null && name.length() > 0) {
                retVal = StringUtils.checkName(sUnaccepted, value, name);
            }
            if (retVal == null || retVal.equalsIgnoreCase(value)) {
                retVal = StringUtils.checkValue(sUnaccepted, value);
            }
        }
        catch (Exception e) {
            retVal = null;
        }
        return retVal;
    }

    private static String checkName(String[] sUnaccepted, String oldVal, String name) {
        String newVal = null;
        for (int i = 0; i < sUnaccepted.length; ++i) {
            String item = sUnaccepted[i];
            if (name.toLowerCase().indexOf(item) <= -1) continue;
            newVal = "xxx";
            break;
        }
        if (newVal == null && oldVal != null) {
            newVal = oldVal;
        }
        return newVal;
    }

    private static String checkValue(String[] sUnaccepted, String oldVal) {
        String newVal = null;
        String tempVal = oldVal;
        for (int i = 0; i < sUnaccepted.length; ++i) {
            String item = sUnaccepted[i];
            if (item.equalsIgnoreCase(tempVal)) {
                newVal = "xxx";
                break;
            }
            StringBuffer sb = new StringBuffer("");
            int pos = 0;
            int start_pos = 0;
            int last_pos = 0;
            do {
                if ((pos = tempVal.toLowerCase().indexOf(item, start_pos)) > -1) {
                    start_pos = pos + item.length();
                    sb.append(tempVal.substring(last_pos, start_pos));
                    if (tempVal.charAt(start_pos) == ' ') {
                        ++start_pos;
                    }
                    if (tempVal.charAt(start_pos) == '=') {
                        sb.append("=");
                        ++start_pos;
                    }
                    if (tempVal.charAt(start_pos) == ' ') {
                        ++start_pos;
                    }
                    int temp1 = tempVal.indexOf(",", start_pos);
                    int temp2 = tempVal.indexOf(";", start_pos);
                    int temp3 = tempVal.indexOf(" ", start_pos);
                    int min = -1;
                    if (temp1 > -1) {
                        min = temp1;
                    }
                    if (temp2 > -1 && min > -1 && temp2 < min) {
                        min = temp2;
                    } else if (temp2 > -1 && min == -1) {
                        min = temp2;
                    }
                    if (temp3 > -1 && min > -1 && temp3 < min) {
                        min = temp3;
                    } else if (temp3 > -1 && min == -1) {
                        min = temp3;
                    }
                    if (min > start_pos) {
                        last_pos = min;
                        sb.append("xxx");
                        start_pos = last_pos + 1;
                        if (start_pos >= tempVal.length()) continue;
                        sb.append(tempVal.charAt(last_pos));
                        continue;
                    }
                    sb.append("xxx");
                    continue;
                }
                sb.append(tempVal.substring(start_pos));
            } while (pos > -1);
            tempVal = sb.toString();
        }
        newVal = tempVal;
        return newVal;
    }

    public static String enumerationToString(Enumeration enumParam) {
        if (enumParam == null) {
            return "<null_enumeration>";
        }
        Object elem = null;
        String retStr = "{ ";
        boolean firstElement = true;
        while (enumParam.hasMoreElements()) {
            if (!firstElement) {
                retStr = retStr + ", ";
            }
            retStr = (elem = (Object)enumParam.nextElement()) == null ? retStr + "<null>" : retStr + elem.toString();
            firstElement = false;
        }
        retStr = retStr + " }";
        return retStr;
    }

    public static void _valueToSB(StringBuffer sb, String sName, String sValue, boolean bQuote) {
        if (sName != null) {
            sb.append(sName);
            sb.append("=");
        }
        if (sValue != null) {
            sb.append("'").append(sValue).append("'");
        } else {
            sb.append("<null>");
        }
    }

    public static String replaceStrings(String origStr, String[] oldStrs, String[] newStrs) {
        if (origStr == null || oldStrs == null || newStrs == null) {
            return origStr;
        }
        int origLen = origStr.length();
        if (origLen == 0) {
            return origStr;
        }
        int oldCount = oldStrs.length;
        int newCount = newStrs.length;
        if (oldCount == 0 || newCount == 0) {
            return origStr;
        }
        if (oldCount != newCount) {
            throw new IllegalArgumentException("Parameters 'oldStrs' and 'newStrs' must have the same number of elements");
        }
        String retStr = origStr;
        for (int i = 0; i < oldCount; ++i) {
            retStr = CCLStringUtils.replaceAll((String)retStr, (String)oldStrs[i], (String)newStrs[i]);
        }
        return retStr;
    }

    public static String getDelimitedString(String inputString, String startDelimiter, String endDelimiter) {
        if (startDelimiter == null) {
            throw new IllegalArgumentException("Null parameter.");
        }
        if (inputString == null) {
            return null;
        }
        int startIndex = inputString.indexOf(startDelimiter);
        int endIndex = -1;
        if (startIndex < 0) {
            return null;
        }
        if (endDelimiter != null) {
            endIndex = inputString.indexOf(endDelimiter, startIndex);
        }
        if (endIndex < 0) {
            return inputString.substring(startIndex);
        }
        return inputString.substring(startIndex, endIndex + 1);
    }

    public static void valueToSB(StringBuffer sb, String sName, boolean b) {
        StringUtils._valueToSB(sb, sName, b ? "true" : "false", false);
    }

    public static void valueToSB(StringBuffer sb, String sName, int n) {
        StringUtils._valueToSB(sb, sName, Integer.toString(n), false);
    }

    public static void valueToSB(StringBuffer sb, String sName, String sValue) {
        StringUtils._valueToSB(sb, sName, sValue == null ? "<null>" : sValue, sValue != null);
    }

    public static void indentToSB(StringBuffer sb, int nIndent, boolean bNewLine) {
        if (bNewLine) {
            sb.append(SystemUtil.lineSeparator);
        }
        if (nIndent > 0) {
            for (int i = 0; i < nIndent; ++i) {
                sb.append("  ");
            }
        }
    }

    public static Vector getValues(String strValues) {
        StringTokenizer strTokens = new StringTokenizer(strValues, ",");
        Vector<String> results = new Vector<String>();
        while (strTokens.hasMoreElements()) {
            String name = strTokens.nextToken();
            results.add(name);
        }
        return results;
    }

    public static String not_null(String strCheckme) {
        String EMPTY = "";
        return strCheckme == null ? EMPTY : strCheckme;
    }

    public static String not_null(String strCheckme, String strReturnMeIfNull) {
        String EMPTY = "";
        return strCheckme == null ? strReturnMeIfNull : strCheckme;
    }

    public static int extendedParseInt(String strNumber) {
        if (CCLCheck.isBadString((String)strNumber)) {
            return 0;
        }
        int iNumber = 0;
        try {
            iNumber = Integer.parseInt(strNumber);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return iNumber;
    }

    public static double extendedParseDouble(String strNumber) {
        double dRet = 0.0;
        if (strNumber != null && strNumber.length() > 0) {
            try {
                dRet = Double.parseDouble(strNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return dRet;
    }

    public static void addQueryItems(Iterator iter, StringBuffer buffer, int maxCount) {
        String listSep = "";
        for (int i = 0; i < maxCount && iter.hasNext(); ++i) {
            buffer.append(listSep).append(iter.next().toString());
            listSep = ",";
        }
    }

    public static String repeat(String strToRepeat, int count) throws CCLException {
        if (CCLCheck.isBadString((String)strToRepeat)) {
            throw new CCLException("String to repeat must be provided");
        }
        if (count <= 0) {
            throw new CCLException("Value for count must be >= 0");
        }
        StringBuffer rc = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            rc.append(strToRepeat);
        }
        return rc.toString();
    }

    public static String rightJustify(String strToPad, int newLength) throws CCLException {
        return StringUtils.rightJustify(strToPad, newLength, " ");
    }

    public static String rightJustify(String strToPad, int newLength, String strToPadWith) throws CCLException {
        if (CCLCheck.isBadString((String)strToPadWith)) {
            throw new CCLException("Padding string must be provided");
        }
        if (CCLCheck.isBadString((String)strToPad)) {
            throw new CCLException("Input string must be provided");
        }
        if (newLength < strToPad.length()) {
            return strToPad;
        }
        StringBuffer sb = new StringBuffer();
        int lenPadString = newLength - strToPad.length();
        String padding = StringUtils.repeat(strToPadWith, lenPadString);
        sb.append(padding.substring(0, lenPadString));
        sb.append(strToPad);
        return sb.toString();
    }

    public static String leftJustify(String strToPad, int newLength) throws CCLException {
        return StringUtils.leftJustify(strToPad, newLength, " ");
    }

    public static String leftJustify(String strToPad, int newLength, String strToPadWith) throws CCLException {
        if (CCLCheck.isBadString((String)strToPadWith)) {
            throw new CCLException("Padding string must be provided");
        }
        if (CCLCheck.isBadString((String)strToPad)) {
            throw new CCLException("Input string must be provided");
        }
        if (newLength < strToPad.length()) {
            return strToPad;
        }
        int lenPadString = newLength - strToPad.length();
        String padding = StringUtils.repeat(strToPadWith, lenPadString);
        StringBuffer sb = new StringBuffer(strToPad);
        sb.append(padding.substring(0, lenPadString));
        return sb.toString();
    }

    public static String center(String strToCenter, int lineSize) throws CCLException {
        if (CCLCheck.isBadString((String)strToCenter)) {
            throw new CCLException("String to be centered cannot be empty");
        }
        if (lineSize < 0) {
            throw new CCLException("Invalid linesize");
        }
        if (strToCenter == null || strToCenter.length() == 0) {
            return strToCenter;
        }
        int spacesToLeft = lineSize - strToCenter.length() / 2;
        return StringUtils.leftJustify(StringUtils.rightJustify(strToCenter, spacesToLeft, " "), lineSize, " ");
    }
}

