/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.util;

import com.cognos.dispatcherJSP.servlet.StandaloneHttpServletRequest;
import com.cognos.dispatcherJSP.util.Arrays;
import com.cognos.dispatcherJSP.util.Maps;
import com.cognos.dispatcherJSP.util.StringUtils;
import com.cognos.dispatcherJSP.util.SystemUtil;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class WebUtil {
    public static final String XML_EMPTY = "_empty_";
    public static final String XML_BLANK = "_";
    public static final String XML_NULL = "_null_";
    public static final String XML_INVALID = "_invalid_";
    public static final String XML_AMP = "&amp;";
    public static final String XML_LT = "&lt;";
    public static final String XML_GT = "&gt;";
    public static final String XML_EQ = "eq";
    public static final String XML_QUOT = "&quot;";
    public static final String XML_APOS = "&apos;";
    public static final String XML_PLUS = "_plus_";
    private static boolean _isOldServletAPI = false;

    public static void setOldServletAPI(boolean state) {
        _isOldServletAPI = state;
    }

    public static void debugRequest(HttpServletRequest request) {
        System.out.println("Request Parameters:" + SystemUtil.lineSeparator + WebUtil.requestToString(request));
    }

    public static String requestToString(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer(1000);
        WebUtil.requestToSB(sb, 0, true, request);
        String s = sb.toString();
        return s;
    }

    public static void requestToSB(StringBuffer sb, int nIndent, boolean bNewLine, HttpServletRequest request) {
        WebUtil.requestToSB(sb, nIndent, bNewLine, true, request);
    }

    public static void requestToSB(StringBuffer sb, int nIndent, boolean bNewLine, boolean bShowAttributes, HttpServletRequest request) {
        if (request == null) {
            sb.append("<null Request>");
        } else {
            String queryString = request.getQueryString();
            StringUtils.indentToSB(sb, nIndent, true);
            StringUtils.valueToSB(sb, "QUERY_STRING", queryString);
            boolean isOldServletAPI = _isOldServletAPI;
            Map paramMap = null;
            if (!isOldServletAPI) {
                paramMap = request.getParameterMap();
            } else {
                sb.append("<Cannot get the parameter map under Servlet API 2.2.>");
            }
            if (paramMap != null) {
                Enumeration attributes = request.getAttributeNames();
                boolean bHasParams = false;
                boolean bHasAttributes = false;
                if (paramMap != null && paramMap.size() > 0) {
                    bHasParams = true;
                }
                if (attributes != null && attributes.hasMoreElements()) {
                    bHasAttributes = true;
                }
                if (!bHasParams && !bHasAttributes) {
                    sb.append("<Request has no parameters and no attributes>");
                } else {
                    if (bHasParams) {
                        StringUtils.indentToSB(sb, nIndent, true);
                        sb.append("Parameters = ");
                        String params = Maps.mapToString(paramMap, bNewLine);
                        String secureParams = StringUtils.getSafeCRNParamVal(params, null);
                        sb.append(secureParams);
                    }
                    if (bHasAttributes) {
                        if (bHasParams) {
                            StringUtils.indentToSB(sb, nIndent, true);
                        }
                        if (bShowAttributes) {
                            String name = null;
                            ArrayList<String> names = new ArrayList<String>(20);
                            ArrayList<Object> values = new ArrayList<Object>(20);
                            sb.append("Attributes = ");
                            while (attributes.hasMoreElements()) {
                                name = (String)attributes.nextElement();
                                names.add(name);
                                String val = StringUtils.getSafeCRNParamVal(request.getAttribute(name), name);
                                if (val != null) {
                                    values.add(val);
                                    continue;
                                }
                                values.add(request.getAttribute(name));
                            }
                            Arrays.nameValueArraysToSB(sb, names.toArray(), values.toArray(), true, true, nIndent + 1);
                        } else {
                            sb.append("Attributes not shown as dictated by a parameter");
                        }
                    }
                    if (bNewLine) {
                        sb.append("\r\n");
                    }
                }
            }
        }
    }

    public static String getModifiedQueryString(HttpServletRequest request, String[] replaceParameters, String[] newParameters) {
        if (request == null) {
            return "";
        }
        String queryString = request.getQueryString();
        if (replaceParameters == null || newParameters == null) {
            return queryString;
        }
        int replaceCount = replaceParameters.length;
        if (replaceCount == 0) {
            return queryString;
        }
        int newCount = newParameters.length;
        if (replaceCount != newCount) {
            throw new IllegalArgumentException("parameter array size mismatch");
        }
        if (queryString.trim().length() == 0) {
            return queryString;
        }
        return null;
    }

    public static String headersToString(HttpServletRequest request) {
        if (request == null) {
            return "<null Request - no headers>";
        }
        int count = 0;
        String name = null;
        StringBuffer buf = new StringBuffer(2000);
        Enumeration headers = request.getHeaderNames();
        if (headers != null) {
            while (headers.hasMoreElements()) {
                if (request.getHeader(name) == null) continue;
                buf.append("Request Header (");
                name = (String)headers.nextElement();
                buf.append(name);
                buf.append(") is (");
                buf.append(request.getHeader(name));
                buf.append(")");
                buf.append(SystemUtil.lineSeparator);
                ++count;
            }
        }
        if (count == 0) {
            return "<no headers>";
        }
        return buf.toString();
    }

    public static String mapToQueryString(Map parameterMap) {
        return StandaloneHttpServletRequest.mapToQueryString(parameterMap);
    }

    public static Map queryStringToMap(String queryString) {
        return StandaloneHttpServletRequest.queryStringToParameterMap(queryString, null);
    }

    public static Map queryStringToMap(String queryString, String encoding) {
        return StandaloneHttpServletRequest.queryStringToParameterMap(queryString, encoding);
    }

    public static String removeURLAttribute(String URL2, String attrName) {
        int posStart = URL2.indexOf("&" + attrName);
        if (posStart < 0) {
            return URL2;
        }
        int posEnd = URL2.indexOf(38, posStart + 2);
        String returnURL = URL2.substring(0, posStart);
        if (posEnd >= 0) {
            returnURL = returnURL + URL2.substring(posEnd);
        }
        return returnURL;
    }

    public static String getURLAttribute(String URL2, String attrName) {
        int posStart = URL2.indexOf("&" + attrName);
        if (posStart < 0) {
            return null;
        }
        if ((posStart = URL2.indexOf(61, posStart + 1)) < 0) {
            return null;
        }
        int posEnd = URL2.indexOf(38, posStart + 2);
        if (posEnd < 0) {
            posEnd = URL2.length();
        }
        String returnVal = URL2.substring(posStart + 1, posEnd);
        return URLDecoder.decode(returnVal);
    }

    public static String xmlEncode(String inData) {
        return WebUtil.xmlEncode(inData, false);
    }

    public static String xmlEncode(String inData, boolean isTag) {
        if (inData == null) {
            return isTag ? XML_NULL : inData;
        }
        int length = inData.length();
        if (length == 0) {
            return isTag ? XML_BLANK : inData;
        }
        StringBuffer buffer = new StringBuffer(2 * length);
        char[] chars = inData.toCharArray();
        for (int i = 0; i < length; ++i) {
            char chr = chars[i];
            if (isTag) {
                if (chr == '_') {
                    buffer.append(chr);
                    continue;
                }
                if (chr == '+') {
                    buffer.append(XML_PLUS);
                    continue;
                }
                if (chr == ':') {
                    buffer.append(XML_BLANK);
                    continue;
                }
                if (chr == '=') {
                    buffer.append(XML_EQ);
                    continue;
                }
                if (Character.isWhitespace(chr)) {
                    buffer.append(XML_BLANK);
                    continue;
                }
                if (i == 0 && !Character.isLetter(chr)) {
                    buffer.append(XML_INVALID);
                    continue;
                }
                if (!Character.isLetterOrDigit(chr)) {
                    buffer.append(XML_INVALID);
                    continue;
                }
                buffer.append(chr);
                continue;
            }
            if (chr == '&') {
                buffer.append(XML_AMP);
                continue;
            }
            if (chr == '<') {
                buffer.append(XML_LT);
                continue;
            }
            if (chr == '>') {
                buffer.append(XML_GT);
                continue;
            }
            if (chr == '\"') {
                buffer.append(XML_QUOT);
                continue;
            }
            if (chr == '\'') {
                buffer.append(XML_APOS);
                continue;
            }
            buffer.append(chr);
        }
        return buffer.toString();
    }

    public static String cookiesToString(HttpServletRequest request) {
        if (request == null) {
            return "<null Request - no cookies>";
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return "<no cookies>";
        }
        int count = cookies.length;
        StringBuffer buf = new StringBuffer(500 * count);
        for (int i = 0; i < count; ++i) {
            buf.append(WebUtil.cookieToString(cookies[i]));
            buf.append(SystemUtil.lineSeparator);
        }
        return buf.toString();
    }

    public static String cookieToString(Cookie cookie) {
        if (cookie == null) {
            return "<null cookie>";
        }
        StringBuffer buf = new StringBuffer(500);
        buf.append("Cookie: name(");
        buf.append(cookie.getName());
        buf.append(") value(");
        buf.append(cookie.getValue());
        buf.append(") path(");
        buf.append(cookie.getPath());
        buf.append(") domain(");
        buf.append(cookie.getDomain() + ")");
        return buf.toString();
    }
}

