/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.view;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.dispatcherJSP.util.RuntimeInitializationParameters;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractView {
    protected String m_className = null;
    protected String m_classPath = null;
    protected String m_pid = null;

    public void initialize(RuntimeInitializationParameters parameters) {
        if (parameters != null) {
            this.m_className = parameters.m_className;
            this.m_pid = parameters.m_pid;
        }
        this.doInitialize(parameters);
        if (parameters != null) {
            try {
                this.m_classPath = parameters.m_className;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (ClassCastException e) {
                throw new CCLRuntimeException((Throwable)e, "View initialize: Expecting a 'classPath' of type 'String'");
            }
        }
    }

    protected void doInitialize(RuntimeInitializationParameters parameters) {
    }

    public void render(HttpServletRequest request, HttpServletResponse response, String pid) {
        Object context = null;
        try {
            context = this.getContext(request, response, pid);
        }
        catch (RuntimeException rt) {
            throw rt;
        }
        catch (Exception e) {
            throw new CCLRuntimeException((Throwable)e, "Obtaining view context");
        }
        try {
            this.doRender(context, request, response, pid);
        }
        catch (RuntimeException rt) {
            throw rt;
        }
        catch (Exception e) {
            throw new CCLRuntimeException((Throwable)e, "calling doRender method of the view class '" + this.m_className + "' for pid '" + pid + "'");
        }
    }

    protected abstract void doRender(Object var1, HttpServletRequest var2, HttpServletResponse var3, String var4) throws IOException;

    protected Object getContext(HttpServletRequest request, HttpServletResponse response, String pid) {
        return null;
    }

    protected void setResponseContentType(Object context, HttpServletResponse response, String sHeader) {
        if (sHeader != null) {
            response.setContentType(sHeader);
        }
    }

    public String toString() {
        return this.m_className + " - (" + this.m_classPath + ")";
    }
}

