/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dispatcherJSP.view.views;

import com.cognos.ccl4j.diagnostics.CCLCheck;
import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.dispatcherJSP.jspc.JspcDispatcher;
import com.cognos.dispatcherJSP.jspc.JspcPageBase;
import com.cognos.dispatcherJSP.util.RuntimeInitializationParameters;
import com.cognos.dispatcherJSP.view.AbstractView;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSPView
extends AbstractView {
    private String m_jspPath = null;
    private ServletConfig m_servletConfig = null;
    private ServletContext m_servletContext = null;

    @Override
    protected void doInitialize(RuntimeInitializationParameters parameters) {
        if (parameters == null) {
            throw new CCLRuntimeException("JSPView doInitialize: Expecting a 'JSP Parameter Arraylist'");
        }
        this.m_jspPath = parameters.m_jspSourcePath;
        if (this.m_jspPath == null) {
            throw new CCLRuntimeException("JSPView doInitialize: Expecting a non-null 'JSP Path'");
        }
        this.m_servletConfig = parameters.m_servletConfig;
        if (this.m_servletConfig == null) {
            throw new CCLRuntimeException("JSPView doInitialize: Expecting a non-null 'ServletConfig");
        }
        this.m_servletContext = parameters.m_servletContext;
    }

    @Override
    protected void doRender(Object context, HttpServletRequest request, HttpServletResponse response, String pid) throws IOException {
        if (response == null || pid == null) {
            return;
        }
        JspcPageBase jspcPage = this.getJspcPageBaseFromContext(context);
        Object dispatcher = null;
        try {
            JspcDispatcher.dispatch(jspcPage, this.m_servletConfig, this.m_servletContext, request, response, this.m_jspPath);
        }
        catch (RuntimeException rt) {
            throw rt;
        }
        catch (Exception e) {
            throw new CCLRuntimeException((Throwable)e, "dispatching to jsp='" + this.m_jspPath + "', pid='" + pid + "'");
        }
    }

    @Override
    protected Object getContext(HttpServletRequest request, HttpServletResponse response, String pid) {
        JspcPageBase jspcPage = JspcDispatcher.getJspcPage(this.m_jspPath);
        return jspcPage;
    }

    protected void commitResponse(Object context, HttpServletRequest request, HttpServletResponse response) {
        JspcPageBase jspcPage = this.getJspcPageBaseFromContext(context);
        jspcPage.commitResponse();
    }

    private final JspcPageBase getJspcPageBaseFromContext(Object context) {
        CCLCheck.nonNull((Object)context);
        JspcPageBase jspcPage = null;
        if (!(context instanceof JspcPageBase)) {
            throw new CCLRuntimeException("JSPView requires JspcPageBase object as context, but recieved '" + context + "'");
        }
        jspcPage = (JspcPageBase)context;
        return jspcPage;
    }

    public final String getJSPPath() {
        return this.m_jspPath;
    }

    public final ServletConfig getServletConfig() {
        return this.m_servletConfig;
    }

    public final ServletContext getServletContext() {
        return this.m_servletContext;
    }
}

