/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.drill.utility;

import com.cognos.drill.utility.Value;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class C8FilterDOM {
    private Document c8FilterDoc = null;

    public C8FilterDOM() {
        DocumentBuilder builder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
            this.c8FilterDoc = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public Element createRootNodes() {
        Element esRoot = this.c8FilterDoc.createElementNS("http://developer.cognos.com/schemas/editSpecification/1/", "es:editSpecification");
        esRoot.setAttribute("xmlns:es", "http://developer.cognos.com/schemas/editSpecification/1/");
        esRoot.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.c8FilterDoc.appendChild(esRoot);
        return this.addChildElement(esRoot, "es:actions");
    }

    public Element createRootExpression(Element parent) {
        Element esFilter = this.addChildElement(parent, "es:filter");
        return this.addChildElement(esFilter, "es:expression");
    }

    public Element createANDOperator(Element esPredicate1, Element esPredicate2) {
        Element eOperator = this.c8FilterDoc.createElementNS("http://developer.cognos.com/schemas/editSpecification/1/", "es:operator");
        this.addChildElementAndContents(eOperator, "es:name", "operators#and");
        Element eArguments = this.addChildElement(eOperator, "es:arguments");
        Element eArgument1 = this.addChildElement(eArguments, "es:argument");
        Element eArgument2 = this.addChildElement(eArguments, "es:argument");
        eArgument1.appendChild(esPredicate1);
        eArgument2.appendChild(esPredicate2);
        return eOperator;
    }

    public Element createOROperator(Element esPredicate1, Element esPredicate2) {
        Element eOperator = this.c8FilterDoc.createElementNS("http://developer.cognos.com/schemas/editSpecification/1/", "es:operator");
        this.addChildElementAndContents(eOperator, "es:name", "operators#or");
        Element eArguments = this.addChildElement(eOperator, "es:arguments");
        Element eArgument1 = this.addChildElement(eArguments, "es:argument");
        Element eArgument2 = this.addChildElement(eArguments, "es:argument");
        eArgument1.appendChild(esPredicate1);
        eArgument2.appendChild(esPredicate2);
        return eOperator;
    }

    public Element addChildElement(Element parent, String sTag) {
        Element child = this.c8FilterDoc.createElementNS("http://developer.cognos.com/schemas/editSpecification/1/", sTag);
        parent.appendChild(child);
        return child;
    }

    public Node setText(Element parent, String sText) {
        Text childTxt = this.c8FilterDoc.createTextNode(sText);
        parent.appendChild(childTxt);
        return childTxt;
    }

    public Element addChildElementAndContents(Element parent, String sTag, String sContents) {
        Element child = this.c8FilterDoc.createElementNS("http://developer.cognos.com/schemas/editSpecification/1/", sTag);
        parent.appendChild(child);
        this.setText(child, sContents);
        return child;
    }

    public Element createNVPair(String name, Value value) {
        Element esValue = this.c8FilterDoc.createElementNS("http://developer.cognos.com/schemas/editSpecification/1/", "es:value");
        Element esValueDataItem = this.addChildElement(esValue, "es:dataItem");
        this.addChildElementAndContents(esValueDataItem, "es:name", name);
        Element esValueValue = this.addChildElement(esValue, "es:value");
        value.writeValueAsDOM(esValueValue, this);
        return esValue;
    }

    public String writeXmlToString() {
        try {
            DOMSource source = new DOMSource(this.c8FilterDoc);
            StringWriter str = new StringWriter();
            StreamResult result = new StreamResult(str);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            return str.toString();
        }
        catch (TransformerConfigurationException e) {
            System.out.println("TransformerConfigurationException: " + e);
        }
        catch (TransformerException e) {
            System.out.println("TransformerException: " + e);
        }
        return "";
    }

    public static class es {
        public static final String actions = "es:actions";
        public static final String andOperator = "operators#and";
        public static final String arguments = "es:arguments";
        public static final String argument = "es:argument";
        public static final String dataItem = "es:dataItem";
        public static final String editSpecification = "es:editSpecification";
        public static final String end = "es:end";
        public static final String expression = "es:expression";
        public static final String filter = "es:filter";
        public static final String name = "es:name";
        public static final String operator = "es:operator";
        public static final String orOperator = "operators#or";
        public static final String nullValue = "es:null";
        public static final String nullOrBlank = "es:nullOrBlank";
        public static final String range = "es:range";
        public static final String simple = "es:simple";
        public static final String start = "es:start";
        public static final String value = "es:value";
        public static final String xml_base = "xml:base";
        public static final String xml_ns_es = "xmlns:es";
        public static final String xml_ns_xsi = "xmlns:xsi";
        public static final String xsi_schemaLocation = "xsi:schemaLocation";
        public static final String xml_base_path = "http://developer.cognos.com/schemas/editSpecification/1/";
        public static final String esNS = "http://developer.cognos.com/schemas/editSpecification/1/";
        public static final String xsiNS = "http://www.w3.org/2001/XMLSchema-instance";
        public static final String xml_xsi_schemaLocation_path = "http://developer.cognos.com/schemas/editSpecification/1/ EditSpecification.xsd";
    }
}

